/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.model.RemoteContentProvider;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryComparator;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CheckoutWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ModuleSelectionPage
extends CVSWizardPage {
    Button useProjectNameButton;
    Button useSpecifiedNameButton;
    private Button selectModuleButton;
    private Button useModuleAndProjectNameButton;
    Text text;
    TreeViewer moduleList;
    String moduleName;
    private IProject project;
    private ICVSRepositoryLocation location;
    private boolean badLocation = false;
    private String helpContextId;
    private boolean supportsMultiSelection;
    private boolean isFetchingModules = false;
    private Object fetchingModulesLock = new Object();
    private String SEPARATOR = "/";

    public ModuleSelectionPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void setHelpContxtId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2, false);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.helpContextId);
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ModuleSelectionPage.this.updateEnablements(false);
            }
        };
        if (this.project != null) {
            this.useProjectNameButton = this.createRadioButton(composite, CVSUIMessages.ModuleSelectionPage_moduleIsProject, 2);
            this.useProjectNameButton.addListener(13, listener);
        }
        this.useSpecifiedNameButton = this.createRadioButton(composite, CVSUIMessages.ModuleSelectionPage_specifyModule, 1);
        this.useSpecifiedNameButton.addListener(13, listener);
        this.text = ModuleSelectionPage.createTextField(composite);
        this.text.addListener(24, listener);
        this.selectModuleButton = this.createRadioButton(composite, CVSUIMessages.ModuleSelectionPage_2, 2);
        this.selectModuleButton.addListener(13, listener);
        if (this.project != null) {
            this.useModuleAndProjectNameButton = new Button(composite, 32);
            this.useModuleAndProjectNameButton.setText(CVSUIMessages.ModuleSelectionPage_3);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            data.horizontalIndent = 10;
            this.useModuleAndProjectNameButton.setLayoutData((Object)data);
            this.useModuleAndProjectNameButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ModuleSelectionPage.this.updateText();
                }
            });
        }
        this.moduleList = this.createModuleTree(composite, 2);
        if (this.useProjectNameButton != null) {
            this.useProjectNameButton.setSelection(true);
            this.useSpecifiedNameButton.setSelection(false);
        } else {
            this.useSpecifiedNameButton.setSelection(true);
        }
        this.selectModuleButton.setSelection(false);
        if (this.useModuleAndProjectNameButton != null) {
            this.useModuleAndProjectNameButton.setSelection(false);
        }
        this.updateEnablements(false);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)parent);
    }

    private void updateText() {
        this.updateEnablements(false);
        ICVSRemoteFolder[] modules = this.internalGetSelectedModules();
        if (modules.length == 1) {
            ICVSRemoteFolder selectedModule = modules[0];
            String repositoryRelativePath = selectedModule.getRepositoryRelativePath();
            if (!repositoryRelativePath.equals("CVSROOT/Emptydir")) {
                this.text.setText(repositoryRelativePath);
            }
        } else {
            this.text.setText(this.useModuleAndProjectName() ? this.project.getName() : "");
        }
    }

    private boolean useModuleAndProjectName() {
        return this.useModuleAndProjectNameButton != null && this.useModuleAndProjectNameButton.getSelection();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IWizard w = this.getWizard();
            if (w instanceof CheckoutWizard) {
                ((CheckoutWizard)w).resetSubwizard();
            }
            if (this.useProjectNameButton != null && this.useProjectNameButton.getSelection()) {
                this.useProjectNameButton.setFocus();
            } else if (this.useSpecifiedNameButton.getSelection()) {
                this.text.setFocus();
            } else {
                this.moduleList.getControl().setFocus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnablements(boolean updateModulesList) {
        if (this.useProjectNameButton != null && this.useProjectNameButton.getSelection()) {
            this.text.setEnabled(false);
            this.moduleList.getControl().setEnabled(false);
            if (this.useModuleAndProjectNameButton != null) {
                this.useModuleAndProjectNameButton.setEnabled(false);
            }
            this.moduleName = null;
            this.setPageComplete(true);
        } else if (this.useSpecifiedNameButton.getSelection()) {
            this.text.setEnabled(true);
            this.moduleList.getControl().setEnabled(false);
            if (this.useModuleAndProjectNameButton != null) {
                this.useModuleAndProjectNameButton.setEnabled(false);
            }
            this.moduleName = this.text.getText();
            if (this.moduleName.length() == 0) {
                this.moduleName = null;
                this.setPageComplete(false);
            } else {
                this.setPageComplete(true);
            }
        } else if (!this.badLocation) {
            block39: {
                this.text.setEnabled(false);
                if (this.useModuleAndProjectNameButton != null) {
                    this.useModuleAndProjectNameButton.setEnabled(true);
                }
                this.moduleList.getControl().setEnabled(true);
                this.moduleName = null;
                if (this.moduleList.getInput() == null || updateModulesList) {
                    boolean fetchModules = false;
                    try {
                        Object object = this.fetchingModulesLock;
                        synchronized (object) {
                            if (!this.isFetchingModules) {
                                fetchModules = true;
                                this.isFetchingModules = true;
                            }
                        }
                        if (fetchModules) {
                            this.getContainer().run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    try {
                                        ModuleSelectionPage.this.validateLocation(monitor);
                                    }
                                    catch (CVSException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                            });
                            this.setModuleListInput();
                        }
                    }
                    catch (InvocationTargetException e) {
                        if (!this.badLocation) {
                            this.badLocation = true;
                            CVSUIPlugin.openError(this.getShell(), null, null, e);
                            this.setModuleListInput();
                        }
                        Object object = this.fetchingModulesLock;
                        synchronized (object) {
                            if (fetchModules) {
                                this.isFetchingModules = false;
                            }
                            break block39;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Object object;
                        try {
                            object = this.fetchingModulesLock;
                        }
                        catch (Throwable throwable) {
                            Object object2 = this.fetchingModulesLock;
                            synchronized (object2) {
                                if (fetchModules) {
                                    this.isFetchingModules = false;
                                }
                            }
                            throw throwable;
                        }
                        synchronized (object) {
                            if (fetchModules) {
                                this.isFetchingModules = false;
                            }
                            break block39;
                        }
                    }
                    Object object = this.fetchingModulesLock;
                    synchronized (object) {
                        if (fetchModules) {
                            this.isFetchingModules = false;
                        }
                    }
                }
            }
            this.setPageComplete(this.internalGetSelectedModules().length > 0);
        }
    }

    ICVSRemoteFolder[] internalGetSelectedModules() {
        if (this.moduleList != null && this.moduleList.getControl().isEnabled()) {
            ISelection selection = this.moduleList.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                ArrayList<Object> result = new ArrayList<Object>();
                Iterator iter = ss.iterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (!(element instanceof ICVSRemoteFolder)) continue;
                    if (this.useModuleAndProjectName()) {
                        String relativePath = ((ICVSRemoteFolder)element).getRepositoryRelativePath();
                        ICVSRemoteFolder remoteFolder = this.internalCreateModuleHandle(String.valueOf(relativePath) + this.SEPARATOR + this.project.getName())[0];
                        result.add(remoteFolder);
                        continue;
                    }
                    result.add(element);
                }
                return result.toArray(new ICVSRemoteFolder[result.size()]);
            }
        } else {
            if (this.moduleName != null) {
                return this.internalCreateModuleHandle(this.moduleName);
            }
            if (this.project != null) {
                return this.internalCreateModuleHandle(this.project.getName());
            }
        }
        return new ICVSRemoteFolder[0];
    }

    private ICVSRemoteFolder[] internalCreateModuleHandle(String name) {
        ICVSRepositoryLocation location = this.getLocation();
        if (location == null) {
            return new ICVSRemoteFolder[0];
        }
        String[] names = name.split(",");
        int length = names.length;
        ArrayList<ICVSRemoteFolder> folders = new ArrayList<ICVSRemoteFolder>();
        int i = 0;
        while (i < length) {
            String trimmedName = names[i].trim();
            if (trimmedName.length() > 0) {
                folders.add(location.getRemoteFolder(trimmedName, CVSTag.DEFAULT));
            }
            ++i;
        }
        return folders.toArray(new ICVSRemoteFolder[folders.size()]);
    }

    public ICVSRemoteFolder getSelectedModule() {
        ICVSRemoteFolder[] selectedModules = this.getSelectedModules();
        if (selectedModules.length > 0) {
            return selectedModules[0];
        }
        return null;
    }

    public ICVSRemoteFolder[] getSelectedModules() {
        final ICVSRemoteFolder[][] folder = new ICVSRemoteFolder[1][];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                folder[0] = ModuleSelectionPage.this.internalGetSelectedModules();
            }
        });
        return folder[0];
    }

    private TreeViewer createModuleTree(Composite composite, int horizontalSpan) {
        Tree tree = new Tree(composite, (this.supportsMultiSelection ? 2 : 4) | 0x800);
        GridData data = new GridData(1808);
        data.heightHint = Math.max(composite.getParent().getSize().y, 100);
        data.horizontalSpan = horizontalSpan;
        tree.setLayoutData((Object)data);
        TreeViewer result = new TreeViewer(tree){

            public boolean isExpandable(Object element) {
                ITreeContentProvider cp = (ITreeContentProvider)this.getContentProvider();
                if (cp == null) {
                    return false;
                }
                return cp.hasChildren(element);
            }
        };
        result.setContentProvider((IContentProvider)new RemoteContentProvider());
        result.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        result.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof ICVSRemoteFile);
            }
        });
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModuleSelectionPage.this.updateText();
            }
        });
        result.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (ModuleSelectionPage.this.getSelectedModule() != null) {
                    ModuleSelectionPage.this.gotoNextPage();
                }
            }
        });
        result.setComparator((ViewerComparator)new RepositoryComparator());
        return result;
    }

    private void setModuleListInput() {
        ICVSRepositoryLocation location = this.getLocation();
        if (location == null || this.badLocation) {
            return;
        }
        this.moduleList.setInput((Object)location.getRemoteFolder("", CVSTag.DEFAULT));
    }

    private ICVSRepositoryLocation getLocation() {
        return this.location;
    }

    public void setLocation(ICVSRepositoryLocation location) {
        boolean refresh = location != null && !location.equals(this.location);
        this.location = location;
        this.badLocation = false;
        if (this.moduleList != null) {
            this.updateEnablements(refresh);
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setSupportsMultiSelection(boolean supportsMultiSelection) {
        this.supportsMultiSelection = supportsMultiSelection;
    }

    void gotoNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    void validateLocation(IProgressMonitor monitor) throws CVSException {
        this.location.validateConnection(monitor);
    }
}

