/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinePreferencePage;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class ApiUseScanConfigurationBlock {
    private static final Key KEY_API_USE_SCAN_TYPE_PROBLEM = ApiUseScanConfigurationBlock.getApiToolsKey("API_USE_SCAN_TYPE_SEVERITY");
    private static final Key KEY_API_USE_SCAN_METHOD_PROBLEM = ApiUseScanConfigurationBlock.getApiToolsKey("API_USE_SCAN_METHOD_SEVERITY");
    private static final Key KEY_API_USE_SCAN_FIELD_PROBLEM = ApiUseScanConfigurationBlock.getApiToolsKey("API_USE_SCAN_FIELD_SEVERITY");
    private static Key[] fgAllKeys = new Key[]{KEY_API_USE_SCAN_TYPE_PROBLEM, KEY_API_USE_SCAN_METHOD_PROBLEM, KEY_API_USE_SCAN_FIELD_PROBLEM};
    private static final String[] SEVERITIES_LABELS = new String[]{PreferenceMessages.ApiErrorsWarningsConfigurationBlock_error, PreferenceMessages.ApiErrorsWarningsConfigurationBlock_warning, PreferenceMessages.ApiErrorsWarningsConfigurationBlock_ignore};
    private static final String[] SEVERITIES = new String[]{"Error", "Warning", "Ignore"};
    private SelectionListener selectionlistener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Combo) {
                Combo combo = (Combo)e.widget;
                ControlData data = (ControlData)combo.getData();
                data.key.setStoredValue(ApiUseScanConfigurationBlock.this.fLookupOrder[0], combo.getText(), ApiUseScanConfigurationBlock.this.fManager);
                ApiBaselinePreferencePage.rebuildcount = 0;
            }
        }
    };
    private Combo[] fCombo = null;
    IScopeContext[] fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    IWorkingCopyManager fManager = null;
    private Composite fMainComp = null;
    private IdentityHashMap fOldProjectSettings = null;

    protected static final Key getApiToolsKey(String key) {
        return new Key("org.eclipse.pde.api.tools", key);
    }

    public ApiUseScanConfigurationBlock(IWorkingCopyManager manager) {
        this.fManager = manager;
        this.fOldProjectSettings = null;
    }

    public Control createControl(Composite parent) {
        this.fMainComp = SWTFactory.createComposite(parent, 1, 1, 768, 0, 0);
        Group optionsProfileGroup = SWTFactory.createGroup(this.fMainComp, PreferenceMessages.ApiUseScanConfigurationBlock_0, 2, 1, 1808);
        this.fCombo = new Combo[3];
        this.fCombo[0] = this.createComboControl((Composite)optionsProfileGroup, PreferenceMessages.ApiUseScanConfigurationBlock_unresolvedTypeProblem, KEY_API_USE_SCAN_TYPE_PROBLEM);
        this.fCombo[1] = this.createComboControl((Composite)optionsProfileGroup, PreferenceMessages.ApiUseScanConfigurationBlock_unresolvedMethodProblem, KEY_API_USE_SCAN_METHOD_PROBLEM);
        this.fCombo[2] = this.createComboControl((Composite)optionsProfileGroup, PreferenceMessages.ApiUseScanConfigurationBlock_unresolvedFieldProblem, KEY_API_USE_SCAN_FIELD_PROBLEM);
        Dialog.applyDialogFont((Control)this.fMainComp);
        return this.fMainComp;
    }

    public void performOK() {
        this.save();
    }

    public void performApply() {
        this.save();
    }

    private void save() {
        try {
            ArrayList changes = new ArrayList();
            this.collectChanges(this.fLookupOrder[0], changes);
            if (changes.size() > 0) {
                this.fManager.applyChanges();
            }
        }
        catch (BackingStoreException bse) {
            ApiPlugin.log((Throwable)bse);
        }
    }

    public void performCancel() {
    }

    public void performDefaults() {
        String defval = null;
        int i = 0;
        while (i < fgAllKeys.length) {
            defval = fgAllKeys[i].getStoredValue(this.fLookupOrder, true, this.fManager);
            fgAllKeys[i].setStoredValue(this.fLookupOrder[0], defval, this.fManager);
            ++i;
        }
        this.updateCombos();
    }

    private void updateCombos() {
        if (this.fCombo != null) {
            int i = 0;
            while (i < this.fCombo.length) {
                ControlData data = (ControlData)this.fCombo[i].getData();
                this.fCombo[i].select(data.getSelection(data.getKey().getStoredValue(this.fLookupOrder, false, this.fManager)));
                ++i;
            }
        }
    }

    public void dispose() {
        this.fMainComp.getParent().dispose();
    }

    protected Combo createComboControl(Composite parent, String label, Key key) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(1, 2, true, false);
        lbl.setLayoutData((Object)gd);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        gd = new GridData(3, 2, false, false);
        combo.setLayoutData((Object)gd);
        ControlData data = new ControlData(key, SEVERITIES);
        combo.setData((Object)data);
        combo.setItems(SEVERITIES_LABELS);
        combo.addSelectionListener(this.selectionlistener);
        combo.select(data.getSelection(key.getStoredValue(this.fLookupOrder, false, this.fManager)));
        return combo;
    }

    private void collectChanges(IScopeContext context, List changes) {
        Key key = null;
        String origval = null;
        String newval = null;
        boolean complete = this.fOldProjectSettings == null;
        int i = 0;
        while (i < fgAllKeys.length) {
            key = fgAllKeys[i];
            origval = key.getStoredValue(context, null);
            newval = key.getStoredValue(context, this.fManager);
            if (newval == null) {
                if (origval != null) {
                    changes.add(key);
                } else if (complete) {
                    key.setStoredValue(context, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changes.add(key);
                }
            } else if (!newval.equals(origval)) {
                changes.add(key);
            }
            ++i;
        }
    }

    public static Key[] getAllKeys() {
        return fgAllKeys;
    }

    public void setEnabled(boolean enabled) {
        this.fMainComp.setEnabled(enabled);
        int i = 0;
        while (i < this.fCombo.length) {
            this.fCombo[i].setEnabled(enabled);
            ++i;
        }
    }

    protected static class ControlData {
        Key key;
        private String[] values;

        public ControlData(Key key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public Key getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }

    protected static class Key {
        private String qualifier;
        private String key;

        public Key(String qualifier, String key) {
            this.qualifier = qualifier;
            this.key = key;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.qualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (node != null) {
                return node.get(this.key, null);
            }
            return null;
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (value != null) {
                node.put(this.key, value);
            } else {
                node.remove(this.key);
            }
        }

        public String toString() {
            return String.valueOf(this.qualifier) + '/' + this.key;
        }
    }
}

