/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteSearchManager;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.LocalSearchManager;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.federated.FederatedSearchEntry;
import org.eclipse.help.internal.search.federated.FederatedSearchJob;

public class SearchManager {
    private LocalSearchManager localManager = new LocalSearchManager();
    private RemoteSearchManager remoteManager = new RemoteSearchManager();

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        if (RemoteHelp.isEnabled()) {
            this.searchLocalAndRemote(searchQuery, collector, pm);
        } else {
            this.searchLocal(searchQuery, collector, pm);
        }
    }

    public void searchLocal(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        this.localManager.search(searchQuery, collector, pm);
    }

    public void searchLocalAndRemote(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        SearchState state = new SearchState();
        state.searchQuery = searchQuery;
        pm.beginTask("", 100);
        state.localMonitor = new SubProgressMonitor(pm, 50, 2);
        state.remoteMonitor = new SubProgressMonitor(pm, 50, 2);
        state.localSearchJob.schedule();
        state.remoteSearchJob.schedule();
        try {
            state.localSearchJob.join();
            state.remoteSearchJob.join();
        }
        catch (InterruptedException e) {
            String msg = "Unexpected InterruptedException while waiting for help search jobs to finish";
            HelpBasePlugin.logError(msg, e);
        }
        state.bufferedCollector.flush(collector);
        pm.done();
    }

    public void search(String expression, FederatedSearchEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            FederatedSearchJob job = new FederatedSearchJob(expression, entries[i]);
            job.schedule();
            ++i;
        }
    }

    public LocalSearchManager getLocalSearchManager() {
        return this.localManager;
    }

    public RemoteSearchManager getRemoteSearchManager() {
        return this.remoteManager;
    }

    public void close() {
        this.localManager.close();
    }

    static /* synthetic */ LocalSearchManager access$0(SearchManager searchManager) {
        return searchManager.localManager;
    }

    static /* synthetic */ RemoteSearchManager access$1(SearchManager searchManager) {
        return searchManager.remoteManager;
    }

    private class BufferedSearchHitCollector
    implements ISearchHitCollector {
        private Set allHits = new HashSet();
        private String wordsSearched = null;

        private BufferedSearchHitCollector() {
        }

        public void addHits(List hits, String wordsSearched) {
            if (wordsSearched != null) {
                this.wordsSearched = wordsSearched;
            }
            this.allHits.addAll(hits);
        }

        public void flush(ISearchHitCollector collector) {
            ArrayList hitsList = new ArrayList(this.allHits);
            Collections.sort(hitsList);
            collector.addHits(hitsList, this.wordsSearched);
            this.allHits.clear();
            this.wordsSearched = null;
        }

        public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
            throw exception;
        }
    }

    private class SearchState {
        public IProgressMonitor localMonitor;
        public IProgressMonitor remoteMonitor;
        public ISearchQuery searchQuery;
        public BufferedSearchHitCollector bufferedCollector;
        public Job localSearchJob;
        public Job remoteSearchJob;

        public SearchState() {
            this.bufferedCollector = new BufferedSearchHitCollector();
            this.localSearchJob = new Job(this, "localSearchJob"){
                final /* synthetic */ SearchState this$1;
                {
                    this.this$1 = searchState;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    SearchManager.access$0(SearchState.access$0(this.this$1)).search(this.this$1.searchQuery, this.this$1.bufferedCollector, this.this$1.localMonitor);
                    return Status.OK_STATUS;
                }
            };
            this.remoteSearchJob = new Job(this, "remoteSearchJob"){
                final /* synthetic */ SearchState this$1;
                {
                    this.this$1 = searchState;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    SearchManager.access$1(SearchState.access$0(this.this$1)).search(this.this$1.searchQuery, this.this$1.bufferedCollector, this.this$1.remoteMonitor);
                    return Status.OK_STATUS;
                }
            };
            this.localSearchJob.setSystem(true);
            this.remoteSearchJob.setSystem(true);
        }

        static /* synthetic */ SearchManager access$0(SearchState searchState) {
            return searchState.SearchManager.this;
        }
    }
}

