/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.EclipseLog;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class EclipseLogHook
implements HookConfigurator,
AdaptorHook {
    private static final String LOG_EXT = ".log";
    BaseAdaptor adaptor;
    static /* synthetic */ Class class$0;

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addAdaptorHook(this);
    }

    public void initialize(BaseAdaptor initAdaptor) {
        this.adaptor = initAdaptor;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AdaptorUtil.register(clazz.getName(), this.adaptor.getFrameworkLog(), context);
        this.registerPerformanceLog(context);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
    }

    public void frameworkStopping(BundleContext context) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String location) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public FrameworkLog createFrameworkLog() {
        EclipseLog frameworkLog;
        String logFileProp = FrameworkProperties.getProperty("osgi.logfile");
        if (logFileProp != null) {
            frameworkLog = new EclipseLog(new File(logFileProp));
        } else {
            Location location = LocationManager.getConfigurationLocation();
            File configAreaDirectory = null;
            if (location != null) {
                configAreaDirectory = new File(location.getURL().getFile());
            }
            if (configAreaDirectory != null) {
                String logFileName = String.valueOf(Long.toString(System.currentTimeMillis())) + LOG_EXT;
                File logFile = new File(configAreaDirectory, logFileName);
                FrameworkProperties.setProperty("osgi.logfile", logFile.getAbsolutePath());
                frameworkLog = new EclipseLog(logFile);
            } else {
                frameworkLog = new EclipseLog();
            }
        }
        if ("true".equals(FrameworkProperties.getProperty("eclipse.consoleLog"))) {
            frameworkLog.setConsoleLog(true);
        }
        return frameworkLog;
    }

    private void registerPerformanceLog(BundleContext context) {
        FrameworkLog service = this.createPerformanceLog();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.log.FrameworkLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String serviceName = clazz.getName();
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>(7);
        Dictionary<String, String> headers = context.getBundle().getHeaders();
        ((Dictionary)serviceProperties).put("service.vendor", headers.get("Bundle-Vendor"));
        ((Dictionary)serviceProperties).put("service.ranking", new Integer(Integer.MIN_VALUE));
        ((Dictionary)serviceProperties).put("service.pid", String.valueOf(context.getBundle().getBundleId() + 46L) + service.getClass().getName());
        ((Dictionary)serviceProperties).put("performance", Boolean.TRUE.toString());
        context.registerService(serviceName, (Object)service, serviceProperties);
    }

    private FrameworkLog createPerformanceLog() {
        int lastSlash;
        String logFileProp = FrameworkProperties.getProperty("osgi.logfile");
        if (logFileProp != null && (lastSlash = logFileProp.lastIndexOf(File.separatorChar)) > 0) {
            String logFile = String.valueOf(logFileProp.substring(0, lastSlash + 1)) + "performance.log";
            return new EclipseLog(new File(logFile));
        }
        return new EclipseLog(new PrintWriter(System.err));
    }
}

