/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

class MinimizedFileSystemElement
implements IWorkbenchAdapter,
IAdaptable {
    private boolean populated = false;
    private List folders = null;
    private List files = null;
    private String name;
    private boolean isDirectory = false;
    private MinimizedFileSystemElement parent;
    private Object fileSystemObject;
    static /* synthetic */ Class class$0;

    public MinimizedFileSystemElement(String name, MinimizedFileSystemElement parent, boolean isDirectory) {
        this.name = name;
        this.parent = parent;
        this.isDirectory = isDirectory;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private void addChild(MinimizedFileSystemElement child) {
        if (child.isDirectory()) {
            if (this.folders == null) {
                this.folders = new ArrayList(1);
            }
            this.folders.add(child);
        } else {
            if (this.files == null) {
                this.files = new ArrayList(1);
            }
            this.files.add(child);
        }
    }

    protected List getFiles(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        if (this.files == null) {
            return Collections.EMPTY_LIST;
        }
        return this.files;
    }

    protected List getFolders(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        return this.getFolders();
    }

    protected List getFolders() {
        if (this.folders == null) {
            return Collections.EMPTY_LIST;
        }
        return this.folders;
    }

    protected boolean isPopulated() {
        return this.populated;
    }

    protected boolean notPopulated() {
        return !this.populated;
    }

    private void populate(IImportStructureProvider provider) {
        ArrayList children = provider.getChildren(this.fileSystemObject);
        if (children == null) {
            children = new ArrayList(1);
        }
        Iterator childrenEnum = children.iterator();
        while (childrenEnum.hasNext()) {
            Object child = childrenEnum.next();
            String elementLabel = provider.getLabel(child);
            boolean isFolder = provider.isFolder(child);
            if (!isFolder && !elementLabel.endsWith(".class")) continue;
            MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, this, isFolder);
            result.setFileSystemObject(child);
        }
        this.setPopulated();
    }

    protected Object getFileSystemObject() {
        return this.fileSystemObject;
    }

    protected void setFileSystemObject(Object value) {
        this.fileSystemObject = value;
    }

    protected void setPopulated() {
        this.populated = true;
    }

    public Object[] getChildren(Object o) {
        return this.getFolders().toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.isDirectory()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.name);
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }
}

