/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.api.SearchEvent;
import org.eclipse.platform.discovery.core.internal.ISearchConsoleView;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.IDestinationChangeHandler;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.api.SearchFailedException;
import org.eclipse.platform.discovery.runtime.api.SearchFailedForKnownReasonException;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.SearchProviderConfigurationFactory;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.api.impl.DefaultSessionIds;
import org.eclipse.platform.discovery.ui.internal.SlidingComposite;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIPlugin;
import org.eclipse.platform.discovery.ui.internal.search.customparams.CustomSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.search.customparams.ICustomSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.selector.ComboSelector;
import org.eclipse.platform.discovery.ui.internal.selector.InteractiveComboSelector;
import org.eclipse.platform.discovery.ui.internal.util.ControlBackgroundImageManager;
import org.eclipse.platform.discovery.ui.internal.view.ICustomizableView;
import org.eclipse.platform.discovery.ui.internal.view.impl.AbstractDiscoveryView;
import org.eclipse.platform.discovery.ui.internal.view.impl.IControlValueSelector;
import org.eclipse.platform.discovery.ui.internal.view.impl.ITabbedSessionDisplayer;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchConsoleDestinationsSelector;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchForSelectionChangeListener;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchParameters;
import org.eclipse.platform.discovery.ui.internal.view.impl.SubdestinationsSelectedListener;
import org.eclipse.platform.discovery.ui.internal.view.impl.TextControl;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.ContributedUIFactory;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.TabbedSessionDisplayer;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SearchConsoleView
extends AbstractDiscoveryView<ISearchConsoleControllerOutputView, ISearchConsoleController>
implements ISearchConsoleView,
ICustomizableView,
IMasterDiscoveryView,
ISearchConsoleControllerOutputView {
    public static final int UI_IN_CONTROL_SPACING = 5;
    private IControlValueSelector<IObjectTypeDescription, Combo> searchForComboViewer;
    private IControlValueSelector<GroupingHierarchy, Combo> groupingHierarchySelector;
    private static final String DROP_DOWN_ICON_LOCATION = "icon-dropdown-keyword-ALT.gif";
    private SearchConsoleDestinationsSelector destinationsSelector;
    private ICustomSearchParamsDisplayer customSearchParamsDisplayer;
    private ITabbedSessionDisplayer<ISearchContext> sdm;
    private IProgressMonitor viewProgressMonitor;
    private String defaultSessionId;
    private TextControl keywordTextControl;
    private Label openSubdestinationsButton;
    private Button searchButton;
    private Hyperlink manageConfigurationHyperlink;
    private SlidingComposite slidingComposite;
    private Composite fixedSearchParamComposite;
    private Composite customSearchParamsComposite;
    private Composite bottomComposite;
    private Composite upperComposite;
    private Composite keywordComposite;
    private final Cursor hyperlinkCursor;
    private final Property<Point> upperCompositeSizeProperty = new Property();
    private final Property<SlidingComposite.ORIENTATION> currentOrientation;
    private ControlBackgroundImageManager fixedSearchParamCompositeBgImageManager;
    private ControlBackgroundImageManager destinationSelectorBgImageManager;
    private ISearchConsoleController controller;

    public SearchConsoleView() {
        this.upperCompositeSizeProperty.set((Object)new Point(0, 0));
        this.hyperlinkCursor = new Cursor((Device)PlatformUI.getWorkbench().getDisplay(), 21);
        this.currentOrientation = new Property();
        this.currentOrientation.set((Object)SlidingComposite.ORIENTATION.VERTICAL);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.slidingComposite = new SlidingComposite(parent, this.formToolkit){

            @Override
            protected void configureUpperComposite(Composite upperComposite) {
                SearchConsoleView.this.configureUpperComposite(upperComposite, this.getFormToolkit());
            }

            @Override
            protected void configureBottomComposite(Composite bottomComposite) {
                SearchConsoleView.this.bottomComposite = bottomComposite;
                SearchConsoleView.this.sdm = SearchConsoleView.this.createSessionsDisplayer();
                bottomComposite.setLayout((Layout)new FillLayout());
            }

            @Override
            protected void onOrientationChange(SlidingComposite.ORIENTATION newOrientation) {
                SearchConsoleView.this.currentOrientation.set((Object)newOrientation);
            }
        };
        this.viewProgressMonitor = this.slidingComposite.getProgressMonitor();
        this.getProgressMonitor().beginTask(DiscoveryUIMessages.INITIALIZATION_IN_PROGRESS_TASK, -1);
        this.upperCompositeSizeProperty.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<Point>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Point> event) {
                SearchConsoleView.this.slidingComposite.upperCompositeSizeChanged(event);
            }
        }, false);
        this.fixedSearchParamComposite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (SearchConsoleView.this.searchButton.isEnabled() && e.detail == 4) {
                    SearchConsoleView.this.search();
                }
            }
        });
        this.customSearchParamsDisplayer.registerSizePropertyChangeListener(new IPropertyAttributeListener<Point>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Point> event) {
                Point newSize = SearchConsoleView.this.computeUpperCompositeSize(SearchConsoleView.this.fixedSearchParamComposite.getSize(), (Point)event.getNewAttribute(), SearchConsoleView.this.searchButton.getSize(), (SlidingComposite.ORIENTATION)((Object)SearchConsoleView.this.currentOrientation.get()));
                SearchConsoleView.this.upperCompositeSizeProperty.set((Object)newSize);
            }
        }, false);
        this.currentOrientation.registerValueListener((IPropertyAttributeListener)new OrientationChangedListener(), true);
        parent.layout(true, true);
        this.upperCompositeSizeProperty.set((Object)this.upperComposite.computeSize(-1, -1));
    }

    protected ITabbedSessionDisplayer<ISearchContext> createSessionsDisplayer() {
        TabbedSessionDisplayer<ISearchContext> sd = new TabbedSessionDisplayer<ISearchContext>(this.bottomComposite, new ContributedUIFactory(this), 0x800002);
        sd.getControl().setSelectionBackground(new Color[]{this.getGradientStart(), this.getGradientEnd()}, new int[]{80}, true);
        return sd;
    }

    protected ISearchProviderConfiguration getSearchProviderConfiguration() {
        return SearchProviderConfigurationFactory.getDefault();
    }

    public void setFocus() {
        if (this.bottomComposite != null) {
            this.bottomComposite.setFocus();
        }
    }

    public void showDestinationsCategories(Set<IDestinationCategoryDescription> categories) {
        this.destinationsSelector.setEnabled(categories.size() > 0);
        this.destinationsSelector.setInput(categories);
    }

    public void showObjectTypes(Set<IObjectTypeDescription> objectTypes) {
        this.searchForComboViewer.setInput(objectTypes);
    }

    public void showResult(ISearchContext searchContext) {
        String sessionId = searchContext.session().getId();
        if (searchContext.session().getId().equals(this.defaultSessionId)) {
            this.sdm.setSessionUnclosable(sessionId);
        }
        this.sdm.display((ISession<ISearchContext>)searchContext.session());
        this.slidingComposite.notifyBottomCompositeContentChanged(DiscoveryUIMessages.SearchConsoleView_SearchFinished, DiscoveryUIMessages.SearchConsoleView_SearchResultsAvailable);
    }

    @Override
    public void registerViewCustomization(IGenericViewCustomization customization) {
        if (!(customization instanceof ISearchConsoleCustomization)) {
            throw new IllegalArgumentException("The view customization must be instance of ISearchConsoleCustomization");
        }
        super.registerViewCustomization(customization);
    }

    private void createSearchForComposite(Composite parent, FormToolkit formToolkit, int secondColumnPosition) {
        this.searchForComboViewer = new ComboSelector<IObjectTypeDescription>(parent, formToolkit, this.getSearchProviderConfiguration().getObjectTypes(), DiscoveryUIMessages.SEARCH_FOR_LIST_VIEWER_LABEL, secondColumnPosition, null);
        this.searchForComboViewer.registerSelectionChangedListener(new SearchForSelectionChangeListener(){

            @Override
            protected void objectTypeSelected(IObjectTypeDescription objectType) {
                SearchConsoleView.this.controller.objectTypeSelected(objectType);
            }
        });
    }

    private void createSearchInComposite(Composite parent, FormToolkit formToolkit, int secondColumnPosition, Control offset) {
        this.destinationsSelector = new SearchConsoleDestinationsSelector(parent, formToolkit, secondColumnPosition, offset, this.getSearchProviderConfiguration()){

            public void handleSelectionChange(Set<ISearchDestination> newSelection) {
                SearchConsoleView.this.keywordTextControl.setEnabled(!newSelection.isEmpty() && SearchConsoleView.this.getSelectedActiveSearchProviderDescription() != null && SearchConsoleView.this.getSelectedActiveSearchProviderDescription().supportsTextSearch());
                this.updateKeywordTextMessage(newSelection);
                SearchConsoleView.this.searchButton.setEnabled(!newSelection.isEmpty());
                SearchConsoleView.this.customSearchParamsDisplayer.update(SearchConsoleView.this.getSelectedObjectType(), newSelection.isEmpty() ? null : newSelection.iterator().next(), SearchConsoleView.this.getEnvironment(), SearchConsoleView.this.uiContext());
                SearchConsoleView.this.customSearchParamsComposite.setLayoutData((Object)SearchConsoleView.this.createAdvancedOptionsFormData(SearchConsoleView.this.fixedSearchParamComposite, (SlidingComposite.ORIENTATION)((Object)SearchConsoleView.this.currentOrientation.get()), SearchConsoleView.this.customSearchParamsDisplayer.isEnabled()));
                if (newSelection.isEmpty() || SearchConsoleView.this.getSelectedActiveSearchProviderDescription() == null) {
                    SearchConsoleView.this.openSubdestinationsButton.setEnabled(false);
                    SearchConsoleView.this.controller.searchDestinationSelected((IObjectTypeDescription)SearchConsoleView.this.searchForComboViewer.getSelectedItem(), null);
                } else {
                    ISearchProviderDescription searchProviderDescr = SearchConsoleView.this.getSelectedActiveSearchProviderDescription();
                    Set allSubdestintations = SearchConsoleView.this.getSearchProviderConfiguration().getAvailableSearchSubdestinations(SearchConsoleView.this.getSelectedObjectType(), SearchConsoleView.this.getDestinationCategory(newSelection.iterator().next()), searchProviderDescr);
                    SearchConsoleView.this.openSubdestinationsButton.setEnabled(allSubdestintations.size() > 0);
                    SearchConsoleView.this.controller.searchDestinationSelected((IObjectTypeDescription)SearchConsoleView.this.searchForComboViewer.getSelectedItem(), newSelection.iterator().next());
                }
                SearchConsoleView.this.upperComposite.layout(true, true);
            }

            private void updateKeywordTextMessage(Set<ISearchDestination> selectedDestinations) {
                if (selectedDestinations.isEmpty()) {
                    SearchConsoleView.this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_NoDestinationSelectedHint);
                    return;
                }
                ISearchProviderDescription currentSearchProvider = SearchConsoleView.this.getSelectedActiveSearchProviderDescription();
                if (currentSearchProvider != null && currentSearchProvider.supportsTextSearch()) {
                    SearchConsoleView.this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_EnterKeywordHint);
                } else {
                    SearchConsoleView.this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_UnsupportedTextSearch);
                }
            }
        };
        this.destinationsSelector.registerDestinationsChangeHandler(new IDestinationChangeHandler(){

            public void handleDestinationsChange() {
                SearchConsoleView.this.controller.searchDestinationsChanged();
            }
        });
        this.destinationsSelector.setEnabled(false);
    }

    private void createKeywordSearchComposite(Composite parent, FormToolkit formToolkit, int secondColumnPosition, Control offset) {
        this.keywordComposite = new Composite(parent, 0);
        this.keywordComposite.setLayout((Layout)new FormLayout());
        FormData keyCompFormData = new FormData();
        keyCompFormData.top = new FormAttachment(offset, 5);
        keyCompFormData.left = new FormAttachment(0, 0);
        keyCompFormData.right = new FormAttachment(100, 0);
        this.keywordComposite.setLayoutData((Object)keyCompFormData);
        Label searchLabel = new Label(this.keywordComposite, 0);
        searchLabel.setText(DiscoveryUIMessages.SEARCH_KEYWORD_LABEL);
        FormData labelFormData = new FormData();
        labelFormData.top = new FormAttachment(offset, 5);
        labelFormData.left = new FormAttachment(0, 5);
        searchLabel.setLayoutData((Object)labelFormData);
        this.openSubdestinationsButton = new Label(this.keywordComposite, 0);
        FormData subDestButtonFormData = new FormData();
        subDestButtonFormData.left = new FormAttachment(100, -25);
        subDestButtonFormData.right = new FormAttachment(100, -5);
        this.openSubdestinationsButton.setLayoutData((Object)subDestButtonFormData);
        this.openSubdestinationsButton.setImage(this.dropDownButtonImage());
        Text keywordText = formToolkit.createText(this.keywordComposite, "", 2176);
        FormData keywordTextFormData = new FormData();
        keywordTextFormData.left = new FormAttachment(0, secondColumnPosition + 10);
        keywordTextFormData.right = new FormAttachment((Control)this.openSubdestinationsButton, -5);
        keywordText.setLayoutData((Object)keywordTextFormData);
        this.keywordTextControl = new TextControl(keywordText, searchLabel);
        this.keywordTextControl.setEnabled(false);
        this.keywordTextControl.setMessage(DiscoveryUIMessages.SearchConsoleView_NoDestinationSelectedHint);
        this.openSubdestinationsButton.setEnabled(false);
    }

    private void createGroupByComposite(Composite parent, FormToolkit formToolkit, int leftLabelsSize, Control offset) {
        this.groupingHierarchySelector = new InteractiveComboSelector(parent, formToolkit, new HashSet(), DiscoveryUIMessages.GROUP_BY_LABEL, leftLabelsSize, offset);
        this.groupingHierarchySelector.setEnabled(false);
    }

    private void createHyperLink(final Composite parent, FormToolkit formToolkit) {
        this.manageConfigurationHyperlink = new Hyperlink(parent, 0);
        this.manageConfigurationHyperlink.setText(DiscoveryUIMessages.SearchConsoleView_MANAGED_CONFIGS_LINK);
        this.manageConfigurationHyperlink.setForeground(formToolkit.getHyperlinkGroup().getActiveForeground());
        this.manageConfigurationHyperlink.setUnderlined(true);
        this.manageConfigurationHyperlink.setCursor(this.hyperlinkCursor);
        final LinkedList<String> prefPageIDs = new LinkedList<String>();
        for (IDestinationsProviderDescription provider : this.getSearchProviderConfiguration().getAvailableDestinationProviders()) {
            if (provider.getPreferencePageId() == null) continue;
            prefPageIDs.add(provider.getPreferencePageId());
        }
        this.manageConfigurationHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog pageDialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), null, (String[])prefPageIDs.toArray(new String[prefPageIDs.size()]), null);
                pageDialog.getTreeViewer().expandAll();
                pageDialog.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        FormData linkFormData = new FormData();
        linkFormData.top = new FormAttachment(this.destinationsSelector.getControl(), 5);
        linkFormData.right = new FormAttachment(100, -5);
        this.manageConfigurationHyperlink.setLayoutData((Object)linkFormData);
    }

    private void configureUpperComposite(Composite upComposite, FormToolkit formToolkit) {
        this.upperComposite = upComposite;
        int leftLabelsSize = this.getLongestLabelSize(this.getLeftSideLabels());
        this.fixedSearchParamComposite = new Composite(this.upperComposite, 0);
        this.fixedSearchParamComposite.setLayout((Layout)new FormLayout());
        this.fixedSearchParamComposite.setLayoutData((Object)this.createFixedParamsFormData((SlidingComposite.ORIENTATION)((Object)this.currentOrientation.get())));
        this.createSearchForComposite(this.fixedSearchParamComposite, formToolkit, leftLabelsSize);
        this.createSearchInComposite(this.fixedSearchParamComposite, formToolkit, leftLabelsSize, this.searchForComboViewer.getControl());
        this.createHyperLink(this.fixedSearchParamComposite, formToolkit);
        this.createKeywordSearchComposite(this.fixedSearchParamComposite, formToolkit, leftLabelsSize, (Control)this.manageConfigurationHyperlink);
        this.createGroupByComposite(this.fixedSearchParamComposite, formToolkit, leftLabelsSize, (Control)this.keywordComposite);
        this.fixedSearchParamComposite.setBackground(this.getGradientEnd());
        this.fixedSearchParamComposite.setForeground(this.getGradientStart());
        this.fixedSearchParamComposite.setBackgroundMode(1);
        this.customSearchParamsComposite = new Composite(this.upperComposite, 0);
        this.adaptCustomSearchParamsComposite(this.customSearchParamsComposite, this.fixedSearchParamComposite, false);
        this.customSearchParamsDisplayer = this.createCustomSearchParamsDisplayer(this.customSearchParamsComposite, formToolkit);
        this.searchButton = new Button(this.upperComposite, 0x800008);
        this.searchButton.setText(DiscoveryUIMessages.SEARCH_BUTTON_LABEL);
        FormData buttonData = this.createSearchButtonCompositeFormData((SlidingComposite.ORIENTATION)((Object)this.currentOrientation.get()));
        this.searchButton.setLayoutData((Object)buttonData);
        this.searchButton.setEnabled(false);
        this.installSubdestinationSelectionListener();
        this.installSearchForSelectionChangeListener();
        this.installSearchButtonListener();
        this.upperComposite.layout();
        this.createGradient();
    }

    private void adjustUpperCompositeLayoutData(SlidingComposite.ORIENTATION orientation) {
        this.fixedSearchParamComposite.setLayoutData((Object)this.createFixedParamsFormData(orientation));
        this.searchButton.setLayoutData((Object)this.createSearchButtonCompositeFormData(orientation));
        this.customSearchParamsComposite.setLayoutData((Object)this.createAdvancedOptionsFormData(this.fixedSearchParamComposite, orientation, this.customSearchParamsDisplayer.isEnabled()));
    }

    private FormData createFixedParamsFormData(SlidingComposite.ORIENTATION orientation) {
        FormData fixedData = new FormData();
        fixedData.left = new FormAttachment(0, 0);
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            fixedData.right = new FormAttachment(100, 0);
        } else {
            fixedData.width = this.fixedSearchParamComposite.computeSize((int)-1, (int)-1).x;
        }
        return fixedData;
    }

    private FormData createSearchButtonCompositeFormData(SlidingComposite.ORIENTATION orientation) {
        FormData buttonData = new FormData();
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            buttonData.top = new FormAttachment((Control)this.customSearchParamsComposite, 5);
            buttonData.right = new FormAttachment(100, -5);
        } else {
            buttonData.top = new FormAttachment((Control)this.fixedSearchParamComposite, 5);
            buttonData.right = new FormAttachment(0, this.fixedSearchParamComposite.computeSize((int)-1, (int)-1).x);
        }
        return buttonData;
    }

    private FormData createAdvancedOptionsFormData(Composite fixedSearchParamComposite, SlidingComposite.ORIENTATION orientation, boolean enabled) {
        FormData fd = new FormData();
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            fd.top = new FormAttachment((Control)fixedSearchParamComposite);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            fd.height = enabled ? -1 : 0;
            fd.width = -1;
        } else {
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment((Control)fixedSearchParamComposite, 5);
            fd.right = new FormAttachment(100, 0);
            fd.width = enabled ? -1 : 0;
            fd.height = -1;
        }
        return fd;
    }

    private Composite adaptCustomSearchParamsComposite(Composite customSearchParamsComposite, Composite fixedSearchParamComposite, boolean enabled) {
        customSearchParamsComposite.setLayout((Layout)new FormLayout());
        FormData fd = this.createAdvancedOptionsFormData(fixedSearchParamComposite, (SlidingComposite.ORIENTATION)((Object)this.currentOrientation.get()), enabled);
        customSearchParamsComposite.setLayoutData((Object)fd);
        return customSearchParamsComposite;
    }

    private void search() {
        try {
            SearchParameters params = new SearchParameters(this.getSelectedObjectType().getId(), this.getSelectedDestination(), this.keywordTextControl.get(), (GroupingHierarchy)this.groupingHierarchySelector.getSelectedItem(), this.activeSubdestinations());
            this.customSearchParamsDisplayer.setCustomParams(params);
            SearchEvent searchEvent = new SearchEvent((ISearchParameters)params, DefaultSessionIds.mainSearchSessionId, DiscoveryUIMessages.SEARCH_RESULT_TAB, null);
            this.controller.search(searchEvent);
        }
        catch (ProviderNotFoundException e1) {
            throw new IllegalStateException(e1);
        }
        catch (SearchFailedForKnownReasonException exc) {
            this.getEnvironment().errorHandler().showError(null, exc.getLocalizedMessage());
            this.logger().logDebug(exc.getMessage(), (Throwable)exc);
        }
        catch (SearchFailedException exc) {
            this.getEnvironment().errorHandler().handleException((Exception)((Object)exc));
        }
    }

    private ILogger logger() {
        return Logger.instance();
    }

    private Set<ISearchSubdestination> activeSubdestinations() throws ProviderNotFoundException {
        HashSet<ISearchSubdestination> result = new HashSet<ISearchSubdestination>();
        IObjectTypeDescription objectType = this.getSelectedObjectType();
        IDestinationCategoryDescription category = this.getDestinationCategory(this.getSelectedDestination());
        ISearchProviderDescription searchProvider = this.getSearchProviderConfiguration().getActiveSearchProvider(objectType, category);
        for (ISearchSubdestination subd : this.getSearchProviderConfiguration().getAvailableSearchSubdestinations(objectType, category, searchProvider)) {
            if (!this.getSearchProviderConfiguration().isSubdestinationActive(subd, objectType, category, searchProvider)) continue;
            result.add(subd);
        }
        return result;
    }

    private void createGradient() {
        this.fixedSearchParamCompositeBgImageManager = new ControlBackgroundImageManager((Control)this.fixedSearchParamComposite);
        this.fixedSearchParamCompositeBgImageManager.setBackgroundGradient(this.fixedSearchParamComposite.getForeground(), this.fixedSearchParamComposite.getBackground(), true);
        this.fixedSearchParamComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                SearchConsoleView.this.fixedSearchParamCompositeBgImageManager.setBackgroundGradient(SearchConsoleView.this.fixedSearchParamComposite.getForeground(), SearchConsoleView.this.fixedSearchParamComposite.getBackground(), true);
            }
        });
        this.destinationSelectorBgImageManager = new ControlBackgroundImageManager(this.destinationsSelector.getControl());
        this.destinationSelectorBgImageManager.setBackgroundGradient(this.formToolkit.getColors().getBackground(), this.formToolkit.getColors().getBackground(), true);
        this.destinationsSelector.getControl().addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SearchConsoleView.this.destinationSelectorBgImageManager.setBackgroundGradient(SearchConsoleView.this.formToolkit.getColors().getBackground(), SearchConsoleView.this.formToolkit.getColors().getBackground(), true);
            }
        });
    }

    private void installSearchForSelectionChangeListener() {
        this.searchForComboViewer.registerSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IObjectTypeDescription objectType = this.getObjectType(event);
                SearchConsoleView.this.controller.objectTypeSelected(objectType);
            }

            private IObjectTypeDescription getObjectType(SelectionChangedEvent event) {
                if (!$assertionsDisabled && !(event.getSelection() instanceof IStructuredSelection)) {
                    throw new AssertionError();
                }
                if (event.getSelection().isEmpty()) {
                    return null;
                }
                return (IObjectTypeDescription)((StructuredSelection)event.getSelection()).iterator().next();
            }
        });
    }

    private void installSearchButtonListener() {
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchConsoleView.this.search();
            }
        });
    }

    private void installSubdestinationSelectionListener() {
        this.openSubdestinationsButton.addListener(3, (Listener)new SubdestinationsSelectedListener(this.getSearchProviderConfiguration(), (Control)this.openSubdestinationsButton){

            @Override
            protected IObjectTypeDescription objectType() {
                return SearchConsoleView.this.getSelectedObjectType();
            }

            @Override
            protected IDestinationCategoryDescription destinationCategory() {
                return SearchConsoleView.this.getSelectedDestinationCategory();
            }

            @Override
            protected ISearchProviderDescription searchProviderDescription() {
                return SearchConsoleView.this.getSelectedActiveSearchProviderDescription();
            }

            @Override
            protected ISearchDestination currentSearchDestination() {
                if (SearchConsoleView.this.destinationsSelector.getSelectedItems().isEmpty()) {
                    return null;
                }
                return SearchConsoleView.this.destinationsSelector.getSelectedItems().iterator().next();
            }

            @Override
            protected void handleSubdestActivationChange(IObjectTypeDescription searchObjectType, ISearchDestination searchDestination, ISearchSubdestination subDestination, boolean newActivationState) {
                SearchConsoleView.this.controller.subdestinationActivationChanged(searchObjectType, searchDestination, subDestination, newActivationState);
            }
        });
    }

    private IDestinationCategoryDescription getSelectedDestinationCategory() {
        try {
            ISearchDestination selectedDestination = this.getSelectedDestination();
            if (selectedDestination != null) {
                return (IDestinationCategoryDescription)this.getSearchProviderConfiguration().getDestinationCategoriesForDestination(selectedDestination).iterator().next();
            }
            return null;
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private IObjectTypeDescription getSelectedObjectType() {
        return (IObjectTypeDescription)this.searchForComboViewer.getSelectedItem();
    }

    private ISearchDestination getSelectedDestination() {
        if (this.destinationsSelector.getSelectedItems().size() == 0) {
            return null;
        }
        return this.destinationsSelector.getSelectedItems().iterator().next();
    }

    private ISearchProviderDescription getSelectedActiveSearchProviderDescription() {
        IDestinationCategoryDescription destCategory;
        block3: {
            try {
                destCategory = this.getSelectedDestinationCategory();
                if (destCategory != null) break block3;
                return null;
            }
            catch (ProviderNotFoundException providerNotFoundException) {
                return null;
            }
        }
        return this.getSearchProviderConfiguration().getActiveSearchProvider(this.getSelectedObjectType(), destCategory);
    }

    public void registerDestinationsChangeHandler(IDestinationChangeHandler destChangeHandler) {
        this.destinationsSelector.registerDestinationsChangeHandler(destChangeHandler);
    }

    public void updateDestinationsSelector() {
        this.destinationsSelector.update();
    }

    private int getLongestLabelSize(List<String> labels) {
        int result = 0;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getDisplay());
        try {
            for (String l : labels) {
                int extent = gc.textExtent((String)l).x;
                int n = result = extent > result ? extent : result;
            }
        }
        finally {
            gc.dispose();
        }
        return result;
    }

    private List<String> getLeftSideLabels() {
        return Arrays.asList(DiscoveryUIMessages.SEARCH_FOR_LIST_VIEWER_LABEL, DiscoveryUIMessages.SEARCH_IN_LIST_VIEWER_LABEL, DiscoveryUIMessages.SEARCH_KEYWORD_LABEL, DiscoveryUIMessages.GROUP_BY_LABEL);
    }

    private ImageRegistry imageRegistry() {
        return DiscoveryUIPlugin.getDefault().getImageRegistry();
    }

    private Image dropDownButtonImage() {
        Image img = this.imageRegistry().get(DROP_DOWN_ICON_LOCATION);
        if (img == null) {
            img = new Image((Device)this.getViewSite().getShell().getDisplay(), SearchConsoleView.class.getResourceAsStream(DROP_DOWN_ICON_LOCATION));
            this.imageRegistry().put(DROP_DOWN_ICON_LOCATION, img);
        }
        return img;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.hyperlinkCursor.dispose();
        this.fixedSearchParamCompositeBgImageManager.disposeResources();
        this.destinationSelectorBgImageManager.disposeResources();
    }

    protected ICustomSearchParamsDisplayer createCustomSearchParamsDisplayer(Composite parent, FormToolkit formToolkit) {
        CustomSearchParamsDisplayer displayer = new CustomSearchParamsDisplayer(parent, formToolkit){

            @Override
            protected ISearchProviderConfiguration searchProviderConfiguration() {
                return SearchConsoleView.this.getSearchProviderConfiguration();
            }
        };
        return displayer;
    }

    private IDestinationCategoryDescription getDestinationCategory(ISearchDestination destination) {
        try {
            return (IDestinationCategoryDescription)this.getSearchProviderConfiguration().getDestinationCategoriesForDestination(destination).iterator().next();
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void showGroupingHierarchies(Set<GroupingHierarchy> groupingHierarchies) {
        this.groupingHierarchySelector.setInput(groupingHierarchies);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.viewProgressMonitor;
    }

    public Composite getResultComposite() {
        return this.bottomComposite;
    }

    public FormToolkit getFormToolkit() {
        return this.formToolkit;
    }

    public void setDefaultSessionId(String sessionId) {
        this.defaultSessionId = sessionId;
    }

    @Override
    public void setStatusMessage(String message) {
        this.slidingComposite.setMessage(message);
    }

    private Point computeUpperCompositeSize(Point fixedParamsCompositeSize, Point customParamsCompositeSize, Point searchButtonSize, SlidingComposite.ORIENTATION orientation) {
        Point size = new Point(fixedParamsCompositeSize.x, fixedParamsCompositeSize.y);
        size.y += 5;
        size.y += searchButtonSize.y;
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            size.y += customParamsCompositeSize.y + 5;
        } else {
            size.x += customParamsCompositeSize.x + 5;
            size.y = Math.max(size.y, customParamsCompositeSize.y);
            size.y += 5;
        }
        return size;
    }

    @Override
    public void setUiContext(IViewUiContext uiContext) {
        super.setUiContext(uiContext);
        this.uiContext().setSecondColumnPosition(this.getLongestLabelSize(this.getLeftSideLabels()));
    }

    public void registerController(ISearchConsoleController controller) {
        this.controller = controller;
    }

    public ISearchConsoleControllerOutputView getControllerView() {
        return this;
    }

    private class OrientationChangedListener
    implements IPropertyAttributeListener<SlidingComposite.ORIENTATION> {
        private OrientationChangedListener() {
        }

        public void attributeChanged(PropertyAttributeChangedEvent<SlidingComposite.ORIENTATION> event) {
            SearchConsoleView.this.adjustUpperCompositeLayoutData((SlidingComposite.ORIENTATION)((Object)event.getNewAttribute()));
            SearchConsoleView.this.upperComposite.layout(true, true);
        }
    }
}

