/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.ManifestElement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DevClassPathHelper {
    private static boolean inDevelopmentMode = false;
    private static String[] devDefaultClasspath;
    private static Dictionary<String, String> devProperties;

    static {
        devProperties = null;
        String osgiDev = FrameworkProperties.getProperty("osgi.dev");
        if (osgiDev != null) {
            try {
                inDevelopmentMode = true;
                URL location = new URL(osgiDev);
                devProperties = DevClassPathHelper.load(location);
                if (devProperties != null) {
                    devDefaultClasspath = DevClassPathHelper.getArrayFromList(devProperties.get("*"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                devDefaultClasspath = DevClassPathHelper.getArrayFromList(osgiDev);
            }
        }
    }

    private static String[] getDevClassPath(String id, Dictionary<String, String> properties, String[] defaultClasspath) {
        String entry;
        String[] result = null;
        if (id != null && properties != null && (entry = properties.get(id)) != null) {
            result = DevClassPathHelper.getArrayFromList(entry);
        }
        if (result == null) {
            result = defaultClasspath;
        }
        return result;
    }

    public static String[] getDevClassPath(String id, Dictionary<String, String> properties) {
        if (properties == null) {
            return DevClassPathHelper.getDevClassPath(id, devProperties, devDefaultClasspath);
        }
        return DevClassPathHelper.getDevClassPath(id, properties, DevClassPathHelper.getArrayFromList(properties.get("*")));
    }

    public static String[] getDevClassPath(String id) {
        return DevClassPathHelper.getDevClassPath(id, null);
    }

    public static String[] getArrayFromList(String prop) {
        return ManifestElement.getArrayFromList(prop, ",");
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static Dictionary<String, String> load(URL url) {
        Properties props = new Properties();
        try {
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException iOException) {}
        Properties result = props;
        return result;
    }
}

