/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionServiceImpl
implements ESelectionService {
    static final String OUT_SELECTION = "output.selection";
    private ListenerList genericListeners = new ListenerList();
    private Map<String, ListenerList> targetedListeners = new HashMap<String, ListenerList>();
    private Set<IEclipseContext> tracked = new HashSet<IEclipseContext>();
    @Inject
    private IEclipseContext context;
    @Inject
    private EPartService partService;
    @Inject
    @Named(value="partServiceRoot")
    private MContext serviceRoot;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler eventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MPart part;
            IEclipseContext context;
            Object element = event.getProperty("ChangedElement");
            if (element instanceof MPart && (context = (part = (MPart)element).getContext()) != null && SelectionServiceImpl.this.isInContainer(part)) {
                SelectionServiceImpl.this.track(part);
            }
        }
    };
    private MPart activePart;

    @PreDestroy
    void preDestroy() {
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != null && rootContext != this.context) {
            ESelectionService selectionService;
            if (!this.genericListeners.isEmpty()) {
                Object[] listeners;
                selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
                Object[] objectArray = listeners = this.genericListeners.getListeners();
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    selectionService.removeSelectionListener((ISelectionListener)listener);
                    ++n2;
                }
            }
            if (!this.targetedListeners.isEmpty()) {
                selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
                for (Map.Entry<String, ListenerList> entry : this.targetedListeners.entrySet()) {
                    String partId = entry.getKey();
                    Object[] objectArray = entry.getValue().getListeners();
                    int n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Object listener = objectArray[n3];
                        selectionService.removeSelectionListener(partId, (ISelectionListener)listener);
                        ++n3;
                    }
                }
            }
        }
        this.genericListeners.clear();
        this.targetedListeners.clear();
        this.eventBroker.unsubscribe(this.eventHandler);
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/ui/Context", "context"), this.eventHandler);
        if (this.isMasterService()) {
            for (MPart part : this.partService.getParts()) {
                this.track(part);
            }
        }
    }

    private boolean isMasterService() {
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext == this.context) {
            return true;
        }
        IEclipseContext parent = rootContext.getParent();
        while (parent != null) {
            if (parent == this.context) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart part) {
        if (part != null && this.activePart != part) {
            this.activePart = part;
            if (this.isMasterService()) {
                IEclipseContext partContext = part.getContext();
                if (partContext.containsKey(OUT_SELECTION)) {
                    Object selection = partContext.get(OUT_SELECTION);
                    this.notifyListeners(part, selection);
                }
                this.track(part);
            } else {
                IEclipseContext partContext = part.getContext();
                if (partContext.containsKey(OUT_SELECTION)) {
                    Object selection = partContext.getLocal(OUT_SELECTION);
                    this.serviceRoot.getContext().set("selection", selection);
                    if (this.isMasterService()) {
                        this.context.set("selection", selection);
                    }
                }
            }
        }
    }

    private boolean isInContainer(MPart part) {
        return this.isInContainer((MElementContainer)this.serviceRoot, part);
    }

    private boolean isInContainer(MElementContainer<?> container, MPart part) {
        for (Object object : container.getChildren()) {
            if (object == part) {
                return true;
            }
            if (!(object instanceof MElementContainer) || !this.isInContainer((MElementContainer)object, part)) continue;
            return true;
        }
        return false;
    }

    private void notifyListeners(MPart part, Object selection) {
        this.serviceRoot.getContext().set("selection", selection);
        this.context.set("selection", selection);
        Object[] objectArray = this.genericListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionListener)listener).selectionChanged(part, selection);
            ++n2;
        }
        this.notifyTargetedListeners(part, selection);
    }

    private void notifyTargetedListeners(MPart part, Object selection) {
        ListenerList listenerList;
        String id = part.getElementId();
        if (id != null && (listenerList = this.targetedListeners.get(id)) != null) {
            Object[] objectArray = listenerList.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((ISelectionListener)listener).selectionChanged(part, selection);
                ++n2;
            }
        }
    }

    private void track(final MPart part) {
        IEclipseContext context = part.getContext();
        if (context != null && this.tracked.add(context)) {
            context.runAndTrack(new RunAndTrack(){
                private boolean initial = true;

                public boolean changed(IEclipseContext context) {
                    if (SelectionServiceImpl.this.serviceRoot == null) {
                        return false;
                    }
                    Object selection = context.get(SelectionServiceImpl.OUT_SELECTION);
                    if (this.initial) {
                        this.initial = false;
                        if (selection == null) {
                            return true;
                        }
                    }
                    if (SelectionServiceImpl.this.activePart == part) {
                        SelectionServiceImpl.this.notifyListeners(part, selection);
                    } else {
                        SelectionServiceImpl.this.notifyTargetedListeners(part, selection);
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void setSelection(Object selection) {
        if (selection != null) {
            this.context.set(OUT_SELECTION, selection);
            if (this.activePart != null && this.activePart.getContext() == this.context) {
                this.serviceRoot.getContext().set("selection", selection);
            }
        } else {
            this.context.remove(OUT_SELECTION);
            if (this.activePart != null && this.activePart.getContext() == this.context) {
                this.serviceRoot.getContext().remove("selection");
            }
        }
    }

    @Override
    public Object getSelection() {
        if (this.activePart == null) {
            return null;
        }
        IEclipseContext partContext = this.activePart.getContext();
        return partContext == null ? null : partContext.get("in.selection");
    }

    @Override
    public void addSelectionListener(ISelectionListener listener) {
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            selectionService.addSelectionListener(listener);
        }
        this.genericListeners.add((Object)listener);
    }

    @Override
    public void removeSelectionListener(ISelectionListener listener) {
        if (this.context != null) {
            IEclipseContext rootContext = this.serviceRoot.getContext();
            if (rootContext != this.context) {
                ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
                selectionService.removeSelectionListener(listener);
            }
            this.genericListeners.remove((Object)listener);
        }
    }

    @Override
    public void addSelectionListener(String partId, ISelectionListener listener) {
        ListenerList listeners;
        IEclipseContext rootContext = this.serviceRoot.getContext();
        if (rootContext != this.context) {
            ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
            selectionService.addSelectionListener(partId, listener);
        }
        if ((listeners = this.targetedListeners.get(partId)) == null) {
            listeners = new ListenerList();
            this.targetedListeners.put(partId, listeners);
        }
        listeners.add((Object)listener);
    }

    @Override
    public void removeSelectionListener(String partId, ISelectionListener listener) {
        if (this.serviceRoot != null && this.context != null) {
            ListenerList listeners;
            IEclipseContext rootContext = this.serviceRoot.getContext();
            if (rootContext != this.context) {
                ESelectionService selectionService = (ESelectionService)rootContext.get(ESelectionService.class.getName());
                selectionService.removeSelectionListener(partId, listener);
            }
            if ((listeners = this.targetedListeners.get(partId)) != null) {
                listeners.remove((Object)listener);
            }
        }
    }

    @Override
    public Object getSelection(String partId) {
        MPart part = this.partService.findPart(partId);
        if (part == null) {
            return null;
        }
        IEclipseContext partContext = part.getContext();
        if (partContext == null) {
            return null;
        }
        return partContext.get(OUT_SELECTION);
    }
}

