/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.platform.discovery.util.internal.session.IHistoryTrack;

public class HistoryTrack<T>
implements IHistoryTrack<T> {
    private int pos = -1;
    private final int limit;
    private List<T> history;

    public HistoryTrack(int limit) {
        if (limit < 1) {
            throw new IllegalArgumentException();
        }
        this.history = new ArrayList<T>(limit);
        this.limit = limit;
    }

    @Override
    public void track(T object) {
        this.clearHistoryFromCurrent();
        if (this.pos + 1 == this.limit) {
            this.copyByOneToLeft();
            this.history.set(this.pos, object);
        } else {
            this.history.add(++this.pos, object);
        }
    }

    private void clearHistoryFromCurrent() {
        int i = this.history.size() - 1;
        while (i > this.pos) {
            this.history.remove(i);
            --i;
        }
    }

    private void copyByOneToLeft() {
        if (this.limit >= 2) {
            int i = 1;
            while (i < this.history.size()) {
                this.history.set(i - 1, this.history.get(i));
                ++i;
            }
        }
    }

    @Override
    public T last() {
        this.assertNotEmpty();
        return this.history.get(this.history.size() - 1);
    }

    @Override
    public T current() {
        this.assertNotEmpty();
        return this.history.get(this.pos);
    }

    @Override
    public List<T> asList() {
        return Collections.unmodifiableList(this.history);
    }

    @Override
    public T first() {
        this.assertNotEmpty();
        return this.history.get(0);
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.history.size() - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.pos > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.history.size() == 0;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.history.get(++this.pos);
    }

    @Override
    public T previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.history.get(--this.pos);
    }

    private void assertNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int historyLimit() {
        return this.limit;
    }
}

