/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.db.SQL;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.SummaryEntry;
import org.eclipse.test.internal.performance.db.TimeSeries;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.performance.Dimension;

public class DB {
    private static final boolean DEBUG = false;
    private static final boolean AGGREGATE = true;
    private static final String DERBY = "derby";
    private static final String CLOUDSCAPE = "cloudscape";
    private static DB fgDefault;
    private Connection fConnection;
    private SQL fSQL;
    private int fStoredSamples;
    private boolean fStoreCalled;
    private boolean fIsEmbedded;
    private String fDBType;

    public static DataPoint[] queryDataPoints(Variations variations, String scenarioName, Set dims) {
        return DB.getDefault().internalQueryDataPoints(variations, scenarioName, dims);
    }

    public static Scenario[] queryScenarios(String configName, String buildPattern, String scenarioPattern) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPattern);
        return DB.queryScenarios(variations, scenarioPattern, "build", null);
    }

    public static Scenario[] queryScenarios(String configName, String[] buildPatterns, String scenarioPattern, Dim[] dimensions) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPatterns);
        return DB.queryScenarios(variations, scenarioPattern, "build", dimensions);
    }

    public static Scenario queryScenario(String configName, String[] buildPatterns, String scenarioName) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPatterns);
        return new Scenario(scenarioName, variations, "build", null);
    }

    public static Scenario[] queryScenarios(Variations variations, String scenarioPattern, String seriesKey, Dim[] dimensions) {
        String[] scenarioNames = DB.getDefault().internalQueryScenarioNames(variations, scenarioPattern);
        if (scenarioNames == null) {
            return new Scenario[0];
        }
        Scenario.SharedState ss = new Scenario.SharedState(variations, scenarioPattern, seriesKey, dimensions);
        Scenario[] tables = new Scenario[scenarioNames.length];
        int i = 0;
        while (i < scenarioNames.length) {
            tables[i] = new Scenario(scenarioNames[i], ss);
            ++i;
        }
        return tables;
    }

    public static SummaryEntry[] querySummaries(Variations variationPatterns, String scenarioPattern) {
        return DB.getDefault().internalQuerySummaries(variationPatterns, scenarioPattern);
    }

    public static void queryBuildNames(List names, Variations variationPatterns, String scenarioPattern) {
        DB.getDefault().internalQueryDistinctValues(names, "build", variationPatterns, scenarioPattern);
    }

    public static void queryDistinctValues(List values, String key, Variations variationPatterns, String scenarioPattern) {
        DB.getDefault().internalQueryDistinctValues(values, key, variationPatterns, scenarioPattern);
    }

    public static String[] querySeriesValues(String scenarioName, Variations v, String seriesKey) {
        return DB.getDefault().internalQuerySeriesValues(v, scenarioName, seriesKey);
    }

    public static Scenario getScenarioSeries(String scenarioName, Variations v, String seriesKey, String startBuild, String endBuild, Dim[] dims) {
        v = (Variations)v.clone();
        v.put(seriesKey, new String[]{startBuild, endBuild});
        Scenario.SharedState ss = new Scenario.SharedState(v, scenarioName, seriesKey, dims);
        Scenario scenario = new Scenario(scenarioName, ss);
        TimeSeries ts = scenario.getTimeSeries(dims[0]);
        if (ts.getLength() < 2) {
            v.put(seriesKey, "%");
            String[] names = DB.querySeriesValues(scenarioName, v, seriesKey);
            if (names.length >= 2) {
                String start = DB.findClosest(names, startBuild);
                String end = DB.findClosest(names, endBuild);
                v.put(seriesKey, new String[]{start, end});
                scenario = new Scenario(scenarioName, ss);
            }
        }
        return scenario;
    }

    public static Map queryFailure(String scenarioPattern, Variations variations) {
        return DB.getDefault().internalQueryFailure(scenarioPattern, variations);
    }

    private static String findClosest(String[] names, String name) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(name)) {
                return name;
            }
            ++i;
        }
        Pattern pattern = Pattern.compile("200[3-9][01][0-9][0-3][0-9]");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        int x = Integer.parseInt(name.substring(matcher.start(), matcher.end()));
        int ix = -1;
        int mind = 0;
        int i2 = 0;
        while (i2 < names.length) {
            matcher.reset(names[i2]);
            if (matcher.find()) {
                int y = Integer.parseInt(names[i2].substring(matcher.start(), matcher.end()));
                int d = Math.abs(y - x);
                if (ix < 0 || d < mind) {
                    mind = d;
                    ix = i2;
                }
            }
            ++i2;
        }
        if (ix >= 0) {
            return names[ix];
        }
        return name;
    }

    public static boolean store(Variations variations, Sample sample) {
        return DB.getDefault().internalStore(variations, sample);
    }

    public static void markAsFailed(Variations variations, Sample sample, String failMesg) {
        DB.getDefault().internalMarkAsFailed(variations, sample, failMesg);
    }

    public static Connection getConnection() {
        return DB.getDefault().fConnection;
    }

    public static boolean isActive() {
        return fgDefault != null && fgDefault.getSQL() != null;
    }

    private DB() {
    }

    static synchronized DB getDefault() {
        if (fgDefault == null) {
            fgDefault = new DB();
            fgDefault.connect();
            if (PerformanceTestPlugin.getDefault() == null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        DB.shutdown();
                    }
                });
            }
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.disconnect();
            fgDefault = null;
        }
    }

    SQL getSQL() {
        return this.fSQL;
    }

    private void internalMarkAsFailed(Variations variations, Sample sample, String failMesg) {
        if (this.fSQL == null) {
            return;
        }
        try {
            int variation_id = this.fSQL.getVariations(variations);
            int scenario_id = this.fSQL.getScenario(sample.getScenarioID());
            this.fSQL.insertFailure(variation_id, scenario_id, failMesg);
            this.fConnection.commit();
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
            try {
                this.fConnection.rollback();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
        }
    }

    private boolean internalStore(Variations variations, Sample sample) {
        if (this.fSQL == null || sample == null) {
            return false;
        }
        DataPoint[] dataPoints = sample.getDataPoints();
        int n = dataPoints.length;
        if (n <= 0) {
            return false;
        }
        try {
            Dim dim;
            int variation_id = this.fSQL.getVariations(variations);
            int scenario_id = this.fSQL.getScenario(sample.getScenarioID());
            String comment = sample.getComment();
            if (sample.isSummary()) {
                boolean isGlobal = sample.isGlobal();
                int commentId = 0;
                int commentKind = sample.getCommentType();
                if (commentKind == 1 && comment != null) {
                    commentId = this.fSQL.getCommentId(commentKind, comment);
                }
                Dimension[] summaryDimensions = sample.getSummaryDimensions();
                int i = 0;
                while (i < summaryDimensions.length) {
                    Dimension dimension = summaryDimensions[i];
                    if (dimension instanceof Dim) {
                        this.fSQL.createSummaryEntry(variation_id, scenario_id, ((Dim)dimension).getId(), isGlobal, commentId);
                    }
                    ++i;
                }
                String shortName = sample.getShortname();
                if (shortName != null) {
                    this.fSQL.setScenarioShortName(scenario_id, shortName);
                }
            } else if (comment != null) {
                int commentId = 0;
                int commentKind = sample.getCommentType();
                if (commentKind == 1) {
                    commentId = this.fSQL.getCommentId(commentKind, comment);
                }
                this.fSQL.createSummaryEntry(variation_id, scenario_id, 0, false, commentId);
            }
            int sample_id = this.fSQL.createSample(variation_id, scenario_id, new Timestamp(sample.getStartTime()));
            StatisticsSession stats = new StatisticsSession(dataPoints);
            Dim[] dims = dataPoints[0].getDimensions();
            int datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -3);
            int i = 0;
            while (i < dims.length) {
                dim = dims[i];
                this.fSQL.insertScalar(datapoint_id, dim.getId(), (long)stats.getAverage(dim));
                ++i;
            }
            datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -5);
            i = 0;
            while (i < dims.length) {
                dim = dims[i];
                long value = Double.doubleToLongBits(stats.getStddev(dim));
                this.fSQL.insertScalar(datapoint_id, dim.getId(), value);
                ++i;
            }
            datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -4);
            i = 0;
            while (i < dims.length) {
                dim = dims[i];
                this.fSQL.insertScalar(datapoint_id, dim.getId(), stats.getCount(dim));
                ++i;
            }
            this.fConnection.commit();
            ++this.fStoredSamples;
            this.fStoreCalled = true;
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
            try {
                this.fConnection.rollback();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataPoint[] internalQueryDataPoints(Variations variations, String scenarioName, Set dimSet) {
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        ResultSet rs = null;
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        rs = this.fSQL.queryDataPoints(variations, scenarioName);
        while (rs.next()) {
            int datapoint_id = rs.getInt(1);
            int step = rs.getInt(2);
            HashMap<Dim, Scalar> map = new HashMap<Dim, Scalar>();
            ResultSet rs2 = this.fSQL.queryScalars(datapoint_id);
            while (rs2.next()) {
                int dim_id = rs2.getInt(1);
                long value = rs2.getBigDecimal(2).longValue();
                Dim dim = Dim.getDimension(dim_id);
                if (dim == null || dimSet != null && !dimSet.contains(dim)) continue;
                map.put(dim, new Scalar(dim, value));
            }
            if (map.size() > 0) {
                dataPoints.add(new DataPoint(step, map));
            }
            rs2.close();
        }
        rs.close();
        int n = dataPoints.size();
        DataPoint[] dataPointArray = dataPoints.toArray(new DataPoint[n]);
        if (rs == null) return dataPointArray;
        try {
            rs.close();
            return dataPointArray;
        }
        catch (SQLException sQLException) {}
        return dataPointArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                if (rs == null) return null;
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                rs.close();
                return null;
            }
            catch (SQLException sQLException) {}
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] internalQueryScenarioNames(Variations variations, String scenarioPattern) {
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        ResultSet result = null;
        result = this.fSQL.queryScenarios(variations, scenarioPattern);
        ArrayList<String> scenarios = new ArrayList<String>();
        int i = 0;
        while (result.next()) {
            scenarios.add(result.getString(1));
            ++i;
        }
        String[] stringArray = scenarios.toArray(new String[scenarios.size()]);
        if (result == null) return stringArray;
        try {
            result.close();
            return stringArray;
        }
        catch (SQLException sQLException) {}
        return stringArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException sQLException) {}
            return null;
        }
    }

    private void internalQueryDistinctValues(List values, String seriesKey, Variations variations, String scenarioPattern) {
        block17: {
            if (this.fSQL == null) {
                return;
            }
            long start = System.currentTimeMillis();
            ResultSet result = null;
            try {
                try {
                    result = this.fSQL.queryVariations(variations.toExactMatchString(), scenarioPattern);
                    int i = 0;
                    while (result.next()) {
                        Variations v = new Variations();
                        v.parseDB(result.getString(1));
                        String build = v.getProperty(seriesKey);
                        if (build != null && !values.contains(build)) {
                            values.add(build);
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SummaryEntry[] internalQuerySummaries(Variations variationPatterns, String scenarioPattern) {
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        ResultSet result = null;
        ArrayList<SummaryEntry> fingerprints = new ArrayList<SummaryEntry>();
        result = scenarioPattern != null ? this.fSQL.querySummaryEntries(variationPatterns, scenarioPattern) : this.fSQL.queryGlobalSummaryEntries(variationPatterns);
        while (result.next()) {
            ResultSet rs2;
            String scenarioName = result.getString(1);
            String shortName = result.getString(2);
            int dim_id = result.getInt(3);
            boolean isGlobal = result.getShort(4) == 1;
            int comment_id = result.getInt(5);
            int commentKind = 0;
            String comment = null;
            if (comment_id != 0 && (rs2 = this.fSQL.getComment(comment_id)).next()) {
                commentKind = rs2.getInt(1);
                comment = rs2.getString(2);
            }
            if (dim_id == 0) continue;
            fingerprints.add(new SummaryEntry(scenarioName, shortName, Dim.getDimension(dim_id), isGlobal, commentKind, comment));
        }
        SummaryEntry[] summaryEntryArray = fingerprints.toArray(new SummaryEntry[fingerprints.size()]);
        if (result == null) return summaryEntryArray;
        try {
            result.close();
            return summaryEntryArray;
        }
        catch (SQLException sQLException) {}
        return summaryEntryArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException sQLException) {}
            return null;
        }
    }

    private String[] internalQuerySeriesValues(Variations v, String scenarioName, String seriesKey) {
        boolean isCloned = false;
        String[] seriesPatterns = null;
        Object object = v.get(seriesKey);
        if (object instanceof String[]) {
            seriesPatterns = (String[])object;
        } else if (object instanceof String) {
            seriesPatterns = new String[]{(String)object};
        } else {
            Assert.assertTrue((boolean)false);
        }
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < seriesPatterns.length) {
            if (seriesPatterns[i].indexOf(37) >= 0) {
                if (!isCloned) {
                    v = (Variations)v.clone();
                    isCloned = true;
                }
                v.put(seriesKey, seriesPatterns[i]);
                this.internalQueryDistinctValues(values, seriesKey, v, scenarioName);
            } else {
                values.add(seriesPatterns[i]);
            }
            ++i;
        }
        String[] names = values.toArray(new String[values.size()]);
        boolean sort = true;
        Pattern pattern = Pattern.compile("200[3-9][01][0-9][0-3][0-9]");
        final Matcher matcher = pattern.matcher("");
        int i2 = 0;
        while (i2 < names.length) {
            matcher.reset(names[i2]);
            if (!matcher.find()) {
                sort = false;
                break;
            }
            ++i2;
        }
        if (sort) {
            Arrays.sort(names, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    matcher.reset(s1);
                    if (matcher.find()) {
                        s1 = s1.substring(matcher.start());
                    }
                    matcher.reset(s2);
                    if (matcher.find()) {
                        s2 = s2.substring(matcher.start());
                    }
                    return s1.compareTo(s2);
                }
            });
        }
        return names;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map internalQueryFailure(String scenarioPattern, Variations variations) {
        if (this.fSQL == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        ResultSet result = null;
        HashMap<String, String> map = new HashMap<String, String>();
        result = this.fSQL.queryFailure(variations, scenarioPattern);
        while (result.next()) {
            String scenario = result.getString(1);
            String message = result.getString(2);
            map.put(scenario, message);
        }
        HashMap<String, String> hashMap = map;
        if (result == null) return hashMap;
        try {
            result.close();
            return hashMap;
        }
        catch (SQLException sQLException) {}
        return hashMap;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException sQLException) {}
            return null;
        }
    }

    private void connect() {
        if (this.fConnection != null) {
            return;
        }
        String dbloc = PerformanceTestPlugin.getDBLocation();
        if (dbloc == null) {
            return;
        }
        String dbname = PerformanceTestPlugin.getDBName();
        String url = null;
        Properties info = new Properties();
        this.fDBType = DERBY;
        try {
            if (dbloc.startsWith("net://")) {
                this.fIsEmbedded = false;
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("retrieveMessagesFromServerOnGetMessage", "true");
                url = String.valueOf(dbloc) + "/" + dbname + ";create=true";
            } else if (dbloc.startsWith("//")) {
                this.fIsEmbedded = false;
                Class.forName("org.apache.derby.jdbc.ClientDriver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
                url = String.valueOf(dbloc) + '/' + dbname;
            } else {
                File f;
                if ("Mac OS X".equals(System.getProperty("os.name"))) {
                    System.setProperty("derby.storage.fileSyncTransactionLog", "true");
                }
                this.fIsEmbedded = true;
                try {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class.forName("com.ihost.cs.jdbc.CloudscapeDriver");
                    this.fDBType = CLOUDSCAPE;
                }
                if (dbloc.length() == 0) {
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) {
                        return;
                    }
                    f = new File(user_home, this.fDBType);
                } else {
                    f = new File(dbloc);
                }
                url = new File(f, dbname).getAbsolutePath();
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("create", "true");
            }
            try {
                this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
            }
            catch (SQLException e) {
                if ("08001".equals(e.getSQLState()) && DERBY.equals(this.fDBType)) {
                    this.fDBType = CLOUDSCAPE;
                    this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
                }
                throw e;
            }
            this.fConnection.setAutoCommit(false);
            this.fSQL = new SQL(this.fConnection);
            this.fConnection.commit();
        }
        catch (SQLException ex) {
            PerformanceTestPlugin.logError(ex.getMessage());
        }
        catch (ClassNotFoundException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    private void disconnect() {
        block11: {
            if (this.fSQL != null) {
                try {
                    this.fSQL.dispose();
                }
                catch (SQLException e1) {
                    PerformanceTestPlugin.log(e1);
                }
                this.fSQL = null;
            }
            if (this.fConnection != null) {
                try {
                    this.fConnection.commit();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                try {
                    this.fConnection.close();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                this.fConnection = null;
            }
            if (this.fIsEmbedded) {
                try {
                    DriverManager.getConnection("jdbc:" + this.fDBType + ":;shutdown=true");
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (message.indexOf("system shutdown.") >= 0) break block11;
                    e.printStackTrace();
                }
            }
        }
    }
}

