/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRendererFilter;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuManagerRenderer
extends SWTPartRenderer {
    private static final String NO_LABEL = "UnLabled";
    private Map<MMenu, MenuManager> modelToManager = new HashMap<MMenu, MenuManager>();
    private Map<MenuManager, MMenu> managerToModel = new HashMap<MenuManager, MMenu>();
    private Map<MMenuElement, IContributionItem> modelToContribution = new HashMap<MMenuElement, IContributionItem>();
    private Map<IContributionItem, MMenuElement> contributionToModel = new HashMap<IContributionItem, MMenuElement>();
    private Map<MMenuElement, ContributionRecord> modelContributionToRecord = new HashMap<MMenuElement, ContributionRecord>();
    @Inject
    private Logger logger;
    @Inject
    private MApplication application;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            IContributionItem ici = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
            if (ici == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                ici.update();
            } else if ("iconURI".equals(attName)) {
                ici.update();
            }
        }
    };
    private EventHandler toBeRenderedUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            MElementContainer obj;
            MMenuItem itemModel;
            Object element = event.getProperty("ChangedElement");
            String attName = (String)event.getProperty("AttName");
            if (element instanceof MMenuItem) {
                itemModel = (MMenuItem)element;
                if ("toBeRendered".equals(attName)) {
                    obj = itemModel.getParent();
                    if (!(obj instanceof MMenu)) {
                        return;
                    }
                    MenuManager parent = MenuManagerRenderer.this.getManager((MMenu)obj);
                    if (itemModel.isToBeRendered()) {
                        if (parent != null) {
                            MenuManagerRenderer.this.modelProcessSwitch(parent, (MMenuElement)itemModel);
                        }
                    } else {
                        IContributionItem ici = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
                        MenuManagerRenderer.this.clearModelToContribution((MMenuElement)itemModel, ici);
                        if (ici != null && parent != null) {
                            parent.remove(ici);
                        }
                        if (ici != null) {
                            ici.dispose();
                        }
                    }
                }
            }
            if ("visible".equals(attName)) {
                if (element instanceof MMenu) {
                    MMenu menuModel = (MMenu)element;
                    MenuManager manager = MenuManagerRenderer.this.getManager(menuModel);
                    if (manager == null) {
                        return;
                    }
                    manager.setVisible(menuModel.isVisible());
                    if (manager.getParent() != null) {
                        manager.getParent().markDirty();
                    }
                } else if (element instanceof MMenuElement) {
                    itemModel = (MMenuElement)element;
                    obj = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
                    if (!(obj instanceof ContributionItem)) {
                        return;
                    }
                    ContributionItem item = (ContributionItem)obj;
                    item.setVisible(itemModel.isVisible());
                    if (item.getParent() != null) {
                        item.getParent().markDirty();
                    }
                }
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            IContributionItem ici = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private EventHandler enabledUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MMenuItem)) {
                return;
            }
            MMenuItem itemModel = (MMenuItem)event.getProperty("ChangedElement");
            IContributionItem ici = MenuManagerRenderer.this.getContribution((MMenuElement)itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private MenuManagerRendererFilter rendererFilter;

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"selected"), this.selectionUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"enabled"), this.enabledUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement"), this.toBeRenderedUpdater);
        this.context.set(MenuManagerRenderer.class, (Object)this);
        Display display = (Display)this.context.get(Display.class);
        this.rendererFilter = (MenuManagerRendererFilter)ContextInjectionFactory.make(MenuManagerRendererFilter.class, (IEclipseContext)this.context);
        display.addFilter(22, (Listener)this.rendererFilter);
        display.addFilter(23, (Listener)this.rendererFilter);
        display.addFilter(12, (Listener)this.rendererFilter);
        this.context.set(MenuManagerRendererFilter.class, (Object)this.rendererFilter);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
        this.eventBroker.unsubscribe(this.enabledUpdater);
        this.eventBroker.unsubscribe(this.toBeRenderedUpdater);
        this.context.remove(MenuManagerRendererFilter.class);
        Display display = (Display)this.context.get(Display.class);
        if (display != null && !display.isDisposed() && this.rendererFilter != null) {
            display.removeFilter(22, (Listener)this.rendererFilter);
            display.removeFilter(23, (Listener)this.rendererFilter);
            display.removeFilter(12, (Listener)this.rendererFilter);
        }
        if (this.rendererFilter != null) {
            ContextInjectionFactory.uninject((Object)this.rendererFilter, (IEclipseContext)this.context);
            this.rendererFilter = null;
        }
        this.context.remove(MenuManagerRenderer.class);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MMenu)) {
            return null;
        }
        final MMenu menuModel = (MMenu)element;
        Menu newMenu = null;
        MenuManager menuManager = null;
        boolean menuBar = false;
        if (parent instanceof Decorations) {
            MUIElement container = (MUIElement)((EObject)element).eContainer();
            if (container instanceof MWindow) {
                menuManager = this.getManager(menuModel);
                if (menuManager == null) {
                    menuManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuManager);
                }
                newMenu = menuManager.createMenuBar((Decorations)parent);
                ((Decorations)parent).setMenuBar(newMenu);
                newMenu.setData((Object)menuManager);
                menuBar = true;
            } else {
                menuManager = this.getManager(menuModel);
                if (menuManager == null) {
                    menuManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuManager);
                }
                newMenu = menuManager.createContextMenu((Control)parent);
                newMenu.setData((Object)menuManager);
            }
        } else {
            if (parent instanceof Menu) {
                this.logger.debug((Throwable)new Exception(), "Trying to render a sub menu " + menuModel + "\n\t" + parent);
                return null;
            }
            if (parent instanceof Control) {
                menuManager = this.getManager(menuModel);
                if (menuManager == null) {
                    menuManager = new MenuManager(NO_LABEL, menuModel.getElementId());
                    this.linkModelToManager(menuModel, menuManager);
                }
                newMenu = menuManager.createContextMenu((Control)parent);
                newMenu.setData((Object)menuManager);
            }
        }
        if (!menuManager.getRemoveAllWhenShown()) {
            this.processContributions(menuModel, menuBar, menuModel instanceof MPopupMenu);
        }
        if (newMenu != null) {
            newMenu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MenuManagerRenderer.this.cleanUp(menuModel);
                }
            });
        }
        return newMenu;
    }

    public void cleanUp(MMenu menuModel) {
        Collection<ContributionRecord> vals = this.modelContributionToRecord.values();
        ContributionRecord[] contributionRecordArray = vals.toArray(new ContributionRecord[vals.size()]);
        int n = contributionRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContributionRecord record = contributionRecordArray[n2];
            if (record.menuModel == menuModel) {
                record.dispose();
                for (MMenuElement copy : record.generatedElements) {
                    this.modelContributionToRecord.remove(copy);
                    if (copy instanceof MMenu) {
                        MMenu menuCopy = (MMenu)copy;
                        this.cleanUp(menuCopy);
                        MenuManager copyManager = this.getManager(menuCopy);
                        this.clearModelToManager(menuCopy, copyManager);
                        if (copyManager == null) continue;
                        record.getManagerForModel().remove((IContributionItem)copyManager);
                        copyManager.dispose();
                        continue;
                    }
                    IContributionItem ici = this.getContribution(copy);
                    this.clearModelToContribution(copy, ici);
                    if (ici == null) continue;
                    record.getManagerForModel().remove(ici);
                }
                record.generatedElements.clear();
            }
            ++n2;
        }
    }

    public void processContributions(MMenu menuModel, boolean isMenuBar, boolean isPopup) {
        if (menuModel.getElementId() == null) {
            return;
        }
        ArrayList<MMenuContribution> toContribute = new ArrayList<MMenuContribution>();
        ContributionsAnalyzer.XXXgatherMenuContributions((MMenu)menuModel, (List)this.application.getMenuContributions(), (String)menuModel.getElementId(), toContribute, null, (boolean)isPopup);
        this.generateContributions(menuModel, toContribute, isMenuBar);
        for (MMenuElement element : menuModel.getChildren()) {
            if (!(element instanceof MMenu)) continue;
            this.processContributions((MMenu)element, false, isPopup);
        }
    }

    private void generateContributions(MMenu menuModel, ArrayList<MMenuContribution> toContribute, boolean menuBar) {
        HashSet<String> existingMenuIds = new HashSet<String>();
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MMenuElement child : menuModel.getChildren()) {
            String elementId = child.getElementId();
            if (child instanceof MMenu && elementId != null) {
                existingMenuIds.add(elementId);
                continue;
            }
            if (!(child instanceof MMenuSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        MenuManager manager = this.getManager(menuModel);
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MMenuContribution> curList = new ArrayList<MMenuContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MMenuContribution menuContribution : curList) {
                if (this.processAddition(menuModel, manager, menuContribution, existingMenuIds, existingSeparatorNames, menuBar)) continue;
                toContribute.add(menuContribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private boolean processAddition(MMenu menuModel, final MenuManager manager, MMenuContribution menuContribution, HashSet<String> existingMenuIds, HashSet<String> existingSeparatorNames, boolean menuBar) {
        int idx = MenuManagerRenderer.getIndex(menuModel, menuContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        final ContributionRecord record = new ContributionRecord(menuModel, menuContribution, this);
        record.generate();
        for (MMenuElement copy : record.generatedElements) {
            this.modelContributionToRecord.put(copy, record);
            if (copy instanceof MMenu && existingMenuIds.contains(copy.getElementId()) || copy instanceof MMenuSeparator && existingSeparatorNames.contains(copy.getElementId())) continue;
            menuModel.getChildren().add(idx++, copy);
            if (copy instanceof MMenu && copy.getElementId() != null) {
                existingMenuIds.add(copy.getElementId());
                continue;
            }
            if (!(copy instanceof MMenuSeparator) || copy.getElementId() == null) continue;
            existingSeparatorNames.add(copy.getElementId());
        }
        if (menuBar && menuContribution.getVisibleWhen() != null) {
            final IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)menuModel);
            parentContext.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    record.updateVisibility(parentContext.getActiveLeaf());
                    manager.update(true);
                    return true;
                }
            });
        }
        return true;
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }

    void removeMenuContributions(MMenu menuModel, ArrayList<MMenuElement> menuContributionsToRemove) {
        for (MMenuElement item : menuContributionsToRemove) {
            menuModel.getChildren().remove(item);
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        MenuManager parentManager = this.getManager((MMenu)container);
        if (parentManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                this.modelProcessSwitch(parentManager, (MMenuElement)childME);
                ++i;
            }
        }
        parentManager.update(false);
    }

    private void addToManager(MenuManager parentManager, MMenuElement model, IContributionItem menuManager) {
        MElementContainer parent = model.getParent();
        if (parent == null) {
            parentManager.add(menuManager);
        } else {
            int index = parent.getChildren().indexOf(model);
            if (index > parentManager.getSize() || index == -1) {
                parentManager.add(menuManager);
            } else {
                parentManager.insert(index, menuManager);
            }
        }
    }

    private void processMenu(MenuManager parentManager, MMenu menuModel) {
        List parts;
        MenuManager menuManager = this.getManager(menuModel);
        if (menuManager == null) {
            String menuText = this.getText(menuModel);
            ImageDescriptor desc = this.getImageDescriptor((MUILabel)menuModel);
            menuManager = new MenuManager(menuText, desc, menuModel.getElementId());
            this.linkModelToManager(menuModel, menuManager);
            menuManager.setVisible(menuModel.isVisible());
            this.addToManager(parentManager, (MMenuElement)menuModel, (IContributionItem)menuManager);
        }
        if ((parts = menuModel.getChildren()) != null) {
            MMenuElement[] plist = parts.toArray(new MMenuElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MMenuElement childME = plist[i];
                this.modelProcessSwitch(menuManager, childME);
                ++i;
            }
        }
    }

    void modelProcessSwitch(MenuManager menuManager, MMenuElement childME) {
        if (!childME.isToBeRendered()) {
            return;
        }
        if (childME instanceof MRenderedMenuItem) {
            MRenderedMenuItem itemModel = (MRenderedMenuItem)childME;
            this.processRenderedItem(menuManager, itemModel);
        } else if (childME instanceof MHandledMenuItem) {
            MHandledMenuItem itemModel = (MHandledMenuItem)childME;
            this.processHandledItem(menuManager, itemModel);
        } else if (childME instanceof MDirectMenuItem) {
            MDirectMenuItem itemModel = (MDirectMenuItem)childME;
            this.processDirectItem(menuManager, itemModel, null);
        } else if (childME instanceof MMenuSeparator) {
            MMenuSeparator sep = (MMenuSeparator)childME;
            this.processSeparator(menuManager, sep);
        } else if (childME instanceof MMenu) {
            MMenu itemModel = (MMenu)childME;
            this.processMenu(menuManager, itemModel);
        }
    }

    void processRenderedItem(MenuManager parentManager, MRenderedMenuItem itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        Object obj = itemModel.getContributionItem();
        if (obj instanceof IContextFunction) {
            IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
            ici = (IContributionItem)((IContextFunction)obj).compute(lclContext);
            itemModel.setContributionItem((Object)ici);
        } else if (obj instanceof IContributionItem) {
            ici = (IContributionItem)obj;
        } else {
            return;
        }
        ici.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, ici);
        this.linkModelToContribution((MMenuElement)itemModel, ici);
    }

    private void processSeparator(MenuManager menuManager, MMenuSeparator itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        Separator marker = null;
        if (itemModel.isVisible()) {
            marker = new Separator();
            marker.setId(itemModel.getElementId());
        } else if (itemModel.getElementId() != null) {
            marker = new GroupMarker(itemModel.getElementId());
        }
        this.addToManager(menuManager, (MMenuElement)itemModel, (IContributionItem)marker);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)marker);
    }

    void processDirectItem(MenuManager parentManager, MDirectMenuItem itemModel, String id) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        DirectContributionItem ci = (DirectContributionItem)((Object)ContextInjectionFactory.make(DirectContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)ci);
    }

    void processHandledItem(MenuManager parentManager, MHandledMenuItem itemModel) {
        IContributionItem ici = this.getContribution((MMenuElement)itemModel);
        if (ici != null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        HandledContributionItem ci = (HandledContributionItem)((Object)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MHandledItem)itemModel);
        ci.setVisible(itemModel.isVisible());
        this.addToManager(parentManager, (MMenuElement)itemModel, (IContributionItem)ci);
        this.linkModelToContribution((MMenuElement)itemModel, (IContributionItem)ci);
    }

    private String getText(MMenu menuModel) {
        String text = menuModel.getLabel();
        if (text == null || text.length() == 0) {
            return NO_LABEL;
        }
        return text;
    }

    private ImageDescriptor getImageDescriptor(MUILabel element) {
        IEclipseContext localContext = this.context;
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            ISWTResourceUtilities resUtils = (ISWTResourceUtilities)localContext.get(IResourceUtilities.class.getName());
            return (ImageDescriptor)resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
        }
        return null;
    }

    public MenuManager getManager(MMenu model) {
        return this.modelToManager.get(model);
    }

    public MMenu getMenuModel(MenuManager manager) {
        return this.managerToModel.get(manager);
    }

    public void linkModelToManager(MMenu model, MenuManager manager) {
        this.modelToManager.put(model, manager);
        this.managerToModel.put(manager, model);
    }

    public void clearModelToManager(MMenu model, MenuManager manager) {
        this.modelToManager.remove(model);
        this.managerToModel.remove(manager);
    }

    public IContributionItem getContribution(MMenuElement model) {
        return this.modelToContribution.get(model);
    }

    public MMenuElement getMenuElement(IContributionItem item) {
        return this.contributionToModel.get(item);
    }

    public void linkModelToContribution(MMenuElement model, IContributionItem item) {
        this.modelToContribution.put(model, item);
        this.contributionToModel.put(item, model);
    }

    public void clearModelToContribution(MMenuElement model, IContributionItem item) {
        this.modelToContribution.remove(model);
        this.contributionToModel.remove(item);
    }

    public ContributionRecord getContributionRecord(MMenuElement element) {
        return this.modelContributionToRecord.get(element);
    }

    public void reconcileManagerToModel(MenuManager menuManager, MMenu menuModel) {
        List modelChildren = menuModel.getChildren();
        HashSet<MOpaqueMenuItem> oldModelItems = new HashSet<MOpaqueMenuItem>();
        HashSet<MOpaqueMenu> oldMenus = new HashSet<MOpaqueMenu>();
        HashSet<MOpaqueMenuSeparator> oldSeps = new HashSet<MOpaqueMenuSeparator>();
        for (MMenuElement itemModel : modelChildren) {
            if (itemModel instanceof MOpaqueMenuSeparator) {
                oldSeps.add((MOpaqueMenuSeparator)itemModel);
                continue;
            }
            if (itemModel instanceof MOpaqueMenuItem) {
                oldModelItems.add((MOpaqueMenuItem)itemModel);
                continue;
            }
            if (!(itemModel instanceof MOpaqueMenu)) continue;
            oldMenus.add((MOpaqueMenu)itemModel);
        }
        IContributionItem[] items = menuManager.getItems();
        int src = 0;
        int dest = 0;
        while (src < items.length) {
            MMenuElement menuElement;
            IContributionItem item = items[src];
            if (item instanceof MenuManager) {
                MenuManager childManager = (MenuManager)item;
                MMenu childModel = this.getMenuModel(childManager);
                if (childModel == null) {
                    MOpaqueMenu legacyModel = MenuFactoryImpl.eINSTANCE.createOpaqueMenu();
                    legacyModel.setElementId(childManager.getId());
                    legacyModel.setVisible(childManager.isVisible());
                    this.linkModelToManager((MMenu)legacyModel, childManager);
                    modelChildren.add(dest, legacyModel);
                } else {
                    if (childModel instanceof MOpaqueMenu) {
                        oldMenus.remove(childModel);
                    }
                    if (modelChildren.size() > dest) {
                        if (modelChildren.get(dest) != childModel) {
                            modelChildren.remove(childModel);
                            modelChildren.add(dest, childModel);
                        }
                    } else {
                        modelChildren.add(childModel);
                    }
                }
            } else if (item.isSeparator() || item.isGroupMarker()) {
                MOpaqueMenuSeparator legacySep;
                menuElement = this.getMenuElement(item);
                if (menuElement == null) {
                    legacySep = MenuFactoryImpl.eINSTANCE.createOpaqueMenuSeparator();
                    legacySep.setElementId(item.getId());
                    legacySep.setVisible(item.isVisible());
                    legacySep.setOpaqueItem((Object)item);
                    this.linkModelToContribution((MMenuElement)legacySep, item);
                    modelChildren.add(dest, legacySep);
                } else if (menuElement instanceof MOpaqueMenuSeparator) {
                    legacySep = (MOpaqueMenuSeparator)menuElement;
                    oldSeps.remove(legacySep);
                    if (modelChildren.size() > dest) {
                        if (modelChildren.get(dest) != legacySep) {
                            modelChildren.remove(legacySep);
                            modelChildren.add(dest, legacySep);
                        }
                    } else {
                        modelChildren.add(legacySep);
                    }
                }
            } else {
                MOpaqueMenuItem legacyItem;
                menuElement = this.getMenuElement(item);
                if (menuElement == null) {
                    legacyItem = MenuFactoryImpl.eINSTANCE.createOpaqueMenuItem();
                    legacyItem.setElementId(item.getId());
                    legacyItem.setVisible(item.isVisible());
                    legacyItem.setOpaqueItem((Object)item);
                    this.linkModelToContribution((MMenuElement)legacyItem, item);
                    modelChildren.add(dest, legacyItem);
                } else if (menuElement instanceof MOpaqueMenuItem) {
                    legacyItem = (MOpaqueMenuItem)menuElement;
                    oldModelItems.remove(legacyItem);
                    if (modelChildren.size() > dest) {
                        if (modelChildren.get(dest) != legacyItem) {
                            modelChildren.remove(legacyItem);
                            modelChildren.add(dest, legacyItem);
                        }
                    } else {
                        modelChildren.add(legacyItem);
                    }
                }
            }
            ++src;
            ++dest;
        }
        if (!oldModelItems.isEmpty()) {
            modelChildren.removeAll(oldModelItems);
            for (MOpaqueMenuItem model : oldModelItems) {
                this.clearModelToContribution((MMenuElement)model, (IContributionItem)model.getOpaqueItem());
            }
        }
        if (!oldMenus.isEmpty()) {
            modelChildren.removeAll(oldMenus);
            for (MOpaqueMenu oldMenu : oldMenus) {
                MenuManager oldManager = this.getManager((MMenu)oldMenu);
                this.clearModelToManager((MMenu)oldMenu, oldManager);
            }
        }
        if (!oldSeps.isEmpty()) {
            modelChildren.removeAll(oldSeps);
            for (MOpaqueMenuSeparator model : oldSeps) {
                this.clearModelToContribution((MMenuElement)model, (IContributionItem)model.getOpaqueItem());
            }
        }
    }

    public static void updateVisibility(MenuManager menuManager, MMenuElement element, ExpressionContext evalContext) {
        if (!(element.getVisibleWhen() instanceof MCoreExpression)) {
            return;
        }
        boolean val = ContributionsAnalyzer.isVisible((MCoreExpression)((MCoreExpression)element.getVisibleWhen()), (ExpressionContext)evalContext);
        if (val != element.isVisible()) {
            element.setVisible(val);
            menuManager.markDirty();
        }
    }

    static class ContributionRecord {
        MMenu menuModel;
        MMenuContribution menuContribution;
        ArrayList<MMenuElement> generatedElements = new ArrayList();
        MenuManagerRenderer renderer;

        public ContributionRecord(MMenu menuModel, MMenuContribution contribution, MenuManagerRenderer renderer) {
            this.menuModel = menuModel;
            this.menuContribution = contribution;
            this.renderer = renderer;
        }

        public MenuManager getManagerForModel() {
            return this.renderer.getManager(this.menuModel);
        }

        public void updateVisibility(IEclipseContext context) {
            ExpressionContext exprContext = new ExpressionContext(context);
            boolean isVisible = ContributionsAnalyzer.isVisible((MMenuContribution)this.menuContribution, (ExpressionContext)exprContext);
            for (MMenuElement item : this.generatedElements) {
                if (isVisible && item.getVisibleWhen() != null) {
                    MenuManagerRenderer.updateVisibility(this.getManagerForModel(), item, exprContext);
                    continue;
                }
                item.setVisible(isVisible);
            }
            this.getManagerForModel().markDirty();
        }

        public void generate() {
            for (MMenuElement item : this.menuContribution.getChildren()) {
                MMenuElement copy = (MMenuElement)EcoreUtil.copy((EObject)((EObject)item));
                this.generatedElements.add(copy);
            }
        }

        public void dispose() {
            for (MMenuElement copy : this.generatedElements) {
                this.menuModel.getChildren().remove(copy);
            }
        }
    }
}

