/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResourceInfo;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.resources.semantic.test.provider.RestTestContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestsRestContentProvider
extends TestsContentProviderUtil {
    @Before
    public void beforeMethod() throws Exception {
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = workspace.newProjectDescription(TestsRestContentProvider.this.projectName);
                try {
                    description.setLocationURI(new URI("semanticfs:/" + TestsRestContentProvider.this.projectName));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                project.create(description, monitor);
                project.open(monitor);
                RemoteStoreTransient store = (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
                RemoteFolder f1 = store.getRootFolder().addFolder("Folder1");
                f1.addFolder("Folder11");
                RepositoryProvider.map((IProject)project, (String)"org.eclipse.core.internal.resources.semantic.DelegatingRepositoryProvider");
                ISemanticProject spr = (ISemanticProject)project.getAdapter(ISemanticProject.class);
                spr.addFolder("root", TestsRestContentProvider.this.providerName, null, TestsRestContentProvider.this.options, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        workspace.run(myRunnable, (ISchedulingRule)workspace.getRoot(), 1, null);
        this.testProject = project;
    }

    @After
    public void afterMethod() throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(this.projectName);
        RemoteStoreTransient store = (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
        store.reset();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.delete(true, monitor);
                project.refreshLocal(2, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.testProject = null;
    }

    public TestsRestContentProvider() {
        super(true, "TestsRestContentProvider", RestTestContentProvider.class.getName());
    }

    @Test
    public void testAddFileWithUri() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final ISemanticFolder sf = (ISemanticFolder)root.getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile uriFile;
                try {
                    uriFile = sf.addFile("file", new URI("file:someUri/which/is/long"), TestsRestContentProvider.this.options, monitor);
                    sf.getAdaptedResource().refreshLocal(2, monitor);
                    ISemanticResourceInfo info = uriFile.fetchResourceInfo(32, monitor);
                    Assert.assertFalse((String)"Remote existence", (boolean)info.existsRemotely());
                    try {
                        Util.safeClose((InputStream)uriFile.getAdaptedFile().getContents());
                        Assert.fail((String)"Should have failed");
                    }
                    catch (CoreException coreException) {}
                    uriFile = sf.addFile("file2", new URI("http://www.google.de"), TestsRestContentProvider.this.options, monitor);
                    sf.getAdaptedResource().refreshLocal(2, monitor);
                    info = uriFile.fetchResourceInfo(32, monitor);
                    try {
                        Util.safeClose((InputStream)uriFile.getAdaptedFile().getContents());
                    }
                    catch (Exception exception) {}
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.resources.semantic.examples.test", e.getMessage(), (Throwable)e));
                }
                String uriString = uriFile.fetchResourceInfo(64, monitor).getRemoteURIString();
                Assert.assertEquals((Object)"http://www.google.de", (Object)uriString);
                try {
                    IResource[] resources = sf.findURI(new URI("http://www.google.de"), monitor);
                    Assert.assertEquals((long)1L, (long)resources.length);
                    Assert.assertEquals((Object)"file2", (Object)resources[0].getName());
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.resources.semantic.examples.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileWithUriChangeSyncInocmingAndRevert() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final File file = this.createTestFile("AFile.txt");
        boolean created = file.createNewFile();
        if (!created) {
            new FileOutputStream(file).close();
        }
        final ISemanticFolder sf = (ISemanticFolder)root.getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ISemanticFile uriFile = sf.addFile("file2", TestsRestContentProvider.this.createURI4File(file), TestsRestContentProvider.this.options, monitor);
                    sf.getAdaptedResource().getProject().refreshLocal(2, monitor);
                    TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "");
                    ISemanticResourceInfo info = uriFile.fetchResourceInfo(32, monitor);
                    Assert.assertTrue((String)"Remote existence", (boolean)info.existsRemotely());
                    FileOutputStream os = null;
                    try {
                        try {
                            os = new FileOutputStream(file);
                            os.write("Hello World".getBytes("UTF-8"));
                            os.close();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Util.safeClose(os);
                        throw throwable;
                    }
                    Util.safeClose((OutputStream)os);
                    TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "");
                    uriFile.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsRestContentProvider.this.options, monitor);
                    sf.getAdaptedResource().getProject().refreshLocal(2, monitor);
                    TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "Hello World");
                    long firstTime = uriFile.getAdaptedFile().getLocalTimeStamp();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        uriFile.validateEdit(null);
                        uriFile.getAdaptedFile().setContents((InputStream)new ByteArrayInputStream("Another world".getBytes("UTF-8")), 0, monitor);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "Another world");
                    long secondTime = uriFile.getAdaptedFile().getLocalTimeStamp();
                    Assert.assertTrue((String)"Timstamps should differ", (secondTime > firstTime ? 1 : 0) != 0);
                    uriFile.revertChanges(TestsRestContentProvider.this.options, monitor);
                    sf.getAdaptedResource().getProject().refreshLocal(2, monitor);
                    TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "Hello World");
                    long thirdTime = uriFile.getAdaptedFile().getLocalTimeStamp();
                    Assert.assertTrue((String)"Timestamp should be the same", (thirdTime == firstTime ? 1 : 0) != 0);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        uriFile.validateEdit(null);
                        uriFile.getAdaptedFile().setContents((InputStream)new ByteArrayInputStream("Yet another world".getBytes("UTF-8")), 0, monitor);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "Yet another world");
                    long fourthTime = uriFile.getAdaptedFile().getLocalTimeStamp();
                    Assert.assertTrue((String)"Timstamps should differ", (fourthTime > secondTime ? 1 : 0) != 0);
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.resources.semantic.examples.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAddFileWithUriChangeSyncOutgoingAndRevert() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final File file = this.createTestFile("AFile.txt");
        boolean created = file.createNewFile();
        if (!created) {
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write("I'm remote".getBytes("UTF-8"));
            ((OutputStream)os).close();
        }
        final ISemanticFolder sf = (ISemanticFolder)root.getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile uriFile;
                try {
                    uriFile = sf.addFile("file2", TestsRestContentProvider.this.createURI4File(file), TestsRestContentProvider.this.options, monitor);
                }
                catch (URISyntaxException e2) {
                    throw new RuntimeException(e2);
                }
                sf.getAdaptedResource().getProject().refreshLocal(2, monitor);
                TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "I'm remote");
                long firstTime = uriFile.getAdaptedFile().getLocalTimeStamp();
                try {
                    uriFile.validateEdit(null);
                    uriFile.getAdaptedFile().setContents((InputStream)new ByteArrayInputStream("New content".getBytes("UTF-8")), 0, monitor);
                }
                catch (UnsupportedEncodingException e1) {
                    throw new RuntimeException(e1);
                }
                TestsRestContentProvider.this.assertContentsEqual(file, "I'm remote");
                TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "New content");
                long filestamp = file.lastModified();
                Assert.assertEquals((String)"Timestamp should be the same", (long)filestamp, (long)firstTime);
                sf.synchronizeContentWithRemote(SyncDirection.OUTGOING, TestsRestContentProvider.this.options, monitor);
                sf.getAdaptedResource().getProject().refreshLocal(2, monitor);
                TestsRestContentProvider.this.assertContentsEqual(file, "New content");
                long secondTime = uriFile.getAdaptedFile().getLocalTimeStamp();
                Assert.assertTrue((String)"Timstamps should differ", (secondTime > filestamp ? 1 : 0) != 0);
                if ("win32".equals(Platform.getOS())) {
                    Assert.assertEquals((String)"Timestamp should be the same", (long)file.lastModified(), (long)secondTime);
                } else {
                    long millis = secondTime % 1000L;
                    Assert.assertEquals((String)"Timestamp should be the same", (long)file.lastModified(), (long)(secondTime - millis));
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    @Ignore
    public void testCreateFileRemotely() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final File file = this.createTestFile("ANewFile.txt");
        if (file.exists() && !file.delete()) {
            throw new RuntimeException("Could not prepare test");
        }
        final ISemanticFolder sf = (ISemanticFolder)root.getAdapter(ISemanticFolder.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile uriFile;
                try {
                    uriFile = sf.createFileRemotely("filenew", (InputStream)new ByteArrayInputStream("Hello World".getBytes()), (Object)TestsRestContentProvider.this.createURI4File(file), TestsRestContentProvider.this.options, monitor);
                    uriFile.getAdaptedFile().getParent().refreshLocal(2, monitor);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                sf.getAdaptedResource().getProject().refreshLocal(2, monitor);
                TestsRestContentProvider.this.assertContentsEqual(uriFile.getAdaptedFile(), "Hello World");
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    void assertContentsEqual(File file, String test) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byte[] buffer = new byte[((InputStream)is).available()];
            ((InputStream)is).read(buffer);
            Util.safeClose((InputStream)is);
            Assert.assertEquals((String)"Wrong content", (Object)test, (Object)new String(buffer, "UTF-8"));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception getting file content: " + e.getMessage()));
        }
    }
}

