/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples;

import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddDemoRESTResourcePage
extends WizardPage {
    public static final String NAME = AddDemoRESTResourcePage.class.getName();
    final ISemanticFolder myFolder;
    String resourceName;
    String resourceURI;
    Text folderPath;

    public AddDemoRESTResourcePage(ISemanticFolder folder) {
        super(NAME);
        this.myFolder = folder;
        this.setTitle(Messages.AddDemoRESTResourcePage_AddRestResource_XGRP);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        Label folderPathLabel = new Label(main, 0);
        folderPathLabel.setText(Messages.AddDemoRESTResourcePage_Folder_XFLD);
        this.folderPath = new Text(main, 0);
        this.folderPath.setEditable(false);
        this.folderPath.setText(this.myFolder.getAdaptedContainer().getFullPath().toString());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.folderPath);
        Label nameLabel = new Label(main, 0);
        nameLabel.setText(Messages.AddDemoRESTResourcePage_ResName_XFLD);
        final Text name = new Text(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)name);
        Label uriLabel = new Label(main, 0);
        uriLabel.setText(Messages.AddDemoRESTResourcePage_ResUrl_XFLD);
        final Text urlInput = new Text(main, 2048);
        urlInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String urlstring = urlInput.getText();
                if (urlstring.equals("")) {
                    AddDemoRESTResourcePage.this.setErrorMessage(Messages.AddDemoRESTResourcePage_Provide_URL_XMSG);
                    AddDemoRESTResourcePage.this.resourceURI = null;
                    AddDemoRESTResourcePage.this.setPageComplete(false);
                } else {
                    AddDemoRESTResourcePage.this.setErrorMessage(null);
                    AddDemoRESTResourcePage.this.resourceURI = urlstring;
                    AddDemoRESTResourcePage.this.setPageComplete(true);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)urlInput);
        name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean childFound;
                String rname = name.getText();
                if (rname == null || rname.length() == 0) {
                    AddDemoRESTResourcePage.this.setErrorMessage(Messages.AddDemoRESTResourcePage_ProvideFileName_XMSG);
                    AddDemoRESTResourcePage.this.resourceName = null;
                    AddDemoRESTResourcePage.this.setPageComplete(false);
                    return;
                }
                try {
                    childFound = AddDemoRESTResourcePage.this.myFolder.hasResource(name.getText());
                }
                catch (CoreException coreException) {
                    childFound = false;
                }
                if (childFound) {
                    AddDemoRESTResourcePage.this.setErrorMessage(Messages.AddDemoRESTResourcePage_FileExists_XMSG);
                    AddDemoRESTResourcePage.this.resourceName = null;
                    AddDemoRESTResourcePage.this.setPageComplete(false);
                } else {
                    AddDemoRESTResourcePage.this.setErrorMessage(null);
                    AddDemoRESTResourcePage.this.resourceName = rname;
                    AddDemoRESTResourcePage.this.setPageComplete(true);
                }
            }
        });
        this.setControl((Control)main);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceURL() {
        return this.resourceURI.replace('\\', '/');
    }
}

