/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.platform.discovery.util.internal.xml.IXMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils
implements IXMLUtils {
    @Override
    public List<Element> findFirstLevelElements(Element elem) {
        NodeList childNodes = elem.getChildNodes();
        ArrayList<Element> ret = new ArrayList<Element>(childNodes.getLength());
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1) {
                ret.add((Element)childNodes.item(i));
            }
            ++i;
        }
        return ret;
    }

    @Override
    public String toXML(Element xmlElem) {
        try {
            return this.toXml((Source)new DOMSource(xmlElem), this.encoding(xmlElem));
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
    }

    @Override
    public String toXml(Source xmlSource, String encoding) throws TransformerException {
        return this.toXml(xmlSource, Charset.forName(encoding));
    }

    @Override
    public String toXml(Source xmlSource, Charset charset) throws TransformerException {
        Transformer serializer;
        ByteArrayOutputStream memBuf = new ByteArrayOutputStream();
        try {
            serializer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("encoding", charset.name());
        StreamResult streamResult = new StreamResult(memBuf);
        serializer.transform(xmlSource, streamResult);
        InputStreamReader inputStreamReader = null;
        inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream(memBuf.toByteArray()), charset);
        StringBuilder builder = new StringBuilder();
        char[] transfBuf = new char[512];
        try {
            int r = inputStreamReader.read(transfBuf);
            while (r != -1) {
                builder.append(transfBuf, 0, r);
                r = inputStreamReader.read(transfBuf);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return builder.toString();
    }

    @Override
    public String encoding(Element xmlElem) {
        String encoding = xmlElem.getOwnerDocument().getXmlEncoding();
        if (encoding == null) {
            return "UTF-8";
        }
        return encoding;
    }

    @Override
    public Element bytes2RootElement(byte[] bytes) throws SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(bytes)).getDocumentElement();
    }

    @Override
    public Element charsToRootElement(char[] chars) throws SAXException, IOException {
        DocumentBuilder builder = this.createDocumentBuilder();
        return builder.parse(new InputSource(new CharArrayReader(chars))).getDocumentElement();
    }

    private DocumentBuilder createDocumentBuilder() {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder;
    }

    @Override
    public TransformerHandler createTransformerHandler(Writer writer) throws TransformerConfigurationException {
        PrintWriter pWriter = new PrintWriter(writer);
        StreamResult streamResult = new StreamResult(pWriter);
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = hd.getTransformer();
        serializer.setOutputProperty("encoding", "UTF-8");
        serializer.setOutputProperty("standalone", "yes");
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.setOutputProperty("method", "xml");
        hd.setResult(streamResult);
        return hd;
    }

    @Override
    public List<Element> findFirstLevelElements(Element elem, String nsURI, String localName) {
        ArrayList<Element> ret = new ArrayList<Element>();
        for (Element e : this.findFirstLevelElements(elem)) {
            if (!nsURI.equals(e.getNamespaceURI()) || !localName.equals(e.getLocalName())) continue;
            ret.add(e);
        }
        return ret;
    }
}

