/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.bindings.tests;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.bindings.tests.Activator;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;

public class BindingLookupTest
extends TestCase {
    private static final String ID_DIALOG = "org.eclipse.ui.contexts.dialog";
    private static final String ID_DIALOG_AND_WINDOW = "org.eclipse.ui.contexts.dialogAndWindow";
    private static final String ID_WINDOW = "org.eclipse.ui.contexts.window";
    private static final String ID_TEXT = "org.eclipse.ui.textScope";
    private static final String ID_JAVA = "org.eclipse.jdt.ui.javaScope";
    private static final String ID_JS = "org.eclipse.wst.jsdt.ui.javaScriptScope";
    static final String[] CONTEXTS;
    private static final String TEST_CAT1 = "test.cat1";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID2 = "test.id2";
    private IEclipseContext workbenchContext;

    static {
        String[] stringArray = new String[18];
        stringArray[0] = ID_DIALOG_AND_WINDOW;
        stringArray[1] = "DAW";
        stringArray[3] = ID_DIALOG;
        stringArray[4] = "Dialog";
        stringArray[5] = ID_DIALOG_AND_WINDOW;
        stringArray[6] = ID_WINDOW;
        stringArray[7] = "Window";
        stringArray[8] = ID_DIALOG_AND_WINDOW;
        stringArray[9] = ID_TEXT;
        stringArray[10] = "Text Scope";
        stringArray[11] = ID_WINDOW;
        stringArray[12] = ID_JAVA;
        stringArray[13] = "Java scope";
        stringArray[14] = ID_TEXT;
        stringArray[15] = ID_JS;
        stringArray[16] = "JavaScript scope";
        stringArray[17] = ID_TEXT;
        CONTEXTS = stringArray;
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
    }

    protected void setUp() throws Exception {
        IEclipseContext globalContext = Activator.getDefault().getGlobalContext();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.workbenchContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.workbenchContext);
        this.defineCommands(this.workbenchContext);
        this.defineContexts(this.workbenchContext);
        this.defineBindingTables(this.workbenchContext);
    }

    private void defineContexts(IEclipseContext context) {
        ContextManager contextManager = (ContextManager)context.get(ContextManager.class);
        int i = 0;
        while (i < CONTEXTS.length) {
            Context c = contextManager.getContext(CONTEXTS[i]);
            c.define(CONTEXTS[i + 1], null, CONTEXTS[i + 2]);
            i += 3;
        }
        EContextService cs = (EContextService)context.get(EContextService.class.getName());
        cs.activateContext(ID_DIALOG_AND_WINDOW);
    }

    private void defineBindingTables(IEclipseContext context) {
        BindingTableManager btm = (BindingTableManager)context.get(BindingTableManager.class);
        ContextManager cm = (ContextManager)context.get(ContextManager.class);
        btm.addTable(new BindingTable(cm.getContext(ID_DIALOG_AND_WINDOW)));
        btm.addTable(new BindingTable(cm.getContext(ID_WINDOW)));
        btm.addTable(new BindingTable(cm.getContext(ID_DIALOG)));
    }

    protected void tearDown() throws Exception {
        this.workbenchContext.dispose();
        this.workbenchContext = null;
    }

    public void testFindBinding() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Binding perfectMatch = bs.getPerfectMatch(seq);
        BindingLookupTest.assertEquals((Object)cmd, (Object)perfectMatch.getParameterizedCommand());
        bs.deactivateBinding(db);
        BindingLookupTest.assertNull((Object)bs.getPerfectMatch(seq));
        bs.activateBinding(db);
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq).getParameterizedCommand());
    }

    public void testMultipleBindings() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        TriggerSequence seq2 = bs.createSequence("CTRL+2 X");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        db = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs.getPerfectMatch(seq2).getParameterizedCommand());
    }

    public void testLookupChildBinding() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs1, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(db);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        BindingLookupTest.assertEquals((Object)cmd, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        bs1.deactivateBinding(db);
        BindingLookupTest.assertNull((Object)wBS.getPerfectMatch(seq));
        BindingLookupTest.assertNull((Object)bs1.getPerfectMatch(seq));
    }

    public void testLookupWithTwoChildren() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class.getName());
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        Binding db = this.createDefaultBinding(bs1, seq, cmd1, ID_WINDOW);
        bs1.activateBinding(db);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EContextService es2 = (EContextService)c2.get(EContextService.class.getName());
        es2.activateContext(ID_DIALOG);
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class.getName());
        db = this.createDefaultBinding(bs1, seq, cmd2, ID_DIALOG);
        bs2.activateBinding(db);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
    }

    public void testLookupWithDifferentActiveChild() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class.getName());
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        Binding db = this.createDefaultBinding(bs1, seq, cmd1, ID_WINDOW);
        bs1.activateBinding(db);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EContextService es2 = (EContextService)c2.get(EContextService.class.getName());
        es2.activateContext(ID_DIALOG);
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class.getName());
        db = this.createDefaultBinding(bs1, seq, cmd2, ID_DIALOG);
        bs2.activateBinding(db);
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        c2.activate();
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        c1.activate();
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd1, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        c2.activate();
        BindingLookupTest.assertEquals((Object)cmd1, (Object)bs1.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)bs2.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertEquals((Object)cmd2, (Object)wBS.getPerfectMatch(seq).getParameterizedCommand());
        BindingLookupTest.assertTrue((boolean)wBS.isPerfectMatch(seq));
    }

    public void testLookupShortcut() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        BindingLookupTest.assertEquals((Object)seq, (Object)bs.getBestSequenceFor(cmd));
    }

    public void testLookupShortcuts() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        TriggerSequence seq2 = bs.createSequence("CTRL+2 X");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        BindingLookupTest.assertNotNull((Object)foundSequence);
        BindingLookupTest.assertEquals((Object)seq, (Object)foundSequence);
    }

    public void testLookupBestShortcut() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = bs.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        BindingLookupTest.assertNotNull((Object)foundSequence);
        BindingLookupTest.assertEquals((Object)seq, (Object)foundSequence);
    }

    public void testLookupBestShortcutWithChild() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = bs.createSequence("CTRL+5 T");
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("ALT+5 X");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(db);
        TriggerSequence foundSequence = bs.getBestSequenceFor(cmd);
        BindingLookupTest.assertNotNull((Object)foundSequence);
        BindingLookupTest.assertEquals((Object)seq2, (Object)foundSequence);
    }

    public void testLookupShortcutsTwoChildren() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd1 = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq = wBS.createSequence("CTRL+5 T");
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class.getName());
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        Binding db = this.createDefaultBinding(bs1, seq, cmd1, ID_WINDOW);
        bs1.activateBinding(db);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EContextService es2 = (EContextService)c2.get(EContextService.class.getName());
        es2.activateContext(ID_DIALOG);
        EBindingService bs2 = (EBindingService)c2.get(EBindingService.class.getName());
        Binding db2 = this.createDefaultBinding(bs2, seq, cmd2, ID_DIALOG);
        bs2.activateBinding(db2);
        BindingLookupTest.assertEquals((Object)seq, (Object)wBS.getBestSequenceFor(cmd1));
        BindingLookupTest.assertNull((Object)wBS.getBestSequenceFor(cmd2));
        BindingLookupTest.assertEquals((Object)seq, (Object)bs1.getBestSequenceFor(cmd1));
        BindingLookupTest.assertNull((Object)bs1.getBestSequenceFor(cmd2));
        BindingLookupTest.assertEquals((Object)seq, (Object)bs2.getBestSequenceFor(cmd2));
        BindingLookupTest.assertNull((Object)bs2.getBestSequenceFor(cmd1));
    }

    public void testLookupAllShortcuts() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService bs = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = bs.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(bs, seq2, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db2);
        TriggerSequence seq = bs.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(bs, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs.activateBinding(db);
        ArrayList<TriggerSequence> list = new ArrayList<TriggerSequence>();
        list.add(seq);
        list.add(seq2);
        BindingLookupTest.assertEquals(list, (Object)bs.getSequencesFor(cmd));
    }

    public void testLookupAllShortcutsWithChild() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(wBS, seq2, cmd, ID_DIALOG_AND_WINDOW);
        wBS.activateBinding(db2);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EContextService es = (EContextService)c1.get(EContextService.class.getName());
        es.activateContext(ID_WINDOW);
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(wBS, seq, cmd, ID_WINDOW);
        bs1.activateBinding(db);
        ArrayList<TriggerSequence> list = new ArrayList<TriggerSequence>();
        list.add(seq);
        list.add(seq2);
        BindingLookupTest.assertEquals(list, (Object)wBS.getSequencesFor(cmd));
    }

    public void testPartialMatch() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        Binding db2 = this.createDefaultBinding(wBS, seq2, cmd, ID_DIALOG_AND_WINDOW);
        wBS.activateBinding(db2);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding db = this.createDefaultBinding(wBS, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(db);
        TriggerSequence partialMatch = bs1.createSequence("CTRL+5");
        TriggerSequence partialNoMatch = bs1.createSequence("CTRL+8");
        BindingLookupTest.assertFalse((boolean)bs1.isPartialMatch(partialNoMatch));
        BindingLookupTest.assertTrue((boolean)bs1.isPartialMatch(partialMatch));
    }

    public void testGetPartialMatches() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class.getName());
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        ParameterizedCommand cmd2 = cs.createCommand(TEST_ID2, null);
        EBindingService wBS = (EBindingService)this.workbenchContext.get(EBindingService.class.getName());
        TriggerSequence seq2 = wBS.createSequence("ALT+5 X");
        Binding wbBind = this.createDefaultBinding(wBS, seq2, cmd, ID_DIALOG_AND_WINDOW);
        wBS.activateBinding(wbBind);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EBindingService bs1 = (EBindingService)c1.get(EBindingService.class.getName());
        TriggerSequence seq = bs1.createSequence("CTRL+5 T");
        Binding b1 = this.createDefaultBinding(wBS, seq, cmd, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(b1);
        TriggerSequence sseq = bs1.createSequence("CTRL+5 Y");
        Binding b2 = this.createDefaultBinding(bs1, sseq, cmd2, ID_DIALOG_AND_WINDOW);
        bs1.activateBinding(b2);
        ArrayList<Binding> commandMatches = new ArrayList<Binding>();
        commandMatches.add(b1);
        commandMatches.add(b2);
        TriggerSequence partialMatch = bs1.createSequence("CTRL+5");
        TriggerSequence partialNoMatch = bs1.createSequence("CTRL+8");
        BindingLookupTest.assertFalse((boolean)bs1.isPartialMatch(partialNoMatch));
        BindingLookupTest.assertTrue((boolean)bs1.isPartialMatch(partialMatch));
        Collection matches = bs1.getPartialMatches(partialMatch);
        BindingLookupTest.assertEquals(commandMatches, (Object)matches);
    }

    private Binding createDefaultBinding(EBindingService bs, TriggerSequence sequence, ParameterizedCommand command, String contextId) {
        return bs.createBinding(sequence, command, "org.eclipse.ui.defaultAcceleratorConfiguration", contextId);
    }
}

