/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static EClassifier getTypeArgument(EClass eClass, EGenericType eGenericType) {
        ETypeParameter eTypeParameter = eGenericType.getETypeParameter();
        if (eTypeParameter != null) {
            for (EGenericType eGenericSuperType : eClass.getEAllGenericSuperTypes()) {
                EList eTypeParameters = eGenericSuperType.getEClassifier().getETypeParameters();
                int index = eTypeParameters.indexOf((Object)eTypeParameter);
                if (index == -1 || eGenericSuperType.getETypeArguments().size() <= index) continue;
                return ModelUtils.getTypeArgument(eClass, (EGenericType)eGenericSuperType.getETypeArguments().get(index));
            }
            return null;
        }
        return eGenericType.getEClassifier();
    }

    public static MApplicationElement findElementById(MApplicationElement element, String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (id.equals(element.getElementId())) {
            return element;
        }
        EList elements = ((EObject)element).eContents();
        for (EObject childElement : elements) {
            MApplicationElement result;
            if (!(childElement instanceof MApplicationElement) || (result = ModelUtils.findElementById((MApplicationElement)childElement, id)) == null) continue;
            return result;
        }
        return null;
    }

    public static List<MApplicationElement> merge(MApplicationElement container, EStructuralFeature feature, List<MApplicationElement> elements, String positionInList) {
        EObject eContainer = (EObject)container;
        if (feature.isMany()) {
            ArrayList<MApplicationElement> copy = new ArrayList<MApplicationElement>(elements);
            List list = (List)eContainer.eGet(feature);
            boolean flag = true;
            if (positionInList != null && positionInList.trim().length() != 0) {
                int index = -1;
                if (positionInList.startsWith("first")) {
                    index = 0;
                } else if (positionInList.startsWith("index:")) {
                    index = Integer.parseInt(positionInList.substring("index:".length()));
                } else if (positionInList.startsWith("before:") || positionInList.startsWith("after:")) {
                    boolean before;
                    String elementId;
                    if (positionInList.startsWith("before:")) {
                        elementId = positionInList.substring("before:".length());
                        before = true;
                    } else {
                        elementId = positionInList.substring("after:".length());
                        before = false;
                    }
                    int tmpIndex = -1;
                    int i = 0;
                    while (i < list.size()) {
                        if (elementId.equals(((MApplicationElement)list.get(i)).getElementId())) {
                            tmpIndex = i;
                            break;
                        }
                        ++i;
                    }
                    if (tmpIndex != -1) {
                        index = before ? tmpIndex : tmpIndex + 1;
                    } else {
                        System.err.println("Could not find element with Id '" + elementId + "'");
                    }
                } else {
                    System.err.println("Not a valid list position.");
                }
                if (index >= 0 && list.size() > index) {
                    flag = false;
                    list.addAll(index, elements);
                }
            }
            if (flag) {
                list.addAll(elements);
            }
            return copy;
        }
        if (elements.size() >= 1) {
            if (elements.size() > 1) {
                System.err.println("The feature is single valued but a list of values is passed in.");
            }
            MApplicationElement e = elements.get(0);
            eContainer.eSet(feature, (Object)e);
            return Collections.singletonList(e);
        }
        return Collections.emptyList();
    }
}

