/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.SashLayout;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SashRenderer
extends SWTPartRenderer {
    @Inject
    private IEventBroker eventBroker;
    private static final int UNDEFINED_WEIGHT = -1;
    private static final int DEFAULT_WEIGHT = 100;
    private EventHandler sashOrientationHandler;
    private EventHandler sashWeightHandler;

    @PostConstruct
    void postConstruct() {
        this.sashOrientationHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (element.getRenderer() != SashRenderer.this) {
                    return;
                }
                SashRenderer.this.forceLayout((MElementContainer<MUIElement>)((MElementContainer)element));
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/GenericTile", (String)"horizontal"), this.sashOrientationHandler);
        this.sashWeightHandler = new EventHandler(){

            public void handleEvent(Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                MElementContainer parent = element.getParent();
                if (parent.getRenderer() != SashRenderer.this) {
                    return;
                }
                SashRenderer.this.forceLayout((MElementContainer<MUIElement>)parent);
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"containerData"), this.sashWeightHandler);
    }

    protected void forceLayout(MElementContainer<MUIElement> pscModel) {
        while (!(pscModel.getWidget() instanceof Control)) {
            pscModel = pscModel.getParent();
        }
        Control ctrl = (Control)pscModel.getWidget();
        if (ctrl instanceof Shell) {
            ((Shell)ctrl).layout(null, 7);
        } else {
            ctrl.getParent().layout(null, 7);
        }
    }

    @PreDestroy
    void preDestroy() {
        this.eventBroker.unsubscribe(this.sashOrientationHandler);
        this.eventBroker.unsubscribe(this.sashWeightHandler);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (element.getParent() != null) {
            Rectangle newRect = new Rectangle(0, 0, 0, 0);
            return newRect;
        }
        Composite sashComposite = new Composite((Composite)parent, 0);
        sashComposite.setLayout((Layout)new SashLayout(sashComposite, null));
        return sashComposite;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        int weight;
        super.childRendered(parentElement, element);
        if (parentElement.getWidget() instanceof Composite) {
            Composite c = (Composite)parentElement.getWidget();
            SashLayout sl = (SashLayout)c.getLayout();
            sl.setRootElemenr(element);
        }
        if ((weight = SashRenderer.getWeight(element)) == -1) {
            element.setContainerData(Integer.toString(100));
        }
        this.forceLayout(parentElement);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        this.forceLayout(parentElement);
    }

    public Object getUIContainer(MUIElement element) {
        MElementContainer parentElement = element.getParent();
        if (parentElement.getWidget() instanceof Composite) {
            return parentElement.getWidget();
        }
        MElementContainer prevParent = null;
        while (parentElement instanceof MPartSashContainer && !(parentElement.getWidget() instanceof Composite) && !(parentElement instanceof MArea)) {
            prevParent = parentElement;
            parentElement = parentElement.getParent();
        }
        if (parentElement.getRenderer() instanceof AbstractPartRenderer) {
            AbstractPartRenderer renderer = (AbstractPartRenderer)parentElement.getRenderer();
            return renderer.getUIContainer((MUIElement)prevParent);
        }
        return null;
    }

    private static int getWeight(MUIElement element) {
        String info = element.getContainerData();
        if (info == null || info.length() == 0) {
            element.setContainerData(Integer.toString(10000));
            info = element.getContainerData();
        }
        try {
            int value = Integer.parseInt(info);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }
}

