/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.swt.util;

import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.bindings.internal.BindingTable;
import org.eclipse.e4.ui.bindings.internal.BindingTableManager;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingProcessingAddon {
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker broker;
    @Inject
    private ContextManager contextManager;
    @Inject
    private BindingTableManager bindingTables;
    @Inject
    private ECommandService commandService;
    @Inject
    private EBindingService bindingService;
    private EventHandler additionHandler;

    @PostConstruct
    public void init() {
        this.defineBindingTables();
        this.registerModelListeners();
    }

    private void defineBindingTables() {
        Activator.trace((String)"/trace/commands", (String)"Initialize binding tables from model", null);
        for (MBindingTable bindingTable : this.application.getBindingTables()) {
            this.defineBindingTable(bindingTable);
        }
    }

    private void defineBindingTable(MBindingTable bindingTable) {
        Context bindingContext = this.contextManager.getContext(bindingTable.getBindingContextId());
        BindingTable table = this.bindingTables.getTable(bindingTable.getBindingContextId());
        if (table == null) {
            table = new BindingTable(bindingContext);
            this.bindingTables.addTable(table);
        }
        for (MKeyBinding binding : bindingTable.getBindings()) {
            this.defineBinding(table, bindingContext, binding);
        }
    }

    private void defineBinding(BindingTable bindingTable, Context bindingContext, MKeyBinding binding) {
        Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null) {
            bindingTable.addBinding(keyBinding);
        }
    }

    private Binding createBinding(Context bindingContext, MCommand cmdModel, List<MParameter> modelParms, String keySequence, MKeyBinding binding) {
        if (cmdModel == null) {
            Activator.log((int)4, (String)("binding with no command: " + binding));
            return null;
        }
        HashMap<String, String> parameters = null;
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = this.commandService.createCommand(cmdModel.getElementId(), parameters);
        TriggerSequence sequence = null;
        sequence = this.bindingService.createSequence(keySequence);
        Binding keyBinding = null;
        if (cmd == null || sequence == null) {
            System.err.println("Failed to handle binding: " + binding);
        } else {
            try {
                keyBinding = this.bindingService.createBinding(sequence, cmd, "org.eclipse.ui.defaultAcceleratorConfiguration", bindingContext.getId());
            }
            catch (IllegalArgumentException e) {
                Activator.trace((String)"/trace/menus", (String)("failed to create: " + binding), (Throwable)e);
                return null;
            }
        }
        return keyBinding;
    }

    private void updateBinding(MKeyBinding binding, boolean add) {
        EObject parentObj = ((EObject)binding).eContainer();
        if (!(parentObj instanceof MBindingTable)) {
            return;
        }
        MBindingTable bt = (MBindingTable)parentObj;
        Context bindingContext = this.contextManager.getContext(bt.getBindingContextId());
        BindingTable table = this.bindingTables.getTable(bindingContext.getId());
        if (table == null) {
            Activator.log((int)4, (String)("Trying to create '" + binding + "' without binding table " + bindingContext.getId()));
            return;
        }
        Binding keyBinding = this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
        if (keyBinding != null) {
            if (add) {
                table.addBinding(keyBinding);
            } else {
                table.removeBinding(keyBinding);
            }
        }
    }

    @PreDestroy
    public void dispose() {
        this.unregsiterModelListeners();
    }

    private void registerModelListeners() {
        this.additionHandler = new EventHandler(){

            public void handleEvent(Event event) {
                Object elementObj = event.getProperty("ChangedElement");
                if (elementObj instanceof MApplication) {
                    Object newObj = event.getProperty("NewValue");
                    if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MBindingTable) {
                        MBindingTable bt = (MBindingTable)newObj;
                        Context bindingContext = BindingProcessingAddon.this.contextManager.getContext(bt.getBindingContextId());
                        BindingTable table = new BindingTable(bindingContext);
                        BindingProcessingAddon.this.bindingTables.addTable(table);
                        List bindings = bt.getBindings();
                        for (MKeyBinding binding : bindings) {
                            Binding keyBinding = BindingProcessingAddon.this.createBinding(bindingContext, binding.getCommand(), binding.getParameters(), binding.getKeySequence(), binding);
                            if (keyBinding == null) continue;
                            table.addBinding(keyBinding);
                        }
                    }
                } else if (elementObj instanceof MBindingTable) {
                    Object newObj = event.getProperty("NewValue");
                    Object oldObj = event.getProperty("OldValue");
                    if ("ADD".equals(event.getProperty("EventType")) && newObj instanceof MKeyBinding) {
                        MKeyBinding binding = (MKeyBinding)newObj;
                        BindingProcessingAddon.this.updateBinding(binding, true);
                    } else if ("REMOVE".equals(event.getProperty("EventType")) && oldObj instanceof MKeyBinding) {
                        MKeyBinding binding = (MKeyBinding)oldObj;
                        BindingProcessingAddon.this.updateBinding(binding, false);
                    }
                } else if (elementObj instanceof MKeyBinding) {
                    MKeyBinding binding = (MKeyBinding)elementObj;
                    String attrName = (String)event.getProperty("AttName");
                    if ("SET".equals(event.getProperty("EventType"))) {
                        Object oldObj = event.getProperty("OldValue");
                        if ("command".equals(attrName)) {
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.setCommand((MCommand)oldObj);
                            BindingProcessingAddon.this.updateBinding(oldBinding, false);
                            BindingProcessingAddon.this.updateBinding(binding, true);
                        } else if ("keySequence".equals(attrName)) {
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.setKeySequence((String)oldObj);
                            BindingProcessingAddon.this.updateBinding(oldBinding, false);
                            BindingProcessingAddon.this.updateBinding(binding, true);
                        }
                    } else if ("parameters".equals(attrName)) {
                        if ("ADD".equals(event.getProperty("EventType"))) {
                            Object newObj = event.getProperty("NewValue");
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.getParameters().remove(newObj);
                            BindingProcessingAddon.this.updateBinding(oldBinding, false);
                            BindingProcessingAddon.this.updateBinding(binding, true);
                        } else if ("REMOVE".equals(event.getProperty("EventType"))) {
                            Object oldObj = event.getProperty("OldValue");
                            MKeyBinding oldBinding = (MKeyBinding)EcoreUtil.copy((EObject)((EObject)binding));
                            oldBinding.getParameters().add((MParameter)oldObj);
                            BindingProcessingAddon.this.updateBinding(oldBinding, false);
                            BindingProcessingAddon.this.updateBinding(binding, true);
                        }
                    }
                }
            }
        };
        this.broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/commands/BindingTableContainer", (String)"bindingTables"), this.additionHandler);
        this.broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/commands/BindingTable", (String)"bindings"), this.additionHandler);
        this.broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/commands/KeyBinding", (String)"command"), this.additionHandler);
        this.broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/commands/KeyBinding", (String)"parameters"), this.additionHandler);
        this.broker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/commands/KeySequence", (String)"keySequence"), this.additionHandler);
    }

    private void unregsiterModelListeners() {
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
        this.broker.unsubscribe(this.additionHandler);
    }
}

