/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IObjectTypeExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class ObjectTypeExtensionParser
extends AbstractExtensionPointParser
implements IObjectTypeExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.runtime.objecttype";
    private static final String XP_ELEMENT_NAME = "objecttype";
    private static final String ID_ATTR_NAME = "id";
    private static final String DISPLAY_NAME_ATTR_NAME = "displayname";

    public ObjectTypeExtensionParser() {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
    }

    @Override
    public Set<IObjectTypeDescription> readContributions() {
        HashSet<IObjectTypeDescription> result = new HashSet<IObjectTypeDescription>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            result.add(this.createObjectType(element));
        }
        return result;
    }

    private IObjectTypeDescription createObjectType(final IConfigurationElement element) {
        return new IObjectTypeDescription(){

            @Override
            public String getDisplayName() {
                return element.getAttribute(ObjectTypeExtensionParser.DISPLAY_NAME_ATTR_NAME);
            }

            @Override
            public String getId() {
                return element.getAttribute(ObjectTypeExtensionParser.ID_ATTR_NAME);
            }
        };
    }
}

