/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.selector;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.platform.discovery.runtime.api.IDisplayableObject;
import org.eclipse.platform.discovery.ui.internal.selector.ComboSelector;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InteractiveComboSelector<T extends IDisplayableObject>
extends ComboSelector<T> {
    private final Property<T> lastKnownSelectedItem = new Property();

    public InteractiveComboSelector(Composite parent, FormToolkit formToolkit, Set<T> input, String comboLabel, int secondColumnPosition, Control offset) {
        super(parent, formToolkit, input, comboLabel, secondColumnPosition, offset);
        this.getComboViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InteractiveComboSelector.this.lastKnownSelectedItem.set((Object)((IDisplayableObject)((IStructuredSelection)event.getSelection()).getFirstElement()));
            }
        });
    }

    @Override
    public void setInput(Collection<T> input) {
        super.setInput(input);
        this.setEnabled(input.size() > 0);
        if (input.size() > 0) {
            this.setSelectedItem(this.itemToSelect());
        }
    }

    private T itemToSelect() {
        int index = 0;
        while (this.getComboViewer().getElementAt(index) != null) {
            if (this.getComboViewer().getElementAt(index).equals(this.lastKnownSelectedItem.get())) {
                return (T)((IDisplayableObject)this.lastKnownSelectedItem.get());
            }
            ++index;
        }
        return (T)((IDisplayableObject)this.getComboViewer().getElementAt(0));
    }

    private void setSelectedItem(T item) {
        this.getComboViewer().setSelection((ISelection)new StructuredSelection(item), true);
        this.lastKnownSelectedItem.set(item);
    }
}

