/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class ContributionURIValidator
implements IValidator {
    public IStatus validate(Object value) {
        if (value == null) {
            return new Status(4, "org.eclipse.e4.tools.emf.ui", "The URI must not be empty!");
        }
        if (!value.toString().startsWith("platform:/plugin")) {
            return new Status(4, "org.eclipse.e4.tools.emf.ui", "The URI has to start with 'platform:/plugin'");
        }
        try {
            URI uri = URI.createURI((String)value.toString());
            if (uri.segmentCount() != 3) {
                return new Status(4, "org.eclipse.e4.tools.emf.ui", "The uri has to have the format 'platform:/plugin/$$bundleId$$/$$className$$'");
            }
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.e4.tools.emf.ui", e.getMessage());
        }
        return Status.OK_STATUS;
    }
}

