/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class EModelServiceFindTest
extends TestCase {
    private IEclipseContext applicationContext;
    MApplication app = null;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.applicationContext.dispose();
    }

    private MApplication createApplication() {
        MApplication app = ApplicationFactoryImpl.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setElementId("singleValidId");
        app.getChildren().add(window);
        MPartSashContainer psc = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        psc.setElementId("twoValidIds");
        psc.getTags().add("oneValidTag");
        window.getChildren().add(psc);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("twoValidTags");
        psc.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        part1.setElementId("twoValidIds");
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        part2.getTags().add("twoValidTags");
        part2.getTags().add("secondTag");
        stack.getChildren().add(part2);
        MPart part3 = BasicFactoryImpl.eINSTANCE.createPart();
        psc.getChildren().add(part3);
        return app;
    }

    public void testFindElementsIdOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List elements1 = modelService.findElements((MUIElement)application, "singleValidId", null, null);
        EModelServiceFindTest.assertEquals((int)elements1.size(), (int)1);
        List elements2 = modelService.findElements((MUIElement)application, "twoValidIds", null, null);
        EModelServiceFindTest.assertEquals((int)elements2.size(), (int)2);
        List elements3 = modelService.findElements((MUIElement)application, "invalidId", null, null);
        EModelServiceFindTest.assertEquals((int)elements3.size(), (int)0);
    }

    public void testFindElementsTypeOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List parts = modelService.findElements((MUIElement)application, null, MPart.class, null);
        EModelServiceFindTest.assertEquals((int)parts.size(), (int)3);
        List stacks = modelService.findElements((MUIElement)application, null, MPartStack.class, null);
        EModelServiceFindTest.assertEquals((int)stacks.size(), (int)1);
        List dirtyableElements = modelService.findElements((MUIElement)application, null, MDirtyable.class, null);
        EModelServiceFindTest.assertEquals((int)dirtyableElements.size(), (int)3);
        List uiElements = modelService.findElements((MUIElement)application, null, null, null);
        EModelServiceFindTest.assertEquals((int)uiElements.size(), (int)7);
        List strings = modelService.findElements((MUIElement)application, null, String.class, null);
        EModelServiceFindTest.assertEquals((int)strings.size(), (int)0);
    }

    public void testFindElementsTagsOnly() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List oneTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)oneTags.size(), (int)1);
        tags.clear();
        tags.add("twoValidTags");
        List twoTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)twoTags.size(), (int)2);
        tags.clear();
        tags.add("invalidTag");
        List invalidTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)invalidTags.size(), (int)0);
        tags.clear();
        tags.add("twoValidTags");
        tags.add("secondTag");
        List combinedTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)combinedTags.size(), (int)1);
        tags.clear();
        tags.add("oneValidTag");
        tags.add("secondTag");
        List unmatchedTags = modelService.findElements((MUIElement)application, null, null, tags);
        EModelServiceFindTest.assertEquals((int)unmatchedTags.size(), (int)0);
    }

    public void testFindElementsCombinations() {
        MApplication application = this.createApplication();
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("oneValidTag");
        List idAndType = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, tags);
        EModelServiceFindTest.assertEquals((int)idAndType.size(), (int)1);
        List typeAndTag = modelService.findElements((MUIElement)application, null, MPartSashContainer.class, tags);
        EModelServiceFindTest.assertEquals((int)typeAndTag.size(), (int)1);
        List idAndTag = modelService.findElements((MUIElement)application, "twoValidIds", null, tags);
        EModelServiceFindTest.assertEquals((int)idAndTag.size(), (int)1);
        List idAndTypeAndTags = modelService.findElements((MUIElement)application, "twoValidIds", MPartSashContainer.class, null);
        EModelServiceFindTest.assertEquals((int)idAndTypeAndTags.size(), (int)1);
        List badIdAndTypeAndTags = modelService.findElements((MUIElement)application, "invalidId", MPartSashContainer.class, null);
        EModelServiceFindTest.assertEquals((int)badIdAndTypeAndTags.size(), (int)0);
    }

    public void testBug314685() {
        MApplication application = this.createApplication();
        application.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getSharedElements().add(partStack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(part);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)partStack);
        perspectiveA.getChildren().add(placeholderA);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        EModelService modelService = (EModelService)application.getContext().get(EModelService.class.getName());
        EModelServiceFindTest.assertNotNull((Object)modelService);
        List elements = modelService.findElements((MUIElement)window, null, MPart.class, null);
        EModelServiceFindTest.assertNotNull((Object)elements);
        EModelServiceFindTest.assertEquals((int)1, (int)elements.size());
        EModelServiceFindTest.assertEquals((Object)part, elements.get(0));
    }
}

