/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.SWTRenderersMessages;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabFolder2Adapter;
import org.eclipse.e4.ui.widgets.CTabFolder2Listener;
import org.eclipse.e4.ui.widgets.CTabFolderEvent;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.ElementReferenceRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.LazyStackRenderer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackRenderer
extends LazyStackRenderer {
    public static final String TAG_VIEW_MENU = "ViewMenu";
    private static final String SHELL_CLOSE_EDITORS_MENU = "shell_close_editors_menu";
    private static final String STACK_SELECTED_PART = "stack_selected_part";
    Image viewMenuImage;
    @Inject
    IStylingEngine stylingEngine;
    @Inject
    IEventBroker eventBroker;
    @Inject
    IPresentationEngine renderer;
    private EventHandler itemUpdater;
    private EventHandler dirtyUpdater;
    private boolean ignoreTabSelChanges = false;
    private ActivationJob activationJob = null;

    private synchronized void activateStack(MElementContainer<MUIElement> stack) {
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        if (ctf == null || ctf.isDisposed()) {
            return;
        }
        if (this.activationJob == null) {
            this.activationJob = new ActivationJob();
            this.activationJob.stackToActivate = stack;
            ctf.getDisplay().asyncExec((Runnable)this.activationJob);
        } else {
            this.activationJob.stackToActivate = stack;
        }
    }

    @PostConstruct
    public void init() {
        super.init(this.eventBroker);
        this.itemUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                MUIElement element = (MUIElement)event.getProperty("ChangedElement");
                if (!(element instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)element;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                if (element.getParent() != null && element.getParent().getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                List<MPlaceholder> refs = ElementReferenceRenderer.getRenderedPlaceholders(element);
                if (refs != null) {
                    for (MPlaceholder ref : refs) {
                        CTabItem cti;
                        MElementContainer refParent = ref.getParent();
                        if (refParent == null || !(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.dirtyUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MPart)) {
                    return;
                }
                MPart part = (MPart)objElement;
                String attName = (String)event.getProperty("AttName");
                Object newValue = event.getProperty("NewValue");
                MElementContainer parent = part.getParent();
                if (parent != null && parent.getRenderer() == StackRenderer.this) {
                    CTabItem cti = StackRenderer.this.findItemForPart((MUIElement)part, (MElementContainer<MUIElement>)parent);
                    if (cti != null) {
                        StackRenderer.this.updateTab(cti, part, attName, newValue);
                    }
                    return;
                }
                List<MPlaceholder> refs = ElementReferenceRenderer.getRenderedPlaceholders((MUIElement)part);
                for (MPlaceholder ref : refs) {
                    CTabItem cti;
                    MElementContainer refParent = ref.getParent();
                    if (!(refParent.getRenderer() instanceof StackRenderer) || (cti = StackRenderer.this.findItemForPart((MUIElement)ref, (MElementContainer<MUIElement>)refParent)) == null) continue;
                    StackRenderer.this.updateTab(cti, part, attName, newValue);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/Dirtyable", (String)"dirty"), this.dirtyUpdater);
    }

    protected void updateTab(CTabItem cti, MPart part, String attName, Object newValue) {
        if ("label".equals(attName)) {
            String newName = (String)newValue;
            cti.setText(this.getLabel((MUILabel)part, newName));
        } else if ("iconURI".equals(attName)) {
            cti.setImage(this.getImage((MUILabel)part));
        } else if ("tooltip".equals(attName)) {
            String newTTip = (String)newValue;
            cti.setToolTipText(newTTip);
        } else if ("dirty".equals(attName)) {
            boolean hasAsterisk;
            Boolean dirtyState = (Boolean)newValue;
            String text = cti.getText();
            boolean bl = hasAsterisk = text.charAt(0) == '*';
            if (dirtyState.booleanValue()) {
                if (!hasAsterisk) {
                    cti.setText(String.valueOf('*') + text);
                }
            } else if (hasAsterisk) {
                cti.setText(text.substring(1));
            }
        }
    }

    @PreDestroy
    public void contextDisposed() {
        super.contextDisposed(this.eventBroker);
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.dirtyUpdater);
    }

    private String getLabel(MUILabel itemPart, String newName) {
        if (newName == null) {
            newName = "";
        }
        if (itemPart instanceof MDirtyable && ((MDirtyable)itemPart).isDirty()) {
            newName = String.valueOf('*') + newName;
        }
        return newName;
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MPartStack) || !(parent instanceof Composite)) {
            return null;
        }
        Composite parentComposite = (Composite)parent;
        if (element.getElementId() == null || element.getElementId().length() == 0) {
            String generatedId = "PartStack@" + Integer.toHexString(element.hashCode());
            element.setElementId(generatedId);
        }
        int styleModifier = 0;
        CTabFolder ctf = new CTabFolder(parentComposite, 0x800 | styleModifier);
        this.bindWidget(element, ctf);
        return ctf;
    }

    @Override
    protected void createTab(MElementContainer<MUIElement> stack, MUIElement element) {
        Control ctrl;
        MPart part = null;
        if (element instanceof MPart) {
            part = (MPart)element;
        } else if (element instanceof MPlaceholder) {
            part = (MPart)((MPlaceholder)element).getRef();
            part.setCurSharedRef((MPlaceholder)element);
        }
        CTabFolder ctf = (CTabFolder)stack.getWidget();
        CTabItem cti = this.findItemForPart(element, stack);
        if (cti != null) {
            if (element.getWidget() != null) {
                cti.setControl((Control)element.getWidget());
            }
            return;
        }
        int createFlags = 0;
        if (part != null && this.isClosable(part)) {
            createFlags |= 0x40;
        }
        int index = this.calcIndexFor(stack, element);
        cti = new CTabItem(ctf, createFlags, index);
        cti.setData("modelElement", (Object)element);
        cti.setText(this.getLabel((MUILabel)part, part.getLabel()));
        cti.setImage(this.getImage((MUILabel)part));
        cti.setToolTipText(part.getTooltip());
        if (element.getWidget() != null && (ctrl = (Control)element.getWidget()).getParent() == ctf) {
            cti.setControl((Control)element.getWidget());
        }
    }

    private int calcIndexFor(MElementContainer<MUIElement> stack, MUIElement part) {
        int index = 0;
        for (MUIElement mPart : stack.getChildren()) {
            if (mPart == part) {
                return index;
            }
            if (!mPart.isToBeRendered()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        if (!(parentElement instanceof MPartStack) || !(element instanceof MStackElement)) {
            return;
        }
        this.createTab(parentElement, element);
    }

    private CTabItem findItemForPart(MUIElement element, MElementContainer<MUIElement> stack) {
        CTabFolder ctf;
        if (stack == null) {
            stack = element.getParent();
        }
        if ((ctf = (CTabFolder)stack.getWidget()) == null) {
            return null;
        }
        CTabItem[] items = ctf.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getData("modelElement") == element) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        CTabFolder ctf = (CTabFolder)parentElement.getWidget();
        if (ctf == null) {
            return;
        }
        CTabItem cti = this.findItemForPart(child, parentElement);
        if (cti != null && !cti.isDisposed()) {
            cti.setControl(null);
            cti.dispose();
        }
        if (parentElement.getSelectedElement() == child && ctf.getTopRight() != null) {
            Control curTB = ctf.getTopRight();
            ctf.setTopRight(null);
            if (!curTB.isDisposed()) {
                MUIElement tbME = (MUIElement)curTB.getData("modelElement");
                if (tbME instanceof MRenderedToolBar) {
                    this.renderer.removeGui(tbME);
                } else {
                    curTB.dispose();
                }
            }
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        if (!(me instanceof MElementContainer)) {
            return;
        }
        final MElementContainer stack = (MElementContainer)me;
        final CTabFolder ctf = (CTabFolder)me.getWidget();
        ctf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (StackRenderer.this.ignoreTabSelChanges) {
                    return;
                }
                MUIElement ele = (MUIElement)e.item.getData("modelElement");
                ele.getParent().setSelectedElement(ele);
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CTabItem item;
                if (e.button == 2 && (item = ctf.getItem(new Point(e.x, e.y))) != null) {
                    StackRenderer.this.closePart((Widget)item);
                }
            }
        };
        ctf.addMouseListener((MouseListener)mouseListener);
        CTabFolder2Adapter closeListener = new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = StackRenderer.this.closePart(event.item);
            }
        };
        ctf.addCTabFolder2Listener((CTabFolder2Listener)closeListener);
        ctf.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                CTabFolder ctf = (CTabFolder)event.widget;
                MElementContainer stack = (MElementContainer)ctf.getData("modelElement");
                StackRenderer.this.activateStack((MElementContainer<MUIElement>)stack);
            }
        });
    }

    private boolean closePart(Widget widget) {
        MUIElement uiElement = (MUIElement)widget.getData("modelElement");
        MPart part = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
        IEclipseContext partContext = part.getContext();
        IEclipseContext parentContext = this.getContextForParent((MUIElement)part);
        IEclipseContext context = partContext == null ? parentContext : partContext;
        EPartService partService = (EPartService)context.get(EPartService.class.getName());
        if (partService.savePart(part, true)) {
            partService.hidePart(part);
            return true;
        }
        return false;
    }

    @Override
    protected void showTab(MUIElement element) {
        Control ctrl;
        super.showTab(element);
        final CTabFolder ctf = (CTabFolder)this.getParentWidget(element);
        CTabItem cti = this.findItemForPart(element, null);
        if (cti == null) {
            this.createTab((MElementContainer<MUIElement>)element.getParent(), element);
            cti = this.findItemForPart(element, (MElementContainer<MUIElement>)element.getParent());
        }
        if ((ctrl = (Control)element.getWidget()) != null && ctrl.getParent() != ctf) {
            ctrl.setParent((Composite)ctf);
            cti.setControl(ctrl);
        } else if (element.getWidget() == null) {
            Control tabCtrl = (Control)this.renderer.createGui(element);
            cti.setControl(tabCtrl);
        }
        this.ignoreTabSelChanges = true;
        ctf.setSelection(cti);
        this.ignoreTabSelChanges = false;
        if (ctf.getTopRight() != null) {
            Control curTB = ctf.getTopRight();
            ctf.setTopRight(null);
            if (!curTB.isDisposed()) {
                MUIElement tbME = (MUIElement)curTB.getData("modelElement");
                if (tbME instanceof MRenderedToolBar) {
                    this.renderer.removeGui(tbME);
                } else {
                    curTB.dispose();
                }
            }
        }
        MPart part = (MPart)(element instanceof MPart ? element : ((MPlaceholder)element).getRef());
        MMenu viewMenu = this.getViewMenu(part);
        MToolBar toolbar = part.getToolbar();
        if (toolbar == null && viewMenu != null) {
            toolbar = MenuFactoryImpl.eINSTANCE.createToolBar();
            toolbar.setElementId(part.getElementId());
            part.setToolbar(toolbar);
        }
        if (part.getToolbar() != null) {
            Control c = (Control)this.renderer.createGui((MUIElement)part.getToolbar(), (Object)ctf, part.getContext());
            ctf.setTopRight(c, 131136);
            ctf.layout();
        }
        ctf.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Point absolutePoint = new Point(e.x, e.y);
                Point relativePoint = ctf.getDisplay().map(null, (Control)ctf, absolutePoint);
                CTabItem eventTabItem = ctf.getItem(relativePoint);
                if (eventTabItem != null) {
                    MUIElement uiElement = (MUIElement)eventTabItem.getData("modelElement");
                    MPart tabPart = (MPart)(uiElement instanceof MPart ? uiElement : ((MPlaceholder)uiElement).getRef());
                    StackRenderer.this.openMenuFor(tabPart, ctf, absolutePoint);
                }
            }
        });
    }

    private void openMenuFor(MPart part, CTabFolder folder, Point point) {
        Menu tabMenu = this.createTabMenu(folder, part);
        tabMenu.setData(STACK_SELECTED_PART, (Object)part);
        tabMenu.setLocation(point.x, point.y);
        tabMenu.setVisible(true);
    }

    private boolean isClosable(MPart part) {
        MPart presentationElement = part;
        if (part.getCurSharedRef() != null) {
            presentationElement = part.getCurSharedRef();
        }
        return !presentationElement.getTags().contains("NoClose");
    }

    private Menu createTabMenu(CTabFolder folder, MPart part) {
        MElementContainer<MUIElement> parent;
        Shell shell = folder.getShell();
        Menu cachedMenu = (Menu)shell.getData(SHELL_CLOSE_EDITORS_MENU);
        if (cachedMenu == null) {
            cachedMenu = new Menu((Control)folder);
            shell.setData(SHELL_CLOSE_EDITORS_MENU, (Object)cachedMenu);
        } else {
            MenuItem[] menuItemArray = cachedMenu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
        final Menu menu = cachedMenu;
        if (this.isClosable(part)) {
            MenuItem menuItemClose = new MenuItem(menu, 0);
            menuItemClose.setText(SWTRenderersMessages.menuClose);
            menuItemClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                    EPartService partService = (EPartService)StackRenderer.this.getContextForParent((MUIElement)part).get(EPartService.class);
                    if (partService.savePart(part, true)) {
                        partService.hidePart(part);
                    }
                }
            });
        }
        if ((parent = this.getParent(part)) != null) {
            int count = 0;
            for (MUIElement element : parent.getChildren()) {
                if (!element.isToBeRendered() || ++count != 2) continue;
                MenuItem menuItemOthers = new MenuItem(menu, 0);
                menuItemOthers.setText(SWTRenderersMessages.menuCloseOthers);
                menuItemOthers.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                        StackRenderer.this.closeSiblingParts(part, true);
                    }
                });
                MenuItem menuItemAll = new MenuItem(menu, 0);
                menuItemAll.setText(SWTRenderersMessages.menuCloseAll);
                menuItemAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MPart part = (MPart)menu.getData(StackRenderer.STACK_SELECTED_PART);
                        StackRenderer.this.closeSiblingParts(part, false);
                    }
                });
                break;
            }
        }
        return menu;
    }

    private MElementContainer<MUIElement> getParent(MPart part) {
        MElementContainer parent = part.getParent();
        if (parent == null) {
            MPlaceholder placeholder = part.getCurSharedRef();
            return placeholder == null ? null : placeholder.getParent();
        }
        return parent;
    }

    private void closeSiblingParts(MPart part, boolean skipThisPart) {
        MUIElement selectedElement;
        MElementContainer<MUIElement> container = this.getParent(part);
        if (container == null) {
            return;
        }
        List children = container.getChildren();
        LinkedList<MPart> others = new LinkedList<MPart>();
        for (MUIElement child : children) {
            MUIElement otherItem;
            MPart otherPart = null;
            if (child instanceof MPart) {
                otherPart = (MPart)child;
            } else if (child instanceof MPlaceholder && (otherItem = ((MPlaceholder)child).getRef()) instanceof MPart) {
                otherPart = (MPart)otherItem;
            }
            if (otherPart == null || part.equals(otherPart) || !otherPart.isToBeRendered() || !this.isClosable(otherPart)) continue;
            others.add(otherPart);
        }
        if (!skipThisPart && part.isToBeRendered() && this.isClosable(part)) {
            others.add(part);
        }
        if (others.remove(selectedElement = container.getSelectedElement())) {
            others.add((MPart)selectedElement);
        } else if (selectedElement instanceof MPlaceholder && others.remove(selectedElement = ((MPlaceholder)selectedElement).getRef())) {
            others.add((MPart)selectedElement);
        }
        EPartService partService = (EPartService)this.getContextForParent((MUIElement)part).get(EPartService.class);
        for (MPart otherPart : others) {
            if (!partService.savePart(otherPart, true)) continue;
            partService.hidePart(otherPart);
        }
    }

    private MMenu getViewMenu(MPart part) {
        if (part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains(TAG_VIEW_MENU)) continue;
            return menu;
        }
        return null;
    }

    private class ActivationJob
    implements Runnable {
        public MElementContainer<MUIElement> stackToActivate = null;

        private ActivationJob() {
        }

        public void run() {
            StackRenderer.this.activationJob = null;
            if (this.stackToActivate != null && this.stackToActivate.getSelectedElement() != null) {
                int location = StackRenderer.this.modelService.getElementLocation(this.stackToActivate);
                if ((location & 2) == 0 && (location & 1) == 0 && (location & 8) == 0) {
                    return;
                }
                MUIElement selElement = this.stackToActivate.getSelectedElement();
                if (!selElement.isToBeRendered()) {
                    return;
                }
                if (selElement instanceof MPlaceholder) {
                    selElement = ((MPlaceholder)selElement).getRef();
                }
                StackRenderer.this.activate((MPart)selElement);
            }
        }
    }
}

