/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.selector;

import java.util.Collection;
import java.util.Set;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.platform.discovery.runtime.api.IDisplayableObject;
import org.eclipse.platform.discovery.ui.internal.view.impl.DisplayableObjectLabelProvider;
import org.eclipse.platform.discovery.ui.internal.view.impl.DisplayableObjectsContentProvider;
import org.eclipse.platform.discovery.ui.internal.view.impl.IControlValueSelector;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComboSelector<T extends IDisplayableObject>
implements IControlValueSelector<T, Combo> {
    private final ComboViewer comboViewer;
    private final Label comboLabelControl;

    public ComboSelector(Composite parent, FormToolkit formToolkit, Set<T> input, String comboLabel, int secondColumnPosition, Control offset) {
        FormAttachment topAttachment;
        this.comboLabelControl = new Label(parent, 0x800000);
        FormData comboLabelFormData = new FormData();
        comboLabelFormData.top = topAttachment = offset == null ? new FormAttachment(0, 5) : new FormAttachment(offset, 5);
        comboLabelFormData.left = new FormAttachment(0, 5);
        this.comboLabelControl.setText(comboLabel);
        this.comboLabelControl.setLayoutData((Object)comboLabelFormData);
        this.comboViewer = this.createComboViewer(parent, formToolkit, input);
        FormData comboFormData = new FormData();
        comboFormData.top = topAttachment;
        comboFormData.left = new FormAttachment(0, secondColumnPosition + 10);
        comboFormData.right = new FormAttachment(100, -5);
        this.comboViewer.getControl().setLayoutData((Object)comboFormData);
        this.comboViewer.setInput(input);
    }

    public T getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.comboViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (T)((IDisplayableObject)selection.getFirstElement());
    }

    public void registerSelectionChangedListener(ISelectionChangedListener listener) {
        this.comboViewer.addSelectionChangedListener(listener);
    }

    public void setInput(Collection<T> input) {
        this.comboViewer.setInput(input);
    }

    private ComboViewer createComboViewer(Composite parent, FormToolkit formToolkit, Set<T> input) {
        ComboViewer viewer = new ComboViewer(parent, 12);
        viewer.setLabelProvider(this.comboLabelProvider());
        viewer.setContentProvider((IContentProvider)this.comboContentProvider(input));
        formToolkit.adapt(viewer.getControl(), true, true);
        return viewer;
    }

    protected IStructuredContentProvider comboContentProvider(Set<T> input) {
        return new DisplayableObjectsContentProvider<T>(input);
    }

    protected IBaseLabelProvider comboLabelProvider() {
        return new DisplayableObjectLabelProvider();
    }

    protected ComboViewer getComboViewer() {
        return this.comboViewer;
    }

    public void setEnabled(boolean enabled) {
        this.getComboViewer().getControl().setEnabled(enabled);
        this.comboLabelControl.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.getComboViewer().getControl().isEnabled();
    }

    @Override
    public Combo getControl() {
        return (Combo)this.getComboViewer().getControl();
    }
}

