/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.internal.selector.SubdestinationsSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class SubdestinationsSelectedListener
implements SelectionListener,
Listener {
    private final ISearchProviderConfiguration providerConfiguration;
    private final Control parentControl;

    public SubdestinationsSelectedListener(ISearchProviderConfiguration providerConfiguration, Control parentControl) {
        this.providerConfiguration = providerConfiguration;
        this.parentControl = parentControl;
    }

    protected abstract IObjectTypeDescription objectType();

    protected abstract IDestinationCategoryDescription destinationCategory();

    protected abstract ISearchProviderDescription searchProviderDescription();

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent event) {
        Set subDestinations = this.providerConfiguration.getAvailableSearchSubdestinations(this.objectType(), this.destinationCategory(), this.searchProviderDescription());
        Point showPoint = new Point(event.x, event.y + this.parentControl.getSize().y);
        SubdestinationsSelector selector = new SubdestinationsSelector(this.parentControl, 0, subDestinations, showPoint){

            public void handleSelection(ISearchSubdestination item, boolean selected) {
                if (!selected) {
                    SubdestinationsSelectedListener.this.providerConfiguration.activateSubdestination(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.destinationCategory(), SubdestinationsSelectedListener.this.searchProviderDescription(), item, selected);
                    SubdestinationsSelectedListener.this.handleSubdestActivationChange(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.currentSearchDestination(), item, selected);
                } else {
                    HashSet<ISearchSubdestination> inactive = new HashSet<ISearchSubdestination>();
                    for (ISearchSubdestination curr : SubdestinationsSelectedListener.this.providerConfiguration.getAvailableSearchSubdestinations(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.destinationCategory(), SubdestinationsSelectedListener.this.searchProviderDescription())) {
                        if (this.isSubdestinationActive(curr)) continue;
                        inactive.add(curr);
                    }
                    SubdestinationsSelectedListener.this.providerConfiguration.activateSubdestination(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.destinationCategory(), SubdestinationsSelectedListener.this.searchProviderDescription(), item, selected);
                    HashSet<ISearchSubdestination> deactivated = new HashSet<ISearchSubdestination>();
                    for (ISearchSubdestination curr : SubdestinationsSelectedListener.this.providerConfiguration.getAvailableSearchSubdestinations(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.destinationCategory(), SubdestinationsSelectedListener.this.searchProviderDescription())) {
                        if (this.isSubdestinationActive(curr) || inactive.contains(curr)) continue;
                        deactivated.add(curr);
                    }
                    for (ISearchSubdestination subd : deactivated) {
                        SubdestinationsSelectedListener.this.handleSubdestActivationChange(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.currentSearchDestination(), subd, false);
                    }
                    SubdestinationsSelectedListener.this.handleSubdestActivationChange(SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.currentSearchDestination(), item, selected);
                }
            }

            @Override
            protected boolean isSubdestinationActive(ISearchSubdestination subdestination) {
                return SubdestinationsSelectedListener.this.providerConfiguration.isSubdestinationActive(subdestination, SubdestinationsSelectedListener.this.objectType(), SubdestinationsSelectedListener.this.destinationCategory(), SubdestinationsSelectedListener.this.searchProviderDescription());
            }
        };
        try {
            selector.select();
        }
        finally {
            selector.dispose();
        }
    }

    public void handleEvent(Event event) {
        SelectionEvent selectionEvent = new SelectionEvent(event);
        this.widgetSelected(selectionEvent);
    }

    protected abstract ISearchDestination currentSearchDestination();

    protected abstract void handleSubdestActivationChange(IObjectTypeDescription var1, ISearchDestination var2, ISearchSubdestination var3, boolean var4);
}

