/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchResultCustomUiCreator;
import org.eclipse.platform.discovery.ui.api.impl.ILabeledSelection;
import org.eclipse.platform.discovery.ui.internal.selector.ICustomSearchUiContributorDescription;
import org.eclipse.platform.discovery.ui.internal.view.SearchConsoleView;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.GenericResultUiCreator;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.TabbedSessionDisplayer;
import org.eclipse.platform.discovery.ui.internal.xp.ICustomResultUiXpParser;
import org.eclipse.platform.discovery.ui.internal.xp.impl.CustomResultUiXpParser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ContributedUIFactory
implements TabbedSessionDisplayer.UIFactory<ISearchContext> {
    private final ICustomResultUiXpParser customResultXpParser;
    private final ISelectionChangedListener resultSelChangedListener;
    private final SearchConsoleView sv;

    public ContributedUIFactory(final SearchConsoleView sv) {
        this.sv = sv;
        this.customResultXpParser = this.newCustomResultXpParser();
        this.resultSelChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                sv.setResultSelection((ILabeledSelection)event.getSelection());
            }
        };
    }

    protected ICustomResultUiXpParser newCustomResultXpParser() {
        return new CustomResultUiXpParser(Platform.getExtensionRegistry());
    }

    @Override
    public TabbedSessionDisplayer.UI create(ISearchContext sc, Composite parent) {
        return new ContributedUI(sc, parent);
    }

    @Override
    public FormToolkit getFormTookit() {
        return this.sv.getFormToolkit();
    }

    private Set<ISearchConsoleCustomization> relevantViewCustomizations(Set<IGenericViewCustomization> allCustomizations, String searchProviderId) {
        HashSet<ISearchConsoleCustomization> result = new HashSet<ISearchConsoleCustomization>();
        for (IGenericViewCustomization viewC : allCustomizations) {
            if (!((ISearchConsoleCustomization)viewC).acceptSearchProvider(searchProviderId)) continue;
            result.add((ISearchConsoleCustomization)viewC);
        }
        return result;
    }

    private ICustomSearchUiContributorDescription getUiCreatorContributor(String searchProviderId) {
        HashSet<ICustomSearchUiContributorDescription> contributors = new HashSet<ICustomSearchUiContributorDescription>();
        for (ICustomSearchUiContributorDescription descr : this.customResultXpParser.readContributions()) {
            if (!descr.getSearchProviderId().equals(searchProviderId)) continue;
            contributors.add(descr);
        }
        if (contributors.size() > 1) {
            throw new IllegalStateException("More than one result contribution for search provider " + searchProviderId);
        }
        if (contributors.size() == 1) {
            return (ICustomSearchUiContributorDescription)contributors.iterator().next();
        }
        return null;
    }

    private ISearchResultCustomUiCreator getUiCreator(String searchProviderId) {
        ICustomSearchUiContributorDescription uiContributor = this.getUiCreatorContributor(searchProviderId);
        if (uiContributor != null) {
            return uiContributor.createUiCreator();
        }
        return this.fallbackUiCreator(searchProviderId);
    }

    public ISearchResultCustomUiCreator fallbackUiCreator(String searchProviderId) {
        return new GenericResultUiCreator(searchProviderId, this.sv.getEnvironment());
    }

    private class ContributedUI
    implements TabbedSessionDisplayer.UI {
        private final String restoreDataKey = String.valueOf(ContributedUI.class.getCanonicalName()) + ".restore";
        final ISearchResultCustomUiCreator srcuc;
        final ISearchContext sc;
        final Composite parent;

        public ContributedUI(ISearchContext sc, Composite parent) {
            this.srcuc = ContributedUIFactory.this.getUiCreator(sc.searchProviderId());
            this.sc = sc;
            this.parent = parent;
        }

        @Override
        public void createControls() {
            this.srcuc.createSearchUi(this.parent, this.sc, ContributedUIFactory.this.sv.getFormToolkit(), ContributedUIFactory.this.sv.viewActions(), ContributedUIFactory.this.relevantViewCustomizations(ContributedUIFactory.this.sv.viewCustomizations(), this.sc.searchProviderId()));
            this.srcuc.registerResultSelectionChangedListener(ContributedUIFactory.this.resultSelChangedListener);
        }

        @Override
        public void restoreControlsState() {
            this.srcuc.restore(this.sc.data().get(this.restoreDataKey));
        }

        @Override
        public void saveControlsState() {
            this.sc.data().put(this.restoreDataKey, this.srcuc.restoreData());
        }

        @Override
        public Composite parent() {
            return this.parent;
        }

        @Override
        public void dispose() {
            this.parent.dispose();
        }

        @Override
        public String title() {
            return this.sc.title();
        }
    }
}

