/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.xp.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.impl.XpParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.xp.IGenericXpParser;
import org.eclipse.platform.discovery.ui.api.ISearchResultCustomUiCreator;
import org.eclipse.platform.discovery.ui.internal.selector.ICustomSearchUiContributorDescription;
import org.eclipse.platform.discovery.ui.internal.xp.ICustomResultUiXpParser;

public class CustomResultUiXpParser
implements ICustomResultUiXpParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.ui.customresultui";
    private static final String XP_ELEMENT_NAME = "contributor";
    private static final String ID_ATTR_NAME = "id";
    private static final String SEARCH_PROVIDER_ID_ATTR_NAME = "searchproviderid";
    private static final String UI_CREATOR_CLASS_NAME_ATTR_NAME = "creator";
    private final IExtensionRegistry extRegistry;

    public CustomResultUiXpParser(IExtensionRegistry extRegistry) {
        this.extRegistry = extRegistry;
    }

    protected IGenericXpParser genericXpParser() {
        return new XpParsersFactory().createGenericXpParser();
    }

    public Set<ICustomSearchUiContributorDescription> readContributions() {
        HashSet<ICustomSearchUiContributorDescription> result = new HashSet<ICustomSearchUiContributorDescription>();
        for (IConfigurationElement configElement : this.genericXpParser().getConfigurationElements(this.extRegistry, XP_ID, XP_ELEMENT_NAME)) {
            result.add(this.createContributorDescription(configElement));
        }
        return result;
    }

    private ICustomSearchUiContributorDescription createContributorDescription(final IConfigurationElement configElement) {
        return new ICustomSearchUiContributorDescription(){

            @Override
            public ISearchResultCustomUiCreator createUiCreator() {
                try {
                    return (ISearchResultCustomUiCreator)configElement.createExecutableExtension(CustomResultUiXpParser.UI_CREATOR_CLASS_NAME_ATTR_NAME);
                }
                catch (CoreException e) {
                    throw new IllegalStateException("UI creator could not be created", e);
                }
            }

            @Override
            public String getId() {
                return configElement.getAttribute(CustomResultUiXpParser.ID_ATTR_NAME);
            }

            @Override
            public String getSearchProviderId() {
                return configElement.getAttribute(CustomResultUiXpParser.SEARCH_PROVIDER_ID_ATTR_NAME);
            }
        };
    }
}

