/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.xp.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.impl.XpParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.xp.IGenericXpParser;
import org.eclipse.platform.discovery.ui.api.ICustomSearchParamsUiContributor;
import org.eclipse.platform.discovery.ui.internal.search.customparams.ICustomSearchParamsUiContributorDescr;
import org.eclipse.platform.discovery.ui.internal.xp.ICustomSearchParamsUiContribXpParser;

public class CustomSearchParamsUiContribXpParser
implements ICustomSearchParamsUiContribXpParser {
    private final IExtensionRegistry extensionRegistry;
    private static final String XP_ID = "org.eclipse.platform.discovery.integration.customsearchparams";
    private static final String XP_ELEMENT_NAME = "customsearchparams";
    private static final String ID_ATTR_NAME = "id";
    private static final String SEARCH_PROVIDER_ID_ATTR_NAME = "searchproviderid";
    private static final String CONTRIBUTOR_CLASS_NAME_ATTR_NAME = "uicontributorclass";

    public CustomSearchParamsUiContribXpParser(IExtensionRegistry extRegistry) {
        this.extensionRegistry = extRegistry;
    }

    public Set<ICustomSearchParamsUiContributorDescr> readContributions() {
        HashSet<ICustomSearchParamsUiContributorDescr> result = new HashSet<ICustomSearchParamsUiContributorDescr>();
        for (final IConfigurationElement configElement : this.configurationElements()) {
            result.add(new ICustomSearchParamsUiContributorDescr(){

                @Override
                public ICustomSearchParamsUiContributor createContributor() {
                    try {
                        return (ICustomSearchParamsUiContributor)configElement.createExecutableExtension(CustomSearchParamsUiContribXpParser.CONTRIBUTOR_CLASS_NAME_ATTR_NAME);
                    }
                    catch (CoreException e) {
                        throw new IllegalStateException(e);
                    }
                }

                @Override
                public String getId() {
                    return configElement.getAttribute(CustomSearchParamsUiContribXpParser.ID_ATTR_NAME);
                }

                @Override
                public String getSearchProviderId() {
                    return configElement.getAttribute(CustomSearchParamsUiContribXpParser.SEARCH_PROVIDER_ID_ATTR_NAME);
                }
            });
        }
        return result;
    }

    private List<IConfigurationElement> configurationElements() {
        return this.genericXpParser().getConfigurationElements(this.extensionRegistry, XP_ID, XP_ELEMENT_NAME);
    }

    protected IGenericXpParser genericXpParser() {
        return new XpParsersFactory().createGenericXpParser();
    }
}

