/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.tools.emf.ui.common.EStackLayout;
import org.eclipse.e4.tools.emf.ui.common.IContributionClassCreator;
import org.eclipse.e4.tools.emf.ui.common.IEditorDescriptor;
import org.eclipse.e4.tools.emf.ui.common.IEditorFeature;
import org.eclipse.e4.tools.emf.ui.common.IExtensionLookup;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.common.ISelectionProviderService;
import org.eclipse.e4.tools.emf.ui.common.MemoryTransfer;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.ShadowComposite;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AddonsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ApplicationEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.AreaEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingContextEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.BindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CategoryEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CommandParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.CoreExpressionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.DirectToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledMenuItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandledToolItemEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.HandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.InputPartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.KeyBindingEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.MenuSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ParameterEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartDescriptorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartSashContainerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PartStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PerspectiveStackEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PlaceholderEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.PopupMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.RenderedMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.RenderedMenuItem;
import org.eclipse.e4.tools.emf.ui.internal.common.component.RenderedToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.StringModelFragment;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolBarSeparatorEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ToolControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimBarEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimContributionEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.TrimmedWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.WindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationAddons;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VApplicationCategoriesEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VBindingTableEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VCommandEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VHandlerEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VItemParametersEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VMenuContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VMenuEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelFragmentsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VModelImportsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VPartDescriptor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VRootBindingContexts;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VToolBarContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VTrimContributionsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowControlEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowSharedElementsEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.component.virtual.VWindowTrimEditor;
import org.eclipse.e4.tools.services.IClipboardService;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedPackageImpl;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.e4.ui.model.internal.ModelUtils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.IEMFProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelEditor {
    private static final String CSS_CLASS_KEY = "org.eclipse.e4.ui.css.CssClassName";
    public static final String VIRTUAL_PART_MENU = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PART_MENU";
    public static final String VIRTUAL_HANDLER = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_HANDLER";
    public static final String VIRTUAL_BINDING_TABLE = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_BINDING_TABLE";
    public static final String VIRTUAL_COMMAND = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_COMMAND";
    public static final String VIRTUAL_WINDOWS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOWS";
    public static final String VIRTUAL_WINDOW_CONTROLS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_CONTROLS";
    public static final String VIRTUAL_PART_DESCRIPTORS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PART_DESCRIPTORS";
    public static final String VIRTUAL_PARTDESCRIPTOR_MENU = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PARTDESCRIPTOR_MENU";
    public static final String VIRTUAL_TRIMMED_WINDOW_TRIMS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TRIMMED_WINDOW_TRIMS";
    public static final String VIRTUAL_ADDONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_ADDONS";
    public static final String VIRTUAL_MENU_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MENU_CONTRIBUTIONS";
    public static final String VIRTUAL_TOOLBAR_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TOOLBAR_CONTRIBUTIONS";
    public static final String VIRTUAL_TRIM_CONTRIBUTIONS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_TRIM_CONTRIBUTIONS";
    public static final String VIRTUAL_WINDOW_SHARED_ELEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_WINDOW_SHARED_ELEMENTS";
    public static final String VIRTUAL_MODEL_FRAGEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MODEL_FRAGEMENTS";
    public static final String VIRTUAL_MODEL_IMPORTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MODEL_IMPORTS";
    public static final String VIRTUAL_CATEGORIES = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_CATEGORIES";
    public static final String VIRTUAL_PARAMETERS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_PARAMETERS";
    public static final String VIRTUAL_MENUELEMENTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_MENUELEMENTS";
    public static final String VIRTUAL_ROOT_CONTEXTS = String.valueOf(ModelEditor.class.getName()) + ".VIRTUAL_ROOT_CONTEXTS";
    private Map<EClass, AbstractComponentEditor> editorMap = new HashMap<EClass, AbstractComponentEditor>();
    private Map<String, AbstractComponentEditor> virtualEditors = new HashMap<String, AbstractComponentEditor>();
    private List<FeaturePath> labelFeaturePaths = new ArrayList<FeaturePath>();
    private List<IEditorFeature> editorFeatures = new ArrayList<IEditorFeature>();
    private List<IContributionClassCreator> contributionCreator = new ArrayList<IContributionClassCreator>();
    private TreeViewer viewer;
    private IModelResource modelProvider;
    private IProject project;
    private ISelectionProviderService selectionService;
    private IEclipseContext context;
    private boolean fragment;
    private IClipboardService.Handler clipboardHandler;
    @Inject
    @Optional
    private IClipboardService clipboardService;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="autoCreateElementId")
    private boolean autoCreateElementId;
    @Inject
    @Preference(nodePath="org.eclipse.e4.tools.emf.ui", value="showXMIId")
    private boolean showXMIId;
    @Inject
    @Optional
    private IExtensionLookup extensionLookup;
    private ObservablesManager obsManager;
    private final IResourcePool resourcePool;

    public ModelEditor(Composite composite, IEclipseContext context, IModelResource modelProvider, IProject project, final IResourcePool resourcePool) {
        this.resourcePool = resourcePool;
        this.modelProvider = modelProvider;
        this.project = project;
        this.context = context;
        this.context.set(ModelEditor.class, (Object)this);
        this.obsManager = new ObservablesManager();
        this.registerDefaultEditors();
        this.registerVirtualEditors();
        this.registerContributedEditors();
        this.registerContributedVirtualEditors();
        this.loadEditorFeatures();
        this.loadContributionCreators();
        this.fragment = modelProvider.getRoot().get(0) instanceof MModelFragments;
        SashForm form = new SashForm(composite, 256);
        form.setBackground(form.getDisplay().getSystemColor(1));
        this.viewer = this.createTreeViewerArea((Composite)form);
        Composite parent = new Composite((Composite)form, 0);
        parent.setBackground(parent.getDisplay().getSystemColor(1));
        parent.setBackgroundMode(1);
        FillLayout l = new FillLayout();
        l.marginWidth = 5;
        parent.setLayout((Layout)l);
        ShadowComposite editingArea = new ShadowComposite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginTop = 0;
        gl.marginHeight = 0;
        editingArea.setLayout((Layout)gl);
        editingArea.setBackgroundMode(1);
        Composite headerContainer = new Composite((Composite)editingArea, 0);
        headerContainer.setBackgroundMode(1);
        headerContainer.setData(CSS_CLASS_KEY, (Object)"headerSectionContainer");
        headerContainer.setLayout((Layout)new GridLayout(3, false));
        headerContainer.setLayoutData((Object)new GridData(768));
        final Label iconLabel = new Label(headerContainer, 0);
        iconLabel.setLayoutData((Object)new GridData(20, 20));
        final Label textLabel = new Label(headerContainer, 0);
        textLabel.setData(CSS_CLASS_KEY, (Object)"sectionHeader");
        textLabel.setLayoutData((Object)new GridData(768));
        final ScrolledComposite scrolling = new ScrolledComposite((Composite)editingArea, 768);
        scrolling.setBackgroundMode(1);
        scrolling.setData(CSS_CLASS_KEY, (Object)"formContainer");
        final EStackLayout layout = new EStackLayout();
        final Composite contentContainer = new Composite((Composite)scrolling, 0);
        contentContainer.setData(CSS_CLASS_KEY, (Object)"formContainer");
        scrolling.setExpandHorizontal(true);
        scrolling.setExpandVertical(true);
        scrolling.setContent((Control)contentContainer);
        scrolling.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolling.getClientArea();
                scrolling.setMinSize(contentContainer.computeSize(r.width, -1));
            }
        });
        scrolling.setLayoutData((Object)new GridData(1808));
        contentContainer.setLayout((Layout)layout);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    final IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    if (s.getFirstElement() instanceof EObject) {
                        EObject obj = (EObject)s.getFirstElement();
                        final AbstractComponentEditor editor = ModelEditor.this.getEditor(obj.eClass());
                        if (editor != null) {
                            textLabel.setText(editor.getLabel(obj));
                            iconLabel.setImage(editor.getImage(obj, iconLabel.getDisplay()));
                            ModelEditor.this.obsManager.runAndCollect(new Runnable(){

                                public void run() {
                                    Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                                    comp.setBackgroundMode(1);
                                    layout.topControl = comp;
                                    contentContainer.layout(true);
                                }
                            });
                        }
                    } else {
                        VirtualEntry entry = (VirtualEntry)s.getFirstElement();
                        final AbstractComponentEditor editor = (AbstractComponentEditor)ModelEditor.this.virtualEditors.get(entry.getId());
                        if (editor != null) {
                            textLabel.setText(editor.getLabel(entry));
                            iconLabel.setImage(editor.getImage(entry, iconLabel.getDisplay()));
                            ModelEditor.this.obsManager.runAndCollect(new Runnable(){

                                public void run() {
                                    Composite comp = editor.getEditor(contentContainer, s.getFirstElement());
                                    comp.setBackgroundMode(1);
                                    layout.topControl = comp;
                                    contentContainer.layout(true);
                                }
                            });
                        }
                    }
                    Rectangle r = scrolling.getClientArea();
                    scrolling.setMinSize(contentContainer.computeSize(r.width, -1));
                    scrolling.setOrigin(0, 0);
                    scrolling.layout(true, true);
                    if (ModelEditor.this.selectionService != null) {
                        ModelEditor.this.selectionService.setSelection(s.getFirstElement());
                    }
                }
            }
        });
        form.setWeights(new int[]{1, 2});
        MenuManager mgr = new MenuManager();
        mgr.setRemoveAllWhenShown(true);
        mgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection s = (IStructuredSelection)ModelEditor.this.viewer.getSelection();
                if (!s.isEmpty()) {
                    List<Action> actions;
                    if (s.getFirstElement() instanceof VirtualEntry) {
                        actions = ((AbstractComponentEditor)ModelEditor.this.virtualEditors.get(((VirtualEntry)s.getFirstElement()).getId())).getActions(s.getFirstElement());
                    } else {
                        final EObject o = (EObject)s.getFirstElement();
                        AbstractComponentEditor editor = ModelEditor.this.getEditor(o.eClass());
                        actions = editor != null ? new ArrayList<Action>(editor.getActions(s.getFirstElement())) : new ArrayList<Action>();
                        if (o.eContainer() != null) {
                            actions.add(new Action(Messages.ModelEditor_Delete, ImageDescriptor.createFromImage((Image)resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.obj16.cross"))){

                                public void run() {
                                    if (o.eContainingFeature().isMany()) {
                                        Command cmd = RemoveCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)o.eContainer(), (Object)o.eContainingFeature(), (Object)o);
                                        if (cmd.canExecute()) {
                                            ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                                        }
                                    } else {
                                        Command cmd = SetCommand.create((EditingDomain)ModelEditor.this.modelProvider.getEditingDomain(), (Object)o.eContainer(), (Object)o.eContainingFeature(), null);
                                        if (cmd.canExecute()) {
                                            ModelEditor.this.modelProvider.getEditingDomain().getCommandStack().execute(cmd);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    for (Action a : actions) {
                        manager.add((IAction)a);
                    }
                }
            }
        });
        this.viewer.getControl().setMenu(mgr.createContextMenu(this.viewer.getControl()));
    }

    @PostConstruct
    void postCreate() {
        this.viewer.setSelection((ISelection)new StructuredSelection((List)this.modelProvider.getRoot()));
    }

    public IExtensionLookup getExtensionLookup() {
        return this.extensionLookup;
    }

    public boolean isAutoCreateElementId() {
        return this.autoCreateElementId && this.project != null;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isShowXMIId() {
        return this.showXMIId;
    }

    private void loadContributionCreators() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("contributionClassCreator".equals(el.getName())) {
                try {
                    this.contributionCreator.add((IContributionClassCreator)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public IContributionClassCreator getContributionCreator(EClass eClass) {
        for (IContributionClassCreator c : this.contributionCreator) {
            if (!c.isSupported(eClass)) continue;
            return c;
        }
        return null;
    }

    private void loadEditorFeatures() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editorfeature".equals(el.getName())) {
                try {
                    this.editorFeatures.add((IEditorFeature)el.createExecutableExtension("class"));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public boolean isModelFragment() {
        return this.fragment;
    }

    public boolean isLiveModel() {
        return !this.modelProvider.isSaveable();
    }

    public List<IEditorFeature.FeatureClass> getFeatureClasses(EClass eClass, EStructuralFeature feature) {
        ArrayList<IEditorFeature.FeatureClass> list = new ArrayList<IEditorFeature.FeatureClass>();
        for (IEditorFeature f : this.editorFeatures) {
            list.addAll(f.getFeatureClasses(eClass, feature));
        }
        return list;
    }

    @Inject
    public void setSelectionService(@Optional ISelectionProviderService selectionService) {
        this.selectionService = selectionService;
        if (this.viewer != null && !this.viewer.getControl().isDisposed() && !this.viewer.getSelection().isEmpty() && selectionService != null) {
            selectionService.setSelection(((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
        }
    }

    private TreeViewer createTreeViewerArea(Composite parent) {
        parent = new Composite(parent, 0);
        parent.setData(CSS_CLASS_KEY, (Object)"formContainer");
        parent.setBackgroundMode(1);
        FillLayout l = new FillLayout();
        l.marginWidth = 5;
        parent.setLayout((Layout)l);
        ShadowComposite editingArea = new ShadowComposite(parent, 0);
        editingArea.setLayout((Layout)new FillLayout());
        final TreeViewer viewer = new TreeViewer((Composite)editingArea, 66304);
        viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this));
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider((IObservableFactory)new ObservableFactoryImpl(), (TreeStructureAdvisor)new TreeStructureAdvisorImpl());
        viewer.setContentProvider((IContentProvider)contentProvider);
        final WritableSet clearedSet = new WritableSet();
        contentProvider.getKnownElements().addSetChangeListener(new ISetChangeListener(){

            public void handleSetChange(SetChangeEvent event) {
                for (Object o : event.diff.getAdditions()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.add(o);
                }
                for (Object o : event.diff.getRemovals()) {
                    if (!(o instanceof EObject)) continue;
                    clearedSet.remove(o);
                }
            }
        });
        for (FeaturePath p : this.labelFeaturePaths) {
            IObservableMap map = EMFProperties.value((FeaturePath)p).observeDetail((IObservableSet)clearedSet);
            map.addMapChangeListener(new IMapChangeListener(){

                public void handleMapChange(MapChangeEvent event) {
                    viewer.update(event.diff.getChangedKeys().toArray(), null);
                }
            });
        }
        viewer.setInput((Object)this.modelProvider.getRoot());
        viewer.expandToLevel(2);
        int ops = 2;
        viewer.addDragSupport(ops, new Transfer[]{MemoryTransfer.getInstance()}, (DragSourceListener)new DragListener(viewer));
        viewer.addDropSupport(ops, new Transfer[]{MemoryTransfer.getInstance()}, (DropTargetListener)new DropListener((Viewer)viewer, this.modelProvider.getEditingDomain()));
        return viewer;
    }

    private void registerContributedVirtualEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("virtualeditor".equals(el.getName())) {
                IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("platform:/plugin/" + el.getContributor().getName() + "/" + el.getAttribute("class"), this.context);
                this.registerVirtualEditor(el.getAttribute("id"), editor);
            }
            ++n2;
        }
    }

    private void registerVirtualEditors() {
        this.registerVirtualEditor(VIRTUAL_PART_MENU, new VMenuEditor(this.modelProvider.getEditingDomain(), this, (EStructuralFeature)BasicPackageImpl.Literals.PART__MENUS, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_HANDLER, new VHandlerEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_BINDING_TABLE, new VBindingTableEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_COMMAND, new VCommandEditor(this.modelProvider.getEditingDomain(), this, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION__COMMANDS, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_WINDOWS, new VWindowEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_WINDOW_CONTROLS, new VWindowControlEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_PART_DESCRIPTORS, new VPartDescriptor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_PARTDESCRIPTOR_MENU, new VMenuEditor(this.modelProvider.getEditingDomain(), this, (EStructuralFeature)BasicPackageImpl.Literals.PART_DESCRIPTOR__MENUS, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_TRIMMED_WINDOW_TRIMS, new VWindowTrimEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_ADDONS, new VApplicationAddons(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_MENU_CONTRIBUTIONS, new VMenuContributionsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_TOOLBAR_CONTRIBUTIONS, new VToolBarContributionsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_TRIM_CONTRIBUTIONS, new VTrimContributionsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_WINDOW_SHARED_ELEMENTS, new VWindowSharedElementsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_MODEL_FRAGEMENTS, new VModelFragmentsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_MODEL_IMPORTS, new VModelImportsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_CATEGORIES, new VApplicationCategoriesEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_PARAMETERS, new VItemParametersEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerVirtualEditor(VIRTUAL_ROOT_CONTEXTS, new VRootBindingContexts(this.modelProvider.getEditingDomain(), this, this.resourcePool));
    }

    private void registerVirtualEditor(String id, AbstractComponentEditor editor) {
        this.virtualEditors.put(id, editor);
    }

    public void setSelection(Object element) {
        this.viewer.setSelection((ISelection)new StructuredSelection(element));
    }

    private void registerContributedEditors() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.e4.tools.emf.ui.editors");
        IConfigurationElement[] iConfigurationElementArray = extPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("editor".equals(el.getName())) {
                try {
                    IEditorDescriptor desc = (IEditorDescriptor)el.createExecutableExtension("descriptorClass");
                    EClass eClass = desc.getEClass();
                    IContributionFactory fact = (IContributionFactory)this.context.get(IContributionFactory.class);
                    AbstractComponentEditor editor = (AbstractComponentEditor)fact.create("platform:/plugin/" + el.getContributor().getName() + "/" + desc.getEditorClass().getName(), this.context);
                    this.registerEditor(eClass, editor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void registerDefaultEditors() {
        this.registerEditor(ApplicationPackageImpl.Literals.APPLICATION, new ApplicationEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(ApplicationPackageImpl.Literals.ADDON, new AddonsEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.KEY_BINDING, new KeyBindingEditor(this.modelProvider.getEditingDomain(), this, this.modelProvider, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.HANDLER, new HandlerEditor(this.modelProvider.getEditingDomain(), this, this.modelProvider, this.project, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND, new CommandEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.COMMAND_PARAMETER, new CommandParameterEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.PARAMETER, new ParameterEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_TABLE, new BindingTableEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.BINDING_CONTEXT, new BindingContextEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(CommandsPackageImpl.Literals.CATEGORY, new CategoryEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR, new ToolBarEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.RENDERED_TOOL_BAR, new RenderedToolBarEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_TOOL_ITEM, new DirectToolItemEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_TOOL_ITEM, new HandledToolItemEditor(this.modelProvider.getEditingDomain(), this, this.project, this.modelProvider, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_SEPARATOR, new ToolBarSeparatorEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_CONTROL, new ToolControlEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.MENU, new MenuEditor(this.modelProvider.getEditingDomain(), this.project, this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.RENDERED_MENU, new RenderedMenuEditor(this.modelProvider.getEditingDomain(), this.project, this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.POPUP_MENU, new PopupMenuEditor(this.modelProvider.getEditingDomain(), this.project, this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.MENU_SEPARATOR, new MenuSeparatorEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.HANDLED_MENU_ITEM, new HandledMenuItemEditor(this.modelProvider.getEditingDomain(), this, this.project, this.modelProvider, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.DIRECT_MENU_ITEM, new DirectMenuItemEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.RENDERED_MENU_ITEM, new RenderedMenuItem(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.MENU_CONTRIBUTION, new MenuContributionEditor(this.modelProvider.getEditingDomain(), this.project, this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.TOOL_BAR_CONTRIBUTION, new ToolBarContributionEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(MenuPackageImpl.Literals.TRIM_CONTRIBUTION, new TrimContributionEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(UiPackageImpl.Literals.CORE_EXPRESSION, new CoreExpressionEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.PART, new PartEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.WINDOW, new WindowEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.TRIMMED_WINDOW, new TrimmedWindowEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.PART_SASH_CONTAINER, new PartSashContainerEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(AdvancedPackageImpl.Literals.AREA, new AreaEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.PART_STACK, new PartStackEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.INPUT_PART, new InputPartEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.TRIM_BAR, new TrimBarEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(BasicPackageImpl.Literals.PART_DESCRIPTOR, new PartDescriptorEditor(this.modelProvider.getEditingDomain(), this, this.project, this.resourcePool));
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE_STACK, new PerspectiveStackEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(AdvancedPackageImpl.Literals.PERSPECTIVE, new PerspectiveEditor(this.modelProvider.getEditingDomain(), this.project, this, this.resourcePool));
        this.registerEditor(AdvancedPackageImpl.Literals.PLACEHOLDER, new PlaceholderEditor(this.modelProvider.getEditingDomain(), this, this.modelProvider, this.resourcePool));
        this.registerEditor(FragmentPackageImpl.Literals.MODEL_FRAGMENTS, new ModelFragmentsEditor(this.modelProvider.getEditingDomain(), this, this.resourcePool));
        this.registerEditor(FragmentPackageImpl.Literals.STRING_MODEL_FRAGMENT, new StringModelFragment(this.modelProvider.getEditingDomain(), this, this.resourcePool));
    }

    public void registerEditor(EClass eClass, AbstractComponentEditor editor) {
        this.editorMap.put(eClass, editor);
        FeaturePath[] featurePathArray = editor.getLabelProperties();
        int n = featurePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            FeaturePath p = featurePathArray[n2];
            boolean found = false;
            for (FeaturePath tmp : this.labelFeaturePaths) {
                if (!this.equalsPaths(p, tmp)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.labelFeaturePaths.add(p);
            }
            ++n2;
        }
    }

    private boolean equalsPaths(FeaturePath p1, FeaturePath p2) {
        if (p1.getFeaturePath().length == p2.getFeaturePath().length) {
            int i = 0;
            while (i < p1.getFeaturePath().length) {
                if (!p1.getFeaturePath()[i].equals(p2.getFeaturePath()[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public AbstractComponentEditor getEditor(EClass eClass) {
        AbstractComponentEditor editor = this.editorMap.get(eClass);
        if (editor == null) {
            for (EClass cl : eClass.getESuperTypes()) {
                editor = this.getEditor(cl);
                if (editor == null) continue;
                return editor;
            }
        }
        return editor;
    }

    @Persist
    public void doSave(@Optional IProgressMonitor monitor) {
        if (this.modelProvider.isSaveable()) {
            this.modelProvider.save();
        }
    }

    @Focus
    public void setFocus() {
        if (this.clipboardHandler == null) {
            this.clipboardHandler = new ClipboardHandler();
        }
        if (this.clipboardService != null) {
            this.clipboardService.setHandler(this.clipboardHandler);
        }
        this.viewer.getControl().setFocus();
    }

    @PreDestroy
    void dispose() {
        try {
            this.obsManager.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IModelResource getModelProvider() {
        return this.modelProvider;
    }

    class ClipboardHandler
    implements IClipboardService.Handler {
        ClipboardHandler() {
        }

        public void paste() {
            Command cmd;
            Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
            Object o = clip.getContents((Transfer)MemoryTransfer.getInstance());
            clip.dispose();
            if (o == null) {
                return;
            }
            Object parent = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            EReference feature = null;
            EObject container = null;
            if (parent instanceof VirtualEntry) {
                VirtualEntry v = (VirtualEntry)parent;
                feature = ((IEMFProperty)v.getProperty()).getStructuralFeature();
                container = (EObject)v.getOriginalParent();
            } else if (parent instanceof MElementContainer) {
                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                container = (EObject)parent;
            } else if (parent instanceof EObject) {
                container = (EObject)parent;
                EClass eClass = container.eClass();
                for (EStructuralFeature f : eClass.getEAllStructuralFeatures()) {
                    if (!ModelUtils.getTypeArgument((EClass)eClass, (EGenericType)f.getEGenericType()).isInstance(o)) continue;
                    feature = f;
                    break;
                }
            }
            if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && container != null) {
                MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)o).eClass());
                el.setElementId(((MApplicationElement)o).getElementId());
                Command cmd2 = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)el);
                if (cmd2.canExecute()) {
                    ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd2);
                }
                return;
            }
            if (feature != null && container != null && (cmd = AddCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)container, (Object)feature, (Object)o)).canExecute()) {
                ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
                if (ModelEditor.this.isLiveModel() && container instanceof MElementContainer && o instanceof MUIElement) {
                    ((MElementContainer)container).setSelectedElement((MUIElement)o);
                }
            }
        }

        public void copy() {
            Object o = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            if (o != null && o instanceof EObject) {
                Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
                clip.setContents(new Object[]{EcoreUtil.copy((EObject)((EObject)o))}, new Transfer[]{MemoryTransfer.getInstance()});
                clip.dispose();
            }
        }

        public void cut() {
            Object o = ((IStructuredSelection)ModelEditor.this.viewer.getSelection()).getFirstElement();
            if (o != null && o instanceof EObject) {
                Clipboard clip = new Clipboard(ModelEditor.this.viewer.getControl().getDisplay());
                clip.setContents(new Object[]{o}, new Transfer[]{MemoryTransfer.getInstance()});
                clip.dispose();
                EObject eObj = (EObject)o;
                Command cmd = RemoveCommand.create((EditingDomain)ModelEditor.this.getModelProvider().getEditingDomain(), (Object)eObj.eContainer(), (Object)eObj.eContainingFeature(), (Object)eObj);
                if (cmd.canExecute()) {
                    ModelEditor.this.getModelProvider().getEditingDomain().getCommandStack().execute(cmd);
                }
            }
        }
    }

    static class DragListener
    extends DragSourceAdapter {
        private final TreeViewer viewer;

        public DragListener(TreeViewer viewer) {
            this.viewer = viewer;
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof MApplicationElement;
        }

        public void dragSetData(DragSourceEvent event) {
            Object o;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            event.data = o = selection.getFirstElement();
        }
    }

    class DropListener
    extends ViewerDropAdapter {
        private EditingDomain domain;

        protected DropListener(Viewer viewer, EditingDomain domain) {
            super(viewer);
            this.domain = domain;
        }

        public boolean performDrop(Object data) {
            block28: {
                block24: {
                    Command cmd;
                    EObject parent;
                    EReference feature;
                    block26: {
                        block27: {
                            block25: {
                                if (this.getCurrentLocation() != 3) break block24;
                                feature = null;
                                parent = null;
                                if (!(this.getCurrentTarget() instanceof MElementContainer)) break block25;
                                feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                                parent = (EObject)this.getCurrentTarget();
                                break block26;
                            }
                            if (!(this.getCurrentTarget() instanceof VirtualEntry)) break block27;
                            VirtualEntry entry = (VirtualEntry)this.getCurrentTarget();
                            IListProperty prop = entry.getProperty();
                            if (!(prop instanceof IEMFProperty)) break block26;
                            feature = ((IEMFProperty)prop).getStructuralFeature();
                            parent = (EObject)entry.getOriginalParent();
                            break block26;
                        }
                        if (this.getCurrentTarget() instanceof EObject) {
                            parent = (EObject)this.getCurrentTarget();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature != null && parent != null && (cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data)).canExecute()) {
                        this.domain.getCommandStack().execute(cmd);
                        if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                            ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                        }
                    }
                    break block28;
                }
                if (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) {
                    EReference feature = null;
                    EObject parent = null;
                    TreeItem item = (TreeItem)this.getCurrentEvent().item;
                    if (item != null) {
                        TreeItem parentItem = item.getParentItem();
                        if (parentItem.getData() instanceof VirtualEntry) {
                            VirtualEntry vE = (VirtualEntry)parentItem.getData();
                            parent = (EObject)vE.getOriginalParent();
                            feature = ((IEMFProperty)vE.getProperty()).getStructuralFeature();
                        } else if (parentItem.getData() instanceof MElementContainer) {
                            parent = (EObject)parentItem.getData();
                            feature = UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN;
                        } else if (parentItem.getData() instanceof EObject) {
                            parent = (EObject)parentItem.getData();
                            for (EStructuralFeature f : parent.eClass().getEAllStructuralFeatures()) {
                                EClassifier cl = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)f.getEGenericType());
                                if (!cl.isInstance(data)) continue;
                                feature = f;
                                break;
                            }
                        }
                    }
                    if (feature == FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS && parent != null) {
                        MApplicationElement el = (MApplicationElement)EcoreUtil.create((EClass)((EObject)data).eClass());
                        el.setElementId(((MApplicationElement)data).getElementId());
                        Command cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)el);
                        if (cmd.canExecute()) {
                            this.domain.getCommandStack().execute(cmd);
                        }
                        return true;
                    }
                    if (feature != null && parent != null && parent.eGet(feature) instanceof List) {
                        Command cmd;
                        List list = (List)parent.eGet(feature);
                        int index = list.indexOf(this.getCurrentTarget());
                        if (index >= list.size()) {
                            index = -1;
                        }
                        if (parent == ((EObject)data).eContainer()) {
                            if (parent instanceof MElementContainer && data instanceof MUIElement) {
                                Util.moveElementByIndex(this.domain, (MUIElement)data, ModelEditor.this.isLiveModel(), index);
                            } else {
                                cmd = MoveCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index);
                                if (cmd.canExecute()) {
                                    this.domain.getCommandStack().execute(cmd);
                                    return true;
                                }
                            }
                        } else {
                            if (parent.eResource() != ((EObject)data).eResource()) {
                                data = EcoreUtil.copy((EObject)((EObject)data));
                            }
                            if ((cmd = AddCommand.create((EditingDomain)this.domain, (Object)parent, (Object)feature, (Object)data, (int)index)).canExecute()) {
                                this.domain.getCommandStack().execute(cmd);
                                if (ModelEditor.this.isLiveModel() && parent instanceof MElementContainer && data instanceof MUIElement) {
                                    ((MElementContainer)parent).setSelectedElement((MUIElement)data);
                                }
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            boolean rv = false;
            if (this.getSelectedObject() instanceof MApplicationElement) {
                TreeItem item;
                if (this.getCurrentLocation() == 3) {
                    rv = this.isValidDrop(target, (MApplicationElement)this.getSelectedObject(), false);
                } else if ((this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1) && (item = (TreeItem)this.getCurrentEvent().item) != null && (item = item.getParentItem()) != null) {
                    rv = this.isValidDrop(item.getData(), (MApplicationElement)this.getSelectedObject(), true);
                }
            }
            return rv;
        }

        private boolean isValidDrop(Object target, MApplicationElement instance, boolean isIndex) {
            if (target instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)target;
                if (isIndex || !container.getChildren().contains(instance)) {
                    EClassifier classifier = ModelUtils.getTypeArgument((EClass)((EObject)container).eClass(), (EGenericType)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN.getEGenericType());
                    return classifier.isInstance((Object)instance);
                }
            } else if (target instanceof VirtualEntry) {
                VirtualEntry vTarget = (VirtualEntry)target;
                if ((isIndex || !vTarget.getList().contains((Object)instance)) && vTarget.getProperty() instanceof IEMFProperty) {
                    EStructuralFeature feature = ((IEMFProperty)vTarget.getProperty()).getStructuralFeature();
                    EObject parent = (EObject)vTarget.getOriginalParent();
                    EClassifier classifier = ModelUtils.getTypeArgument((EClass)parent.eClass(), (EGenericType)feature.getEGenericType());
                    return classifier.isInstance((Object)instance);
                }
            } else if (target instanceof EObject) {
                EObject eObj = (EObject)target;
                for (EStructuralFeature f : eObj.eClass().getEAllStructuralFeatures()) {
                    EClassifier cl = ModelUtils.getTypeArgument((EClass)eObj.eClass(), (EGenericType)f.getEGenericType());
                    if (!cl.isInstance((Object)instance)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class ObservableFactoryImpl
    implements IObservableFactory {
        ObservableFactoryImpl() {
        }

        public IObservable createObservable(Object target) {
            if (target instanceof IObservableList) {
                return (IObservable)target;
            }
            if (target instanceof VirtualEntry) {
                return ((VirtualEntry)target).getList();
            }
            AbstractComponentEditor editor = ModelEditor.this.getEditor(((EObject)target).eClass());
            if (editor != null) {
                return editor.getChildList(target);
            }
            return null;
        }
    }

    static class TreeStructureAdvisorImpl
    extends TreeStructureAdvisor {
        TreeStructureAdvisorImpl() {
        }
    }
}

