/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class HandledContributionItem
extends ContributionItem {
    private MHandledItem model;
    private Widget widget;
    private Listener menuItemListener;
    private LocalResourceManager localResourceManager;
    @Inject
    private ECommandService commandService;
    @Inject
    private EModelService modelService;
    @Inject
    private EBindingService bindingService;
    private ISWTResourceUtilities resUtils = null;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            HandledContributionItem.this.update(null);
        }
    };

    @Inject
    void setResourceUtils(IResourceUtilities utils) {
        this.resUtils = (ISWTResourceUtilities)utils;
    }

    public void setModel(MHandledItem item) {
        this.model = item;
        this.setId(this.model.getElementId());
        this.generateCommand();
        this.updateVisible();
    }

    private void generateCommand() {
        if (this.model.getCommand() == null) {
            return;
        }
        if (this.model.getWbCommand() == null) {
            String cmdId = this.model.getCommand().getElementId();
            List modelParms = this.model.getParameters();
            if (modelParms.isEmpty()) {
                ParameterizedCommand parmCmd = this.commandService.createCommand(cmdId, null);
                Activator.trace((String)"/trace/menus", (String)("command: " + parmCmd), null);
                this.model.setWbCommand(parmCmd);
                return;
            }
            HashMap<String, String> parms = new HashMap<String, String>();
            for (MParameter parm : modelParms) {
                parms.put(parm.getName(), parm.getValue());
            }
            ParameterizedCommand parmCmd = this.commandService.createCommand(cmdId, parms);
            Activator.trace((String)"/trace/menus", (String)("command: " + parmCmd), null);
            this.model.setWbCommand(parmCmd);
        }
    }

    public void fill(Menu menu, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        if (this.model.getType() == ItemType.PUSH) {
            style = 8;
        } else if (this.model.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.model.getType() == ItemType.RADIO) {
            style = 16;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(menu, style, index) : new MenuItem(menu, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        this.widget = item;
        this.model.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.model);
        this.update(null);
        this.updateIcons();
    }

    public void fill(ToolBar parent, int index) {
        if (this.model == null) {
            return;
        }
        if (this.widget != null) {
            return;
        }
        int style = 8;
        if (this.model.getType() == ItemType.PUSH) {
            style = 8;
        } else if (this.model.getType() == ItemType.CHECK) {
            style = 32;
        } else if (this.model.getType() == ItemType.RADIO) {
            style = 16;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, style, index) : new ToolItem(parent, style);
        item.setData((Object)this);
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        item.addListener(14, this.getItemListener());
        this.widget = item;
        this.model.setWidget((Object)this.widget);
        this.widget.setData("modelElement", (Object)this.model);
        this.update(null);
        this.updateIcons();
    }

    private void updateVisible() {
        this.setVisible(this.model.isVisible());
        IContributionManager parent = this.getParent();
        if (parent != null) {
            parent.markDirty();
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        if (this.widget instanceof MenuItem) {
            this.updateMenuItem();
        } else if (this.widget instanceof ToolItem) {
            this.updateToolItem();
        }
    }

    private void updateMenuItem() {
        MenuItem item = (MenuItem)this.widget;
        String text = this.model.getLocalizedLabel();
        ParameterizedCommand parmCmd = this.model.getWbCommand();
        String keyBindingText = null;
        if (parmCmd != null) {
            TriggerSequence binding;
            if (text == null) {
                try {
                    text = parmCmd.getName();
                }
                catch (NotDefinedException notDefinedException) {}
            }
            if (this.bindingService != null && (binding = this.bindingService.getBestSequenceFor(parmCmd)) != null) {
                keyBindingText = binding.format();
            }
        }
        if (text != null) {
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(String.valueOf(text) + '\t' + keyBindingText);
            }
        } else {
            item.setText("");
        }
        item.setSelection(this.model.isSelected());
        item.setEnabled(this.model.isEnabled());
    }

    private void updateToolItem() {
        ToolItem item = (ToolItem)this.widget;
        String text = this.model.getLocalizedLabel();
        if (text != null) {
            item.setText(text);
        } else {
            item.setText("");
        }
        String tooltip = this.model.getLocalizedTooltip();
        item.setToolTipText(tooltip);
        item.setSelection(this.model.isSelected());
        item.setEnabled(this.model.isEnabled());
    }

    private void updateIcons() {
        if (this.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            String iconURI = this.model.getIconURI();
            ImageDescriptor icon = this.getImageDescriptor((MUILabel)this.model);
            try {
                item.setImage(icon == null ? null : m.createImage(icon));
            }
            catch (DeviceResourceException e) {
                icon = ImageDescriptor.getMissingImageDescriptor();
                item.setImage(m.createImage(icon));
                Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
            }
            this.disposeOldImages();
            this.localResourceManager = m;
        } else if (this.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            String iconURI = this.model.getIconURI();
            ImageDescriptor icon = this.getImageDescriptor((MUILabel)this.model);
            try {
                item.setImage(icon == null ? null : m.createImage(icon));
            }
            catch (DeviceResourceException e) {
                icon = ImageDescriptor.getMissingImageDescriptor();
                item.setImage(m.createImage(icon));
                Activator.trace((String)"/trace/menus", (String)("failed to create image " + iconURI), (Throwable)e);
            }
            this.disposeOldImages();
            this.localResourceManager = m;
        }
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            HandledContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: 
                        case 14: {
                            if (event.widget == null) break;
                            HandledContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget.removeListener(14, this.getItemListener());
            this.widget = null;
            this.model.setWidget(null);
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
            this.model.setWidget(null);
        }
    }

    private void handleWidgetSelection(Event event) {
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.model.getType() == ItemType.CHECK || this.model.getType() == ItemType.RADIO) {
                boolean selection = false;
                if (this.widget instanceof MenuItem) {
                    selection = ((MenuItem)this.widget).getSelection();
                } else if (this.widget instanceof ToolItem) {
                    selection = ((ToolItem)this.widget).getSelection();
                }
                this.model.setSelected(selection);
            }
            if (this.canExecuteItem()) {
                this.executeItem();
            }
        }
    }

    private void executeItem() {
        ParameterizedCommand cmd = this.model.getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)this.model);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
        lclContext.set(MItem.class.getName(), (Object)this.model);
        service.executeHandler(cmd);
        lclContext.remove(MItem.class.getName());
    }

    private boolean canExecuteItem() {
        ParameterizedCommand cmd = this.model.getWbCommand();
        if (cmd == null) {
            return false;
        }
        IEclipseContext lclContext = this.getContext((MUIElement)this.model);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        return service.canExecute(cmd);
    }

    public void setParent(IContributionManager parent) {
        IMenuManager menuMgr;
        if (this.getParent() instanceof IMenuManager) {
            menuMgr = (IMenuManager)this.getParent();
            menuMgr.removeMenuListener(this.menuListener);
        }
        if (parent instanceof IMenuManager) {
            menuMgr = (IMenuManager)parent;
            menuMgr.addMenuListener(this.menuListener);
        }
        super.setParent(parent);
    }

    private ImageDescriptor getImageDescriptor(MUILabel element) {
        String iconURI = element.getIconURI();
        if (iconURI != null && iconURI.length() > 0) {
            return (ImageDescriptor)this.resUtils.imageDescriptorFromURI(URI.createURI((String)iconURI));
        }
        return null;
    }

    protected IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    protected IEclipseContext getContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    public Widget getWidget() {
        return this.widget;
    }
}

