/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.DirectContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.HandledContributionItem;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolControlContribution;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarManagerRenderer
extends SWTPartRenderer {
    private Map<MToolBar, ToolBarManager> modelToManager = new HashMap<MToolBar, ToolBarManager>();
    private Map<ToolBarManager, MToolBar> managerToModel = new HashMap<ToolBarManager, MToolBar>();
    private Map<MToolBarElement, IContributionItem> modelToContribution = new HashMap<MToolBarElement, IContributionItem>();
    private ArrayList<ContributionRecord> contributionRecords = new ArrayList();
    @Inject
    IPresentationEngine renderer;
    @Inject
    private MApplication application;
    @Inject
    private EModelService modelService;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
            if (ici == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                ici.update();
            } else if ("iconURI".equals(attName)) {
                ici.update();
            } else if ("tooltip".equals(attName)) {
                ici.update();
            }
        }
    };
    private EventHandler toBeRenderedUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            String attName = (String)event.getProperty("AttName");
            if ("toBeRendered".equals(attName)) {
                MElementContainer obj = itemModel.getParent();
                if (!(obj instanceof MToolBar)) {
                    return;
                }
                ToolBarManager parent = ToolBarManagerRenderer.this.getManager((MToolBar)obj);
                if (itemModel.isToBeRendered()) {
                    if (parent != null) {
                        ToolBarManagerRenderer.this.modelProcessSwitch(parent, itemModel);
                        parent.update(true);
                        ToolBar tb = parent.getControl();
                        if (tb != null && !tb.isDisposed()) {
                            tb.getShell().layout(new Control[]{tb}, 4);
                        }
                    }
                } else {
                    IContributionItem ici = (IContributionItem)ToolBarManagerRenderer.this.modelToContribution.remove(itemModel);
                    if (ici != null && parent != null) {
                        parent.remove(ici);
                    }
                    if (ici != null) {
                        ici.dispose();
                    }
                }
            } else if ("visible".equals(attName)) {
                IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
                if (ici == null) {
                    return;
                }
                ici.setVisible(itemModel.isVisible());
                ToolBarManager parent = (ToolBarManager)((ContributionItem)ici).getParent();
                if (parent != null) {
                    parent.markDirty();
                    ToolBar tb = parent.getControl();
                    if (tb != null && !tb.isDisposed()) {
                        tb.getShell().layout(new Control[]{tb}, 4);
                    }
                }
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private EventHandler enabledUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolBarElement)) {
                return;
            }
            MToolBarElement itemModel = (MToolBarElement)event.getProperty("ChangedElement");
            IContributionItem ici = ToolBarManagerRenderer.this.getContribution(itemModel);
            if (ici != null) {
                ici.update();
            }
        }
    };
    private Image viewMenuImage;

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"selected"), this.selectionUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"enabled"), this.enabledUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
        this.eventBroker.unsubscribe(this.enabledUpdater);
        this.eventBroker.unsubscribe(this.toBeRenderedUpdater);
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        Composite intermediate = new Composite((Composite)parent, 0);
        this.createToolbar(element, intermediate);
        this.processContribution((MToolBar)element);
        return intermediate;
    }

    private void processContribution(MToolBar toolbarModel) {
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        ContributionsAnalyzer.XXXgatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)toolbarModel.getElementId(), toContribute);
        this.generateContributions(toolbarModel, toContribute);
    }

    private void generateContributions(MToolBar toolbarModel, ArrayList<MToolBarContribution> toContribute) {
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MToolBarElement child : toolbarModel.getChildren()) {
            String elementId = child.getElementId();
            if (!(child instanceof MToolBarSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        ToolBarManager manager = this.getManager(toolbarModel);
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MToolBarContribution> curList = new ArrayList<MToolBarContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (MToolBarContribution contribution : curList) {
                if (this.processAddition(toolbarModel, manager, contribution, existingSeparatorNames)) continue;
                toContribute.add(contribution);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    private boolean processAddition(MToolBar toolbarModel, final ToolBarManager manager, MToolBarContribution contribution, HashSet<String> existingSeparatorNames) {
        int idx = ToolBarManagerRenderer.getIndex(toolbarModel, contribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        final ContributionRecord record = new ContributionRecord(toolbarModel, contribution, manager);
        this.contributionRecords.add(record);
        record.generate();
        for (MToolBarElement copy : record.generatedElements) {
            if (copy instanceof MToolBarSeparator && existingSeparatorNames.contains(copy.getElementId())) continue;
            toolbarModel.getChildren().add(idx++, copy);
            if (!(copy instanceof MToolBarSeparator) || copy.getElementId() == null) continue;
            existingSeparatorNames.add(copy.getElementId());
        }
        if (contribution.getVisibleWhen() != null) {
            final IEclipseContext parentContext = this.modelService.getContainingContext((MUIElement)toolbarModel);
            parentContext.runAndTrack(new RunAndTrack(){

                public boolean changed(IEclipseContext context) {
                    record.updateVisibility(parentContext.getActiveLeaf());
                    manager.update(false);
                    return true;
                }
            });
        }
        return true;
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }

    private ToolBar createToolbar(final MUIElement element, Composite intermediate) {
        int orientation = this.getOrientation(element);
        RowLayout layout = RowLayoutFactory.fillDefaults().wrap(false).spacing(0).type(orientation).create();
        layout.marginLeft = 3;
        layout.center = true;
        intermediate.setLayout((Layout)layout);
        ToolBar separatorToolBar = new ToolBar(intermediate, orientation | 0x40 | 0x800000 | 0x20000);
        new ToolItem(separatorToolBar, 2);
        ToolBarManager manager = this.getManager((MToolBar)element);
        if (manager == null) {
            manager = new ToolBarManager(orientation | 0x40 | 0x800000 | 0x20000);
            this.linkModelToManager((MToolBar)element, manager);
        }
        ToolBar bar = manager.createControl(intermediate);
        bar.setData((Object)manager);
        bar.getShell().layout(new Control[]{bar}, 4);
        bar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolBarManagerRenderer.this.cleanUp((MToolBar)element);
            }
        });
        return bar;
    }

    protected void cleanUp(MToolBar toolbarModel) {
        ContributionRecord[] contributionRecordArray = this.contributionRecords.toArray(new ContributionRecord[this.contributionRecords.size()]);
        int n = contributionRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ContributionRecord record = contributionRecordArray[n2];
            if (record.toolbarModel == toolbarModel) {
                record.dispose();
                this.contributionRecords.remove(record);
                for (MToolBarElement copy : record.generatedElements) {
                    IContributionItem ici = this.modelToContribution.remove(copy);
                    if (ici == null) continue;
                    record.manager.remove(ici);
                }
                record.generatedElements.clear();
            }
            ++n2;
        }
    }

    int getOrientation(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        if (container == null) {
            return;
        }
        MElementContainer<MUIElement> obj = container;
        ToolBarManager parentManager = this.getManager((MToolBar)obj);
        if (parentManager == null) {
            return;
        }
        List parts = container.getChildren();
        if (parts != null) {
            MUIElement[] plist = parts.toArray(new MUIElement[parts.size()]);
            int i = 0;
            while (i < plist.length) {
                MUIElement childME = plist[i];
                this.modelProcessSwitch(parentManager, (MToolBarElement)childME);
                ++i;
            }
        }
        parentManager.update(false);
        ToolBar tb = this.getToolbarFrom(container.getWidget());
        if (tb != null && ((EObject)container).eContainer() instanceof MPart) {
            MPart part = (MPart)((EObject)container).eContainer();
            MMenu viewMenu = this.getViewMenu(part);
            if (viewMenu != null) {
                this.addMenuButton(part, tb, viewMenu);
            }
            tb.getShell().layout(new Control[]{tb}, 4);
        }
    }

    private ToolBar getToolbarFrom(Object widget) {
        Control[] children;
        int length;
        Composite intermediate;
        if (widget instanceof ToolBar) {
            return (ToolBar)widget;
        }
        if (widget instanceof Composite && !(intermediate = (Composite)widget).isDisposed() && (length = (children = intermediate.getChildren()).length) > 0 && children[length - 1] instanceof ToolBar) {
            return (ToolBar)children[length - 1];
        }
        return null;
    }

    private void addMenuButton(MPart part, ToolBar tb, MMenu menu) {
        ToolItem ti = new ToolItem(tb, 8);
        ti.setImage(this.getViewMenuImage());
        ti.setHotImage(null);
        ti.setToolTipText("View Menu");
        ti.setData("theMenu", (Object)menu);
        ti.setData("thePart", (Object)part);
        ti.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ToolBarManagerRenderer.this.showMenu((ToolItem)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ToolBarManagerRenderer.this.showMenu((ToolItem)e.widget);
            }
        });
    }

    protected void showMenu(ToolItem item) {
        MMenu menuModel = (MMenu)item.getData("theMenu");
        MPart part = (MPart)item.getData("thePart");
        Control ctrl = (Control)part.getWidget();
        Menu menu = (Menu)this.renderer.createGui((MUIElement)menuModel, (Object)ctrl.getShell(), part.getContext());
        Rectangle ib = item.getBounds();
        Point displayAt = item.getParent().toDisplay(ib.x, ib.y + ib.height);
        menu.setLocation(displayAt);
        menu.setVisible(true);
        Display display = Display.getCurrent();
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    private Image getViewMenuImage() {
        if (this.viewMenuImage == null) {
            Display d = Display.getCurrent();
            Image viewMenu = new Image((Device)d, 16, 16);
            Image viewMenuMask = new Image((Device)d, 16, 16);
            Display display = Display.getCurrent();
            GC gc = new GC((Drawable)viewMenu);
            GC maskgc = new GC((Drawable)viewMenuMask);
            gc.setForeground(display.getSystemColor(17));
            gc.setBackground(display.getSystemColor(25));
            int[] shapeArray = new int[]{6, 1, 15, 1, 11, 5, 10, 5};
            gc.fillPolygon(shapeArray);
            gc.drawPolygon(shapeArray);
            Color black = display.getSystemColor(2);
            Color white = display.getSystemColor(1);
            maskgc.setBackground(black);
            maskgc.fillRectangle(0, 0, 16, 16);
            maskgc.setBackground(white);
            maskgc.setForeground(white);
            maskgc.fillPolygon(shapeArray);
            maskgc.drawPolygon(shapeArray);
            gc.dispose();
            maskgc.dispose();
            ImageData data = viewMenu.getImageData();
            data.transparentPixel = data.getPixel(0, 0);
            this.viewMenuImage = new Image((Device)d, viewMenu.getImageData(), viewMenuMask.getImageData());
            viewMenu.dispose();
            viewMenuMask.dispose();
        }
        return this.viewMenuImage;
    }

    private MMenu getViewMenu(MPart part) {
        if (part.getMenus() == null) {
            return null;
        }
        for (MMenu menu : part.getMenus()) {
            if (!menu.getTags().contains("ViewMenu")) continue;
            return menu;
        }
        return null;
    }

    boolean hasOnlySeparators(ToolBar toolbar) {
        ToolItem[] children;
        ToolItem[] toolItemArray = children = toolbar.getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if ((toolItem.getStyle() & 2) == 0) {
                return false;
            }
            if (toolItem.getControl() != null && toolItem.getControl().getData("modelElement") instanceof MToolControl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void postProcess(MUIElement element) {
        super.postProcess(element);
        ToolBar tb = this.getToolbarFrom(element.getWidget());
        if (tb != null && !tb.isDisposed()) {
            tb.getShell().layout(new Control[]{tb}, 4);
            tb.setVisible(true);
        }
    }

    public Object getUIContainer(MUIElement childElement) {
        if (childElement.getWidget() instanceof ToolBar) {
            return childElement.getWidget();
        }
        Object obj = super.getUIContainer(childElement);
        if (obj instanceof ToolBar) {
            return obj;
        }
        if (obj instanceof Composite) {
            Composite intermediate = (Composite)obj;
            if (intermediate == null || intermediate.isDisposed()) {
                return null;
            }
            ToolBar toolbar = this.getToolbarFrom(intermediate);
            if (toolbar == null) {
                toolbar = this.createToolbar((MUIElement)childElement.getParent(), intermediate);
            }
            return toolbar;
        }
        return null;
    }

    @Override
    public void disposeWidget(MUIElement element) {
        ToolBar tb = this.getToolbarFrom(element.getWidget());
        tb.setVisible(false);
        this.unbindWidget(element);
        tb.setData("modelElement", (Object)element);
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        ToolBar toolbar;
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
        if ((toolbar = (ToolBar)this.getUIContainer(child)) != null && !toolbar.isDisposed()) {
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        ToolBar toolbar = (ToolBar)this.getUIContainer(element);
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
    }

    private void modelProcessSwitch(ToolBarManager parentManager, MToolBarElement childME) {
        if (childME instanceof MHandledToolItem) {
            MHandledToolItem itemModel = (MHandledToolItem)childME;
            this.processHandledItem(parentManager, itemModel);
        } else if (childME instanceof MDirectToolItem) {
            MDirectToolItem itemModel = (MDirectToolItem)childME;
            this.processDirectItem(parentManager, itemModel);
        } else if (childME instanceof MToolBarSeparator) {
            MToolBarSeparator itemModel = (MToolBarSeparator)childME;
            this.processSeparator(parentManager, itemModel);
        } else if (childME instanceof MToolControl) {
            MToolControl itemModel = (MToolControl)childME;
            this.processToolControl(parentManager, itemModel);
        }
    }

    private void processSeparator(ToolBarManager parentManager, MToolBarSeparator itemModel) {
        Separator marker = null;
        if (itemModel.isVisible()) {
            marker = new Separator();
            marker.setId(itemModel.getElementId());
        } else if (itemModel.getElementId() != null) {
            marker = new GroupMarker(itemModel.getElementId());
        }
        parentManager.add((IContributionItem)marker);
    }

    private void processToolControl(ToolBarManager parentManager, MToolControl itemModel) {
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        ToolControlContribution ci = (ToolControlContribution)((Object)ContextInjectionFactory.make(ToolControlContribution.class, (IEclipseContext)lclContext));
        ci.setModel(itemModel);
        parentManager.add((IContributionItem)ci);
        this.modelToContribution.put((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void processDirectItem(ToolBarManager parentManager, MDirectToolItem itemModel) {
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        DirectContributionItem ci = (DirectContributionItem)((Object)ContextInjectionFactory.make(DirectContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MItem)itemModel);
        parentManager.add((IContributionItem)ci);
        this.modelToContribution.put((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    private void processHandledItem(ToolBarManager parentManager, MHandledToolItem itemModel) {
        IEclipseContext lclContext = this.getContext((MUIElement)itemModel);
        HandledContributionItem ci = (HandledContributionItem)((Object)ContextInjectionFactory.make(HandledContributionItem.class, (IEclipseContext)lclContext));
        ci.setModel((MHandledItem)itemModel);
        parentManager.add((IContributionItem)ci);
        this.modelToContribution.put((MToolBarElement)itemModel, (IContributionItem)ci);
    }

    public ToolBarManager getManager(MToolBar model) {
        return this.modelToManager.get(model);
    }

    public MToolBar getToolBarModel(ToolBarManager manager) {
        return this.managerToModel.get(manager);
    }

    public void linkModelToManager(MToolBar model, ToolBarManager manager) {
        this.modelToManager.put(model, manager);
        this.managerToModel.put(manager, model);
    }

    public void clearModelToManager(MToolBar model, ToolBarManager manager) {
        this.modelToManager.remove(model);
        this.managerToModel.remove(manager);
    }

    public IContributionItem getContribution(MToolBarElement element) {
        return this.modelToContribution.get(element);
    }

    static class ContributionRecord {
        MToolBar toolbarModel;
        MToolBarContribution contribution;
        ToolBarManager manager;
        ArrayList<MToolBarElement> generatedElements = new ArrayList();

        public ContributionRecord(MToolBar toolbarModel, MToolBarContribution contribution, ToolBarManager manager) {
            this.toolbarModel = toolbarModel;
            this.contribution = contribution;
            this.manager = manager;
        }

        public void generate() {
            for (MToolBarElement element : this.contribution.getChildren()) {
                MToolBarElement copy = (MToolBarElement)EcoreUtil.copy((EObject)((EObject)element));
                this.generatedElements.add(copy);
            }
        }

        public void updateVisibility(IEclipseContext context) {
            ExpressionContext exprContext = new ExpressionContext(context);
            boolean isVisible = ContributionsAnalyzer.isVisible((MToolBarContribution)this.contribution, (ExpressionContext)exprContext);
            for (MToolBarElement item : this.generatedElements) {
                item.setVisible(isVisible);
            }
            this.manager.markDirty();
        }

        public void dispose() {
            for (MToolBarElement copy : this.generatedElements) {
                this.toolbarModel.getChildren().remove(copy);
            }
        }
    }
}

