/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.translation.TranslationService;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.internal.ModelUtils;

public final class LocalizationHelper {
    private LocalizationHelper() {
    }

    public static String getLocalizedLabel(MUIElement element) {
        if (!(element instanceof MUILabel)) {
            return null;
        }
        String key = ((MUILabel)((Object)element)).getLabel();
        if (key == null) {
            return null;
        }
        return LocalizationHelper.getLocalized(key, element);
    }

    public static String getLocalizedTooltip(MUIElement element) {
        if (!(element instanceof MUILabel)) {
            return null;
        }
        String key = ((MUILabel)((Object)element)).getTooltip();
        if (key == null) {
            return null;
        }
        return LocalizationHelper.getLocalized(key, element);
    }

    public static String getLocalized(String key, MUIElement element) {
        IEclipseContext context = ModelUtils.getContainingContext(element);
        if (context == null) {
            return null;
        }
        return LocalizationHelper.getLocalized(key, element, context);
    }

    public static String getLocalized(String key, MApplicationElement element, IEclipseContext context) {
        TranslationService translation = (TranslationService)context.get(TranslationService.class);
        if (translation == null) {
            return key;
        }
        return translation.translate(key, element.getContributorURI());
    }
}

