/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.demo.e4photo.Exif;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Location {
    private Browser browser;
    private Composite browserParent;
    private Exif exif;

    @Inject
    public Location(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        parent.setData("org.eclipse.e4.ui.css.id", (Object)"location");
        this.browserParent = parent;
    }

    @Focus
    void setFocus() {
        this.browserParent.setFocus();
    }

    @Inject
    @Optional
    public void setInput(@UIEventTopic(value="org/eclipse/e4/demo/e4photo/exif") Exif input) {
        if (input == null || this.exif == input) {
            return;
        }
        this.exif = input;
        if (this.exif == null || this.exif.getGpsLatitude() == null) {
            if (this.browser != null) {
                this.browser.dispose();
                this.browser = null;
            }
        } else {
            if (this.browser == null) {
                this.browser = new Browser(this.browserParent, 0);
                this.browserParent.layout();
            }
            this.browser.setUrl("http://maps.google.com/maps?q=" + this.exif.getGpsLatitude() + "+" + this.exif.getGpsLongitude());
        }
    }
}

