/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.longop;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.platform.discovery.util.api.longop.ILongOperation;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.longop.LongOpCanceledException;

public class SchedulingRuleSynchRunner
implements ILongOperationRunner {
    private final ILongOperationRunner wrappedRunner;
    private final ISchedulingRule rule;
    private final IJobManager jm;

    public SchedulingRuleSynchRunner(ILongOperationRunner wrapped, ISchedulingRule rule, IJobManager jobManager) {
        this.wrappedRunner = wrapped;
        this.rule = rule;
        this.jm = jobManager;
    }

    protected IJobManager jobManager() {
        return this.jm;
    }

    @Override
    public <T> T run(ILongOperation<T> op) throws LongOpCanceledException, InvocationTargetException {
        return this.wrappedRunner.run(new RuleSynchronizingDecorator<T>(op));
    }

    private class RuleSynchronizingDecorator<T>
    implements ILongOperation<T> {
        private final ILongOperation<T> wrappedOp;

        public RuleSynchronizingDecorator(ILongOperation<T> op) {
            this.wrappedOp = op;
        }

        @Override
        public T run(IProgressMonitor monitor) throws LongOpCanceledException, Exception {
            SchedulingRuleSynchRunner.this.jobManager().beginRule(SchedulingRuleSynchRunner.this.rule, monitor);
            try {
                T t = this.wrappedOp.run(monitor);
                return t;
            }
            finally {
                SchedulingRuleSynchRunner.this.jobManager().endRule(SchedulingRuleSynchRunner.this.rule);
            }
        }
    }
}

