/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderBase;
import org.eclipse.core.resources.semantic.test.provider.CachingTestContentProvider;
import org.eclipse.core.resources.semantic.test.provider.CachingTestContentProviderBase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.junit.Test;

public class TestsCachingProvider
extends TestsContentProviderBase {
    private RemoteFile file1;

    public void afterMethod() throws Exception {
        super.afterMethod();
        this.file1 = null;
    }

    public void beforeMethod() throws Exception {
        super.beforeMethod();
        RemoteStoreTransient store = (RemoteStoreTransient)this.testProject.getAdapter(RemoteStoreTransient.class);
        this.file1 = (RemoteFile)store.getItemByPath((IPath)new Path("Folder1/File1"));
    }

    public RemoteFile getRemoteFile() {
        return this.file1;
    }

    public TestsCachingProvider() {
        super(false, "CachingTests", CachingTestContentProvider.class.getName());
    }

    @Test
    public void testAddFileFromRemoteDeleteAndAddAgain() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        Assert.assertEquals((String)"Folder existence", (boolean)false, (boolean)parent.exists());
        final IFile file = parent.getFile("File1");
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sfile = sfr.addFile("File1", TestsCachingProvider.this.options, monitor);
                Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                file.getParent().refreshLocal(2, monitor);
                InputStream is = null;
                try {
                    is = sfile.getAdaptedFile().getContents();
                    try {
                        Assert.assertTrue((String)"Too few bytes available", (is.available() > 0 ? 1 : 0) != 0);
                    }
                    catch (IOException e) {
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
        Assert.assertEquals((String)"Folder existence", (boolean)true, (boolean)parent.exists());
        InputStream is = file.getContents();
        try {
            runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                    ISemanticFile sFile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    try {
                        sFile.remove(TestsCachingProvider.this.options, monitor);
                        sfr.getAdaptedResource().refreshLocal(1, monitor);
                    }
                    catch (CoreException coreException) {
                        Assert.fail((String)"Remove failure");
                    }
                }
            };
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
            Assert.assertEquals((String)"File exsistence", (boolean)false, (boolean)file.exists());
            runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                    ISemanticFile sfile = sfr.addFile("File1", TestsCachingProvider.this.options, monitor);
                    Assert.assertTrue((boolean)sfile.getAdaptedFile().equals((Object)file));
                    file.getParent().refreshLocal(2, monitor);
                    InputStream is1 = null;
                    try {
                        is1 = sfile.getAdaptedFile().getContents();
                        try {
                            Assert.assertTrue((String)"Too few bytes available", (is1.available() > 0 ? 1 : 0) != 0);
                        }
                        catch (IOException e) {
                            Assert.fail((String)e.getMessage());
                        }
                    }
                    finally {
                        Util.safeClose((InputStream)is1);
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Assert.fail((String)"Should not fail");
            }
        }
        finally {
            Util.safeClose((InputStream)is);
        }
        Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
    }

    @Test
    public void testWriteThrough() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sfr.addFile("File1", 0, monitor);
                Assert.assertEquals((String)"File existence", (boolean)true, (boolean)file.exists());
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "Hello");
        Assert.assertEquals((String)"Wrong remote content", (String)"Hello", (String)new String(this.file1.getContent(), "UTF-8"));
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    IStatus stat = sf.validateEdit(null);
                    Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)stat.isOK());
                    file.setContents((InputStream)new ByteArrayInputStream("NewString".getBytes("UTF-8")), 2, monitor);
                }
                catch (UnsupportedEncodingException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "NewString");
        Assert.assertEquals((String)"Wrong remote content", (String)"Hello", (String)new String(this.file1.getContent(), "UTF-8"));
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    sf.setSessionProperty(CachingTestContentProviderBase.WRITE_THROUGH, (Object)"");
                    IStatus stat = sf.validateEdit(null);
                    Assert.assertTrue((String)"ValidateEdit should have returned OK", (boolean)stat.isOK());
                    file.setContents((InputStream)new ByteArrayInputStream("ThirdString".getBytes("UTF-8")), 2, monitor);
                    sf.setSessionProperty(CachingTestContentProviderBase.WRITE_THROUGH, null);
                }
                catch (UnsupportedEncodingException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        this.assertContentsEqual(file, "ThirdString");
        Assert.assertEquals((String)"Wrong remote content", (String)"ThirdString", (String)new String(this.file1.getContent(), "UTF-8"));
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(0, null);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
    }

    @Test
    public void testLocalFileSupport() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                ISemanticFile sFile = sfr.addFile("File1", 0, monitor);
                File localFile = EFS.getStore((URI)sFile.getAdaptedFile().getLocationURI()).toLocalFile(4096, monitor);
                Assert.assertNotNull((String)"Cached Local File should not be null", (Object)localFile);
                Assert.assertTrue((String)"Cached file should be in Eclipse file cache", (boolean)localFile.getPath().contains("org.eclipse.core.filesystem"));
                localFile = EFS.getStore((URI)sFile.getAdaptedFile().getLocationURI()).toLocalFile(0, monitor);
                Assert.assertNotNull((String)"Uncached Local File should not be null", (Object)localFile);
                Assert.assertTrue((String)"Uncached file should be in SFS cache", (boolean)localFile.getPath().contains("org.eclipse.core.resources.semantic"));
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFile sf = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                sf.remove(0, null);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"File existence", (boolean)false, (boolean)file.exists());
    }

    @Test
    public void testParallelReadAndWrite() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        final IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        Assert.assertFalse((String)"File should not exist", (boolean)file.exists());
        Object runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sfr = (ISemanticFolder)parent.getAdapter(ISemanticFolder.class);
                sfr.addFile("File1", 0, monitor);
                try {
                    Util.transferStreams((InputStream)new ByteArrayInputStream("New Remote".getBytes("UTF-8")), (OutputStream)TestsCachingProvider.this.file1.getOutputStream(false), (IProgressMonitor)monitor);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                InputStream is = null;
                try {
                    is = file.getContents();
                    TestsCachingProvider.this.assertContentsEqual(file, "Hello");
                    ISemanticFile sFile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                    sFile.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor);
                    TestsCachingProvider.this.assertContentsEqual(file, "New Remote");
                    Util.safeClose((InputStream)is);
                    file.refreshLocal(2, monitor);
                    TestsCachingProvider.this.assertContentsEqual(file, "New Remote");
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testAppendContentsToOpenFile() throws Exception {
        IFolder root = this.testProject.getFolder("root");
        IFolder parent = root.getFolder("Folder1");
        final IFile file = parent.getFile("File1");
        final ISemanticFile sfile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder folder = (ISemanticFolder)file.getParent().getAdapter(ISemanticFolder.class);
                folder.addFile(file.getName(), 0, monitor);
                TestsCachingProvider.this.assertContentsEqual(file, "Hello");
                sfile.validateEdit(null);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                file.appendContents((InputStream)new ByteArrayInputStream(" appended".getBytes()), 0, monitor);
                TestsCachingProvider.this.assertContentsEqual(file, "Hello appended");
                InputStream is = null;
                try {
                    is = file.getContents();
                    TestsCachingProvider.this.assertContentsEqual(file, "Hello appended");
                    file.appendContents((InputStream)new ByteArrayInputStream(" again".getBytes()), 0, monitor);
                    TestsCachingProvider.this.assertContentsEqual(file, "Hello appended again");
                    sfile.synchronizeContentWithRemote(SyncDirection.OUTGOING, 0, monitor);
                    Assert.assertEquals((String)"Wrong remote content", (String)new String(TestsCachingProvider.this.file1.getContent()), (String)"Hello appended again");
                }
                finally {
                    Util.safeClose((InputStream)is);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
    }
}

