/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.Capability;
import org.osgi.framework.wiring.WiredCapability;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseDescriptionImpl
implements BaseDescription {
    protected final Object monitor = new Object();
    private volatile String name;
    private volatile Version version;

    BaseDescriptionImpl() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Version getVersion() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.version == null) {
                return Version.emptyVersion;
            }
            return this.version;
        }
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setVersion(Version version) {
        this.version = version;
    }

    static String toString(Map<String, Object> map, boolean directives) {
        if (map.size() == 0) {
            return "";
        }
        String assignment = directives ? ":=" : "=";
        Set<Map.Entry<String, Object>> set = map.entrySet();
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : set) {
            sb.append("; ");
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (list.size() == 0) continue;
                Object component = list.get(0);
                String className = component.getClass().getName();
                String type = className.substring(className.lastIndexOf(46) + 1);
                sb.append(key).append(':').append("List<").append(type).append(">").append(assignment).append('\"');
                for (Object object : list) {
                    sb.append(object).append(',');
                }
                sb.setLength(sb.length() - 1);
                sb.append('\"');
                continue;
            }
            String type = "";
            if (!(value instanceof String)) {
                String className = value.getClass().getName();
                type = new StringBuffer(":").append(className.substring(className.lastIndexOf(46) + 1)).toString();
            }
            sb.append(key).append(type).append(assignment).append('\"').append(value).append('\"');
        }
        return sb.toString();
    }

    String getInternalNameSpace() {
        return null;
    }

    WiredCapability getWiredCapability(String namespace) {
        if (namespace == null) {
            namespace = this.getInternalNameSpace();
        }
        if (namespace == null) {
            return null;
        }
        BundleDescription supplier = this.getSupplier();
        BundleWiring wiring = supplier.getBundleWiring();
        if (wiring == null) {
            return null;
        }
        return new BaseWiredCapability(namespace, wiring);
    }

    @Override
    public Capability getCapability() {
        return this.getCapability(null);
    }

    Capability getCapability(String namespace) {
        if (namespace == null) {
            namespace = this.getInternalNameSpace();
        }
        if (namespace == null) {
            return null;
        }
        return new BaseCapability(namespace);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseCapability
    implements Capability {
        private final String namespace;

        public BaseCapability(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public BundleRevision getProviderRevision() {
            return BaseDescriptionImpl.this.getSupplier();
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public Map<String, String> getDirectives() {
            return BaseDescriptionImpl.this.getDeclaredDirectives();
        }

        @Override
        public Map<String, Object> getAttributes() {
            Map<String, Object> attrs = BaseDescriptionImpl.this.getDeclaredAttributes();
            String internalName = BaseDescriptionImpl.this.getInternalNameSpace();
            if (this.namespace.equals(internalName)) {
                return attrs;
            }
            Object nameValue = (attrs = new HashMap<String, Object>(attrs)).remove(internalName);
            if (nameValue != null) {
                attrs.put(this.namespace, nameValue);
            }
            return Collections.unmodifiableMap(attrs);
        }

        public int hashCode() {
            return System.identityHashCode(BaseDescriptionImpl.this);
        }

        protected BaseDescriptionImpl getBaseDescription() {
            return BaseDescriptionImpl.this;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseCapability)) {
                return false;
            }
            return ((BaseCapability)obj).getBaseDescription() == BaseDescriptionImpl.this && this.namespace.equals(((BaseCapability)obj).getNamespace());
        }

        public String toString() {
            return new StringBuffer(String.valueOf(this.getNamespace())).append(BaseDescriptionImpl.toString(this.getAttributes(), false)).toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BaseWiredCapability
    extends BaseCapability
    implements WiredCapability {
        private final BundleWiring originalWiring;

        public BaseWiredCapability(String namespace, BundleWiring originalWiring) {
            super(namespace);
            this.originalWiring = originalWiring;
        }

        @Override
        public Collection<BundleWiring> getRequirerWirings() {
            List<BundleRevision> fragments;
            BundleWiring wiring = this.getProviderWiring();
            if (wiring == null) {
                return null;
            }
            BundleDescription supplier = BaseDescriptionImpl.this.getSupplier();
            BundleDescription[] dependents = supplier.getDependents();
            ArrayList<BundleWiring> requirers = new ArrayList<BundleWiring>();
            if ("osgi.host".equals(this.getNamespace()) && (fragments = wiring.getFragmentRevisions()) != null && fragments.size() > 0) {
                requirers.add(wiring);
            }
            BundleDescription[] bundleDescriptionArray = dependents;
            int n = dependents.length;
            int n2 = 0;
            while (n2 < n) {
                List<WiredCapability> namespace;
                BundleDescription dependent = bundleDescriptionArray[n2];
                BundleWiring dependentWiring = dependent.getBundleWiring();
                if (dependentWiring != null && (namespace = dependentWiring.getRequiredCapabilities(this.getNamespace())) != null && namespace.contains(this)) {
                    requirers.add(dependentWiring);
                }
                ++n2;
            }
            return requirers;
        }

        @Override
        public BundleWiring getProviderWiring() {
            return this.originalWiring.isInUse() ? this.originalWiring : null;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(BaseDescriptionImpl.this) ^ System.identityHashCode(this.originalWiring);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BaseWiredCapability)) {
                return false;
            }
            BaseWiredCapability other = (BaseWiredCapability)obj;
            return other.originalWiring == this.originalWiring && super.equals(obj);
        }
    }
}

