/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerHandledItemTest
extends ModelReconcilerTest {
    public void testHandledToolItem_Command_Set() {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MHandledToolItem handledToolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        toolBar.getChildren().add(handledToolItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        handledToolItem.setCommand(command);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        handledToolItem = (MHandledToolItem)toolBar.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertNull((Object)handledToolItem.getCommand());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((Object)command, (Object)handledToolItem.getCommand());
    }

    public void testHandledToolItem_Command_Unset() {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MHandledToolItem handledToolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        toolBar.getChildren().add(handledToolItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        handledToolItem.setCommand(command);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        handledToolItem = (MHandledToolItem)toolBar.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertNull((Object)handledToolItem.getCommand());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((Object)command, (Object)handledToolItem.getCommand());
    }

    public void testHandledToolItem_Parameters_Add() {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MHandledToolItem handledToolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        toolBar.getChildren().add(handledToolItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setName("parameterName");
        handledToolItem.getParameters().add(parameter);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        handledToolItem = (MHandledToolItem)toolBar.getChildren().get(0);
        ModelReconcilerHandledItemTest.assertEquals((int)0, (int)handledToolItem.getParameters().size());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertEquals((int)0, (int)handledToolItem.getParameters().size());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((int)1, (int)handledToolItem.getParameters().size());
        ModelReconcilerHandledItemTest.assertEquals((String)"parameterName", (String)((MParameter)handledToolItem.getParameters().get(0)).getName());
    }

    public void testHandledToolItem_Parameters_Remove() {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MHandledToolItem handledToolItem = MenuFactoryImpl.eINSTANCE.createHandledToolItem();
        toolBar.getChildren().add(handledToolItem);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setName("parameterName");
        handledToolItem.getParameters().add(parameter);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        handledToolItem.getParameters().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        handledToolItem = (MHandledToolItem)toolBar.getChildren().get(0);
        parameter = (MParameter)handledToolItem.getParameters().get(0);
        ModelReconcilerHandledItemTest.assertEquals((int)1, (int)handledToolItem.getParameters().size());
        ModelReconcilerHandledItemTest.assertEquals((Object)parameter, handledToolItem.getParameters().get(0));
        ModelReconcilerHandledItemTest.assertEquals((String)"parameterName", (String)parameter.getName());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertEquals((int)1, (int)handledToolItem.getParameters().size());
        ModelReconcilerHandledItemTest.assertEquals((Object)parameter, handledToolItem.getParameters().get(0));
        ModelReconcilerHandledItemTest.assertEquals((String)"parameterName", (String)parameter.getName());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((int)0, (int)handledToolItem.getParameters().size());
    }

    public void testHandledMenuItem_Command_Set() {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MHandledMenuItem handledMenuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        menu.getChildren().add(handledMenuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        handledMenuItem.setCommand(command);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        handledMenuItem = (MHandledMenuItem)menu.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertNull((Object)handledMenuItem.getCommand());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((Object)command, (Object)handledMenuItem.getCommand());
    }

    public void testHandledMenuItem_Command_Unset() {
        MApplication application = this.createApplication();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        application.getCommands().add(command);
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MHandledMenuItem handledMenuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        handledMenuItem.setCommand(command);
        menu.getChildren().add(handledMenuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        handledMenuItem.setCommand(null);
        Object state = reconciler.serialize();
        application = this.createApplication();
        command = (MCommand)application.getCommands().get(0);
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        handledMenuItem = (MHandledMenuItem)menu.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertEquals((Object)command, (Object)handledMenuItem.getCommand());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertNull((Object)handledMenuItem.getCommand());
    }

    public void testHandledMenuItem_Parameters_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MHandledMenuItem handledMenuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        menu.getChildren().add(handledMenuItem);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setName("parameterName");
        handledMenuItem.getParameters().add(parameter);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        handledMenuItem = (MHandledMenuItem)menu.getChildren().get(0);
        ModelReconcilerHandledItemTest.assertEquals((int)0, (int)handledMenuItem.getParameters().size());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertEquals((int)0, (int)handledMenuItem.getParameters().size());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerHandledItemTest.assertEquals((String)"parameterName", (String)((MParameter)handledMenuItem.getParameters().get(0)).getName());
    }

    public void testHandledMenuItem_Parameters_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        window.setMainMenu(menu);
        MHandledMenuItem handledMenuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        menu.getChildren().add(handledMenuItem);
        MParameter parameter = CommandsFactoryImpl.eINSTANCE.createParameter();
        parameter.setName("parameterName");
        handledMenuItem.getParameters().add(parameter);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        handledMenuItem.getParameters().remove(0);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        menu = window.getMainMenu();
        handledMenuItem = (MHandledMenuItem)menu.getChildren().get(0);
        parameter = (MParameter)handledMenuItem.getParameters().get(0);
        ModelReconcilerHandledItemTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerHandledItemTest.assertEquals((String)"parameterName", (String)parameter.getName());
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerHandledItemTest.assertEquals((int)1, (int)handledMenuItem.getParameters().size());
        ModelReconcilerHandledItemTest.assertEquals((Object)parameter, handledMenuItem.getParameters().get(0));
        ModelReconcilerHandledItemTest.assertEquals((String)"parameterName", (String)parameter.getName());
        this.applyAll(deltas);
        ModelReconcilerHandledItemTest.assertEquals((int)0, (int)handledMenuItem.getParameters().size());
    }
}

