/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.providers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.Messages;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.resources.semantic.examples.webdav.WebDAVResourceNotFoundException;
import org.eclipse.core.resources.semantic.examples.webdav.WebDAVUtil;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.DefaultMinimalSemanticResourceRuleFactory;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.ICacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocking;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderREST;
import org.eclipse.core.resources.semantic.spi.ISemanticFileHistoryProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticResourceRuleFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticTreeVisitor;
import org.eclipse.core.resources.semantic.spi.SemanticFileRevision;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticTreeWalker;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;

public class SampleWebDAVContentProvider
extends CachingContentProvider
implements ISemanticContentProviderREST,
ISemanticContentProviderLocking {
    private static final QualifiedName RESOURCE_ETAG = new QualifiedName(SemanticResourcesPluginExamplesCore.PLUGIN_ID, "ETag");
    private static final QualifiedName LOCAL_CHANGE = new QualifiedName(SemanticResourcesPluginExamplesCore.PLUGIN_ID, "LocalChange");
    private static final QualifiedName SUPPORTS_LOCKING = new QualifiedName(SemanticResourcesPluginExamplesCore.PLUGIN_ID, "SupportsLocking");
    private static final QualifiedName LOCK_TOKEN = new QualifiedName(SemanticResourcesPluginExamplesCore.PLUGIN_ID, "LockToken");
    private static final String TRUE = "true";

    public void onCacheUpdate(ISemanticFileStore childStore, InputStream newContent, long timestamp, boolean append, IProgressMonitor monitor) {
        super.onCacheUpdate(childStore, newContent, timestamp, append, monitor);
        try {
            childStore.setLocalOnly(false);
            childStore.setPersistentProperty(LOCAL_CHANGE, TRUE);
            childStore.setPersistentProperty(RESOURCE_ETAG, null);
        }
        catch (CoreException e) {
            SemanticResourcesPluginExamplesCore.getDefault().getLog().log((IStatus)new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISemanticFileHistoryProvider.class) {
            return new ISemanticFileHistoryProvider(){

                public IFileRevision getWorkspaceFileRevision(final ISemanticFileStore store) {
                    return new SemanticFileRevision(store, store.fetchInfo().getLastModified(), null, null){

                        public IStorage getStorage(IProgressMonitor monitor) {
                            return new IStorage(){

                                public Object getAdapter(Class adapter1) {
                                    return null;
                                }

                                public boolean isReadOnly() {
                                    return store.fetchInfo().getAttribute(2);
                                }

                                public String getName() {
                                    return store.getName();
                                }

                                public IPath getFullPath() {
                                    return null;
                                }

                                public InputStream getContents() throws CoreException {
                                    return store.openInputStream(0, null);
                                }
                            };
                        }
                    };
                }

                public IFileRevision[] getResourceVariants(final ISemanticFileStore store, IProgressMonitor monitor) {
                    if (store.getType() == 1 && !store.fetchInfo().getAttribute(2)) {
                        IFileRevision remote = new IFileRevision(){

                            public IFileRevision withAllProperties(IProgressMonitor monitor1) {
                                return this;
                            }

                            public boolean isPropertyMissing() {
                                return false;
                            }

                            public URI getURI() {
                                try {
                                    return new URI(store.getRemoteURIString());
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                }
                                catch (CoreException coreException) {}
                                return null;
                            }

                            public long getTimestamp() {
                                return -1L;
                            }

                            public ITag[] getTags() {
                                return new ITag[0];
                            }

                            public IStorage getStorage(IProgressMonitor monitor1) {
                                return new IStorage(){

                                    public Object getAdapter(Class adapter1) {
                                        return null;
                                    }

                                    public boolean isReadOnly() {
                                        return true;
                                    }

                                    public String getName() {
                                        return store.getName();
                                    }

                                    public IPath getFullPath() {
                                        return null;
                                    }

                                    public InputStream getContents() throws CoreException {
                                        URI uri = SampleWebDAVContentProvider.this.getWebDAVURIForStore(store);
                                        WebDAVUtil.IWebDAVCallback setter = new WebDAVUtil.IWebDAVCallback(){

                                            public void setTimestamp(long timestamp) {
                                            }

                                            public void setETag(String value) {
                                            }

                                            public void setContentType(String contentType) {
                                            }
                                        };
                                        try {
                                            return WebDAVUtil.openInputStream(uri.toString(), setter);
                                        }
                                        catch (IOException e) {
                                            throw new CoreException((IStatus)new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, e.getMessage(), (Throwable)e));
                                        }
                                    }
                                };
                            }

                            public String getName() {
                                return store.getName();
                            }

                            public String getContentIdentifier() {
                                try {
                                    URI uri = SampleWebDAVContentProvider.this.getWebDAVURIForStore(store);
                                    WebDAVUtil.WebDAVNode node = WebDAVUtil.retrieveRemoteState(uri, (IProgressMonitor)new NullProgressMonitor());
                                    if (node != null) {
                                        return node.etag;
                                    }
                                }
                                catch (Exception exception) {}
                                return "unknown";
                            }

                            public String getComment() {
                                return null;
                            }

                            public String getAuthor() {
                                return null;
                            }

                            public boolean exists() {
                                return false;
                            }
                        };
                        IFileRevision[] iFileRevisionArray = new IFileRevision[2];
                        iFileRevisionArray[1] = remote;
                        return iFileRevisionArray;
                    }
                    return null;
                }

                public IFileHistory getHistoryFor(ISemanticFileStore store, int options, IProgressMonitor monitor) {
                    return null;
                }
            };
        }
        return null;
    }

    public ISemanticResourceRuleFactory getRuleFactory() {
        return new DefaultMinimalSemanticResourceRuleFactory(this.getRootStore());
    }

    public ICacheServiceFactory getCacheServiceFactory() {
        return new FileCacheServiceFactory();
    }

    public IStatus validateEdit(ISemanticFileStore[] semanticFileStores, Object shell) {
        try {
            ISemanticFileStore[] iSemanticFileStoreArray = semanticFileStores;
            int n = semanticFileStores.length;
            int n2 = 0;
            while (n2 < n) {
                ISemanticFileStore iSemanticFileStore = iSemanticFileStoreArray[n2];
                if (this.isReadOnlyInternal(iSemanticFileStore)) {
                    this.setReadOnlyInternal(iSemanticFileStore, false);
                }
                ++n2;
            }
            return Status.OK_STATUS;
        }
        catch (CoreException coreException) {
            return Status.CANCEL_STATUS;
        }
    }

    public IStatus validateSave(ISemanticFileStore semanticFileStore) {
        try {
            if (!this.isReadOnlyInternal(semanticFileStore)) {
                return Status.OK_STATUS;
            }
        }
        catch (CoreException coreException) {}
        return Status.CANCEL_STATUS;
    }

    public void onRootStoreCreate(ISemanticFileStore newStore) {
        try {
            if (newStore.getType() == 1) {
                this.setReadOnlyInternal(newStore, true);
            }
        }
        catch (CoreException coreException) {}
    }

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) {
    }

    public void addFileFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        parentStore.addChildFile(name);
        ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
        String uriString = uri.toString();
        newChild.setRemoteURIString(uriString);
        this.setReadOnlyInternal(newChild, true);
        try {
            this.refreshStoreHierarchy(SyncDirection.INCOMING, newChild, uri, monitor);
        }
        catch (CoreException e) {
            this.deleteCache(newChild, monitor);
            newChild.remove(monitor);
            throw e;
        }
    }

    public void addFolderFromRemoteByURI(ISemanticFileStore parentStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        parentStore.addChildFolder(name);
        ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
        String uriString = uri.toString();
        newChild.setRemoteURIString(uriString);
        try {
            this.refreshStoreHierarchy(SyncDirection.INCOMING, newChild, uri, monitor);
        }
        catch (CoreException e) {
            this.deleteCache(newChild, monitor);
            newChild.remove(monitor);
            throw e;
        }
    }

    private void refreshStoreHierarchy(SyncDirection direction, ISemanticFileStore root, URI rootURI, IProgressMonitor monitor) throws CoreException {
        try {
            if (root.getType() == 1) {
                this.updateSingleFile(direction, root, rootURI, monitor);
            } else {
                WebDAVUtil.WebDAVNode rootNode = WebDAVUtil.retrieveRemoteState(rootURI, monitor);
                if (direction.equals((Object)SyncDirection.INCOMING) || direction.equals((Object)SyncDirection.BOTH)) {
                    this.updateChildrenIncoming(root, rootNode, monitor);
                }
                if (direction.equals((Object)SyncDirection.OUTGOING) || direction.equals((Object)SyncDirection.BOTH)) {
                    this.updateChildrenOutgoing(root, monitor);
                }
            }
        }
        catch (IOException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.SYNC_ERROR, root.getPath(), e.getMessage(), (Throwable)e);
        }
    }

    private void updateSingleFile(SyncDirection direction, ISemanticFileStore store, URI rootURI, IProgressMonitor monitor) throws CoreException {
        if ((direction.equals((Object)SyncDirection.INCOMING) || direction.equals((Object)SyncDirection.BOTH)) && this.isReadOnlyInternal(store)) {
            try {
                WebDAVUtil.WebDAVNode rootNode = WebDAVUtil.retrieveRemoteState(rootURI, monitor);
                boolean changed = this.checkAndSetWebDAVModificationProperties(store, rootNode.lastModified, rootNode.etag, rootNode.contentType, monitor);
                if (changed) {
                    this.deleteCache(store, monitor);
                }
            }
            catch (WebDAVResourceNotFoundException webDAVResourceNotFoundException) {
                store.remove(monitor);
            }
            catch (IOException e) {
                throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, store.getPath(), e.getMessage(), (Throwable)e);
            }
            return;
        }
        if (direction.equals((Object)SyncDirection.OUTGOING) || direction.equals((Object)SyncDirection.BOTH)) {
            this.uploadFileStoreContent(store, monitor);
        }
    }

    InputStream getCachedContent(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        IPath path;
        ICacheService cacheService = this.getCacheService();
        if (!cacheService.hasContent(path = childStore.getPath())) {
            throw new SemanticResourceException(SemanticResourceStatusCode.CACHED_CONTENT_NOT_FOUND, childStore.getPath(), null);
        }
        return cacheService.getContent(path);
    }

    private void updateChildrenIncoming(ISemanticFileStore root, WebDAVUtil.WebDAVNode rootNode, IProgressMonitor monitor) throws CoreException {
        IFileStore[] existingChildren;
        for (WebDAVUtil.WebDAVNode node : rootNode.children) {
            ISemanticFileStore child;
            String nodeName = node.path.segment(node.path.segmentCount() - 1);
            if (root.hasChild(nodeName)) {
                boolean changed;
                child = (ISemanticFileStore)root.getChild(nodeName);
                if (node.isFolder) {
                    this.updateChildrenIncoming(child, node, monitor);
                    continue;
                }
                if (!this.isReadOnlyInternal(child) || !(changed = this.checkAndSetWebDAVModificationProperties(child, node.lastModified, node.etag, node.contentType, monitor))) continue;
                this.deleteCache(child, monitor);
                continue;
            }
            if (node.isFolder) {
                root.addChildFolder(nodeName);
                child = (ISemanticFileStore)root.getChild(nodeName);
                this.updateChildrenIncoming(child, node, monitor);
                continue;
            }
            root.addChildResource(nodeName, false, null, null);
            child = (ISemanticFileStore)root.getChild(nodeName);
            this.setContentTypeInternal(child, node.contentType);
            this.setResourceTimestamp(child, node.lastModified, monitor);
            this.setReadOnly(child, true, monitor);
            child.setPersistentProperty(RESOURCE_ETAG, node.etag);
            if (!node.supportsLocking) continue;
            child.setPersistentProperty(SUPPORTS_LOCKING, TRUE);
        }
        IFileStore[] iFileStoreArray = existingChildren = root.childStores(0, monitor);
        int n = existingChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore store = iFileStoreArray[n2];
            ISemanticFileStore child = (ISemanticFileStore)store;
            boolean found = false;
            for (WebDAVUtil.WebDAVNode node : rootNode.children) {
                String nodeName = node.path.segment(node.path.segmentCount() - 1);
                if (!nodeName.equals(child.getName())) continue;
                found = true;
                break;
            }
            if (!found && !this.isModifiedLocally(child)) {
                child.remove(monitor);
            }
            ++n2;
        }
    }

    private void updateChildrenOutgoing(ISemanticFileStore root, IProgressMonitor monitor) throws CoreException {
        IFileStore[] existingChildren;
        IFileStore[] iFileStoreArray = existingChildren = root.childStores(0, monitor);
        int n = existingChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore store = iFileStoreArray[n2];
            ISemanticFileStore child = (ISemanticFileStore)store;
            if (child.getType() == 1) {
                this.uploadFileStoreContent(child, monitor);
            } else {
                this.updateChildrenOutgoing(child, monitor);
            }
            ++n2;
        }
    }

    private void uploadFileStoreContent(final ISemanticFileStore child, final IProgressMonitor monitor) throws CoreException {
        if (!this.isReadOnlyInternal(child) && (child.getPersistentProperty(LOCAL_CHANGE) != null || child.isLocalOnly())) {
            URI remoteURI = this.getWebDAVURIForStore(child);
            try {
                WebDAVUtil.sendData(remoteURI.toString(), new WebDAVUtil.InputStreamProvider(){

                    public InputStream getInputStream() throws IOException {
                        try {
                            return SampleWebDAVContentProvider.this.getCachedContent(child, monitor);
                        }
                        catch (CoreException e) {
                            throw new IOException(e.getMessage());
                        }
                    }
                }, monitor);
                child.setPersistentProperty(LOCAL_CHANGE, null);
                child.setLocalOnly(false);
                this.setReadOnly(child, true, monitor);
                WebDAVUtil.WebDAVNode node = WebDAVUtil.retrieveRemoteState(remoteURI, monitor);
                this.setContentTypeInternal(child, node.contentType);
                this.setResourceTimestamp(child, node.lastModified, monitor);
                child.setPersistentProperty(RESOURCE_ETAG, node.etag);
                if (node.supportsLocking) {
                    child.setPersistentProperty(SUPPORTS_LOCKING, TRUE);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void synchronizeContentWithRemote(ISemanticFileStore store, final SyncDirection direction, final IProgressMonitor monitor, final MultiStatus status) {
        try {
            ISemanticFileStore parent = this.findParentWithURI(store);
            if (parent == null) {
                ISemanticTreeVisitor visitor = new ISemanticTreeVisitor(){

                    public boolean visit(ISemanticFileStore store1, IProgressMonitor monitor1) throws CoreException {
                        String remoteURI = store1.getRemoteURIString();
                        if (remoteURI != null) {
                            SampleWebDAVContentProvider.this.synchronizeContentWithRemote(store1, direction, monitor, status);
                            return false;
                        }
                        return true;
                    }
                };
                SemanticTreeWalker.accept((ISemanticFileStore)store, (ISemanticTreeVisitor)visitor, (IProgressMonitor)monitor);
                return;
            }
            URI uri = this.getWebDAVURIForStore(store);
            this.refreshStoreHierarchy(direction, store, uri, monitor);
        }
        catch (CoreException e) {
            IStatus innerStatus = e.getStatus();
            Status newStatus = new Status(innerStatus.getSeverity(), innerStatus.getPlugin(), e.getMessage(), (Throwable)e);
            status.add((IStatus)newStatus);
            return;
        }
    }

    URI getWebDAVURIForStore(ISemanticFileStore store) throws CoreException {
        ISemanticFileStore parent = this.findParentWithURI(store);
        if (parent == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, store.getPath(), NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_RemoteUriNotSet_XMSG, (Object)store.getPath().toString()));
        }
        String remoteURI = parent.getRemoteURIString();
        if (remoteURI == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, store.getPath(), NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_RemoteUriNotSet_XMSG, (Object)store.getPath().toString()));
        }
        IPath relativePath = store.getPath().removeFirstSegments(parent.getPath().segmentCount());
        String fileURIString = !relativePath.isEmpty() ? (remoteURI.endsWith("/") ? String.valueOf(remoteURI) + relativePath.toString() : String.valueOf(remoteURI) + "/" + relativePath.toString()) : remoteURI;
        try {
            URI uri = new URI(fileURIString);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_URI_SYNTAX, store.getPath(), NLS.bind((String)Messages.RemoteStoreContentProvider_URIError_XMSG, (Object)store.getPath().toString()), (Throwable)e);
        }
    }

    public void removeResource(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        this.deleteCache(semanticFileStore, monitor);
        semanticFileStore.remove(monitor);
    }

    public void revertChanges(ISemanticFileStore store, IProgressMonitor monitor) throws CoreException {
        this.deleteCache(store, monitor);
        this.setReadOnlyInternal(store, true);
        this.setResourceTimestamp(store, 0L, monitor);
        store.setPersistentProperty(LOCAL_CHANGE, null);
        MultiStatus status = new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, "", null);
        this.fillCache(store, monitor, status);
    }

    public void setReadOnly(ISemanticFileStore semanticFileStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        this.setReadOnlyInternal(semanticFileStore, readonly);
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        String uriString = SemanticSpiResourceInfo.isOptionRequested((int)64, (int)options) ? semanticFileStore.getRemoteURIString() : null;
        boolean readOnly = SemanticSpiResourceInfo.isOptionRequested((int)16, (int)options) ? this.isReadOnlyInternal(semanticFileStore) : false;
        boolean supportsLocking = false;
        if (SemanticSpiResourceInfo.isOptionRequested((int)4, (int)options) && semanticFileStore.getPersistentProperty(SUPPORTS_LOCKING) != null) {
            supportsLocking = true;
        }
        boolean locked = false;
        if (SemanticSpiResourceInfo.isOptionRequested((int)2, (int)options) && semanticFileStore.getPersistentProperty(LOCK_TOKEN) != null) {
            locked = true;
        }
        boolean existsRemotely = false;
        if (SemanticSpiResourceInfo.isOptionRequested((int)32, (int)options)) {
            String remoteURI;
            try {
                remoteURI = this.getWebDAVURIForStore(semanticFileStore).toString();
            }
            catch (CoreException coreException) {
                remoteURI = null;
            }
            if (remoteURI != null) {
                existsRemotely = WebDAVUtil.checkExistence(remoteURI, semanticFileStore.getType() != 1, monitor);
            }
        }
        return new SemanticSpiResourceInfo(options, locked, supportsLocking, readOnly, existsRemotely, uriString, this.getContentTypeInternal(semanticFileStore));
    }

    public InputStream openInputStreamInternal(ISemanticFileStore store, IProgressMonitor monitor, CachingContentProvider.ICacheTimestampSetter timeStampSetter) throws CoreException {
        ISemanticFileStore parent = this.findParentWithURI(store);
        if (parent == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, store.getPath(), NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_RemoteUriNotSet_XMSG, (Object)store.getPath().toString()));
        }
        String remoteURI = parent.getRemoteURIString();
        if (remoteURI == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, store.getPath(), NLS.bind((String)Messages.SampleRESTReadonlyContentProvider_RemoteUriNotSet_XMSG, (Object)store.getPath().toString()));
        }
        try {
            IPath relativePath = store.getPath().removeFirstSegments(parent.getPath().segmentCount());
            String fileURIString = !relativePath.isEmpty() ? (remoteURI.endsWith("/") ? String.valueOf(remoteURI) + relativePath.toString() : String.valueOf(remoteURI) + "/" + relativePath.toString()) : remoteURI;
            final long[] timestamp = new long[1];
            final String[] contentType = new String[1];
            final String[] eTag = new String[1];
            InputStream is = WebDAVUtil.openInputStream(fileURIString, new WebDAVUtil.IWebDAVCallback(){

                public void setTimestamp(long timestamp1) {
                    timestamp[0] = timestamp1;
                }

                public void setContentType(String contentType1) {
                    contentType[0] = contentType1;
                }

                public void setETag(String value) {
                    eTag[0] = value;
                }
            });
            try {
                this.checkAndSetWebDAVModificationProperties(store, timestamp[0], eTag[0], contentType[0], monitor);
            }
            catch (CoreException e) {
                Util.safeClose((InputStream)is);
                throw e;
            }
            catch (RuntimeException e) {
                Util.safeClose((InputStream)is);
                throw e;
            }
            timeStampSetter.setTimestamp(this.getResourceTimestampInternal(store));
            return is;
        }
        catch (IOException e) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, store.getPath(), e.getMessage(), (Throwable)e);
        }
    }

    private ISemanticFileStore findParentWithURI(ISemanticFileStore store) throws CoreException {
        if (store.getRemoteURIString() != null) {
            return store;
        }
        ISemanticFileStore parent = (ISemanticFileStore)store.getParent();
        while (parent != null) {
            if (parent.getRemoteURIString() != null) break;
            parent = (ISemanticFileStore)parent.getParent();
        }
        return parent;
    }

    public String getURIString(ISemanticFileStore semanticFileStore) throws CoreException {
        return semanticFileStore.getRemoteURIString();
    }

    public void setURIString(ISemanticFileStore store, URI uri, IProgressMonitor monitor) throws CoreException {
        store.setRemoteURIString(uri.toString());
        if (store.getType() == 1) {
            this.deleteCache(store, monitor);
            this.setResourceTimestamp(store, 0L, monitor);
            this.setReadOnlyInternal(store, true);
            store.setPersistentProperty(LOCAL_CHANGE, null);
            try {
                WebDAVUtil.WebDAVNode rootNode = WebDAVUtil.retrieveRemoteState(uri, monitor);
                this.checkAndSetWebDAVModificationProperties(store, rootNode.lastModified, rootNode.etag, rootNode.contentType, monitor);
            }
            catch (IOException e) {
                throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, store.getPath(), e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean checkAndSetWebDAVModificationProperties(ISemanticFileStore child, long lastModified, String eTag, String contentType, IProgressMonitor monitor) throws CoreException {
        boolean changed = false;
        long oldTimestamp = this.getResourceTimestampInternal(child);
        String oldETag = child.getPersistentProperty(RESOURCE_ETAG);
        if (oldETag != null) {
            if (!oldETag.equals(eTag)) {
                changed = true;
            }
        } else if (oldTimestamp != lastModified) {
            changed = true;
        }
        if (changed) {
            this.setResourceTimestamp(child, lastModified, monitor);
            this.setContentTypeInternal(child, contentType);
            child.setPersistentProperty(RESOURCE_ETAG, eTag);
        }
        return changed;
    }

    public IStatus lockResource(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        if (!this.isLockingSupported(semanticFileStore)) {
            return Status.CANCEL_STATUS;
        }
        if (!this.isLocked(semanticFileStore)) {
            String remoteURI = this.getWebDAVURIForStore(semanticFileStore).toString();
            try {
                String lockToken = WebDAVUtil.sendLockRequest(remoteURI, monitor);
                semanticFileStore.setPersistentProperty(LOCK_TOKEN, lockToken);
            }
            catch (IOException e) {
                return new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus unlockResource(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        if (!this.isLockingSupported(semanticFileStore)) {
            return Status.CANCEL_STATUS;
        }
        if (this.isLocked(semanticFileStore)) {
            String remoteURI = this.getWebDAVURIForStore(semanticFileStore).toString();
            try {
                String lockToken = semanticFileStore.getPersistentProperty(LOCK_TOKEN);
                WebDAVUtil.sendUnlockRequest(remoteURI, lockToken, monitor);
                semanticFileStore.setPersistentProperty(LOCK_TOKEN, null);
            }
            catch (IOException e) {
                return new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private boolean isLocked(ISemanticFileStore store) throws CoreException {
        return store.getPersistentProperty(LOCK_TOKEN) != null;
    }

    private boolean isLockingSupported(ISemanticFileStore store) throws CoreException {
        return store.getPersistentProperty(SUPPORTS_LOCKING) != null;
    }

    private boolean isModifiedLocally(ISemanticFileStore store) throws CoreException {
        return !this.isReadOnlyInternal(store) && store.getPersistentProperty(LOCAL_CHANGE) != null || store.isLocalOnly();
    }
}

