/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.semantic.examples.remote.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFolder
extends RemoteItem {
    private final List<RemoteItem> myChildren = new ArrayList<RemoteItem>();

    public RemoteFolder(RemoteStoreTransient store, RemoteFolder parent, String name) {
        super(store, parent, name, RemoteItem.Type.FOLDER);
    }

    public RemoteFolder(RemoteStoreTransient store) {
        super(store, null, "", RemoteItem.Type.FOLDER);
    }

    public RemoteFolder addFolder(String name) {
        if (this.hasChild(name)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.RemoteFolder_ChildAlreadyExists_XMSG, (Object)name, (Object)this.getPath().toPortableString()));
        }
        RemoteFolder child = new RemoteFolder(this.myStore, this, name);
        this.myChildren.add(child);
        return child;
    }

    public RemoteFile addFile(String name, byte[] content, long timestamp) {
        if (this.hasChild(name)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.RemoteFolder_ChildAlreadyExists_XMSG, (Object)name, (Object)this.getPath().toPortableString()));
        }
        RemoteFile child = new RemoteFile(this.myStore, this, name, content, timestamp);
        this.myChildren.add(child);
        return child;
    }

    public List<RemoteItem> getChildren() {
        return this.myChildren;
    }

    public boolean hasChild(String name) {
        return this.getChild(name) != null;
    }

    public RemoteItem getChild(String name) {
        for (RemoteItem child : this.myChildren) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void deleteChild(String name) {
        this.myChildren.remove(this.getChild(name));
    }
}

