/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common.component;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComponentEditor {
    private EditingDomain editingDomain;
    private WritableValue master = new WritableValue();
    public static final int SEARCH_IMAGE = 0;
    public static final int TABLE_ADD_IMAGE = 1;
    public static final int TABLE_DELETE_IMAGE = 2;
    public static final int ARROW_UP = 3;
    public static final int ARROW_DOWN = 4;
    protected static final int VERTICAL_LIST_WIDGET_INDENT = 10;
    private ModelEditor editor;
    private final IResourcePool resourcePool;

    public AbstractComponentEditor(EditingDomain editingDomain, ModelEditor editor, IResourcePool resourcePool) {
        this.editingDomain = editingDomain;
        this.editor = editor;
        this.resourcePool = resourcePool;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public ModelEditor getEditor() {
        return this.editor;
    }

    public WritableValue getMaster() {
        return this.master;
    }

    protected void setElementId(Object element) {
        MApplicationElement el;
        if (this.getEditor().isAutoCreateElementId() && element instanceof MApplicationElement && ((el = (MApplicationElement)element).getElementId() == null || el.getElementId().trim().length() == 0)) {
            el.setElementId(Util.getDefaultElementId(((EObject)this.getMaster().getValue()).eResource(), el, this.getEditor().getProject()));
        }
    }

    public Image createImage(String key) {
        return this.resourcePool.getImageUnchecked(key);
    }

    public ImageDescriptor createImageDescriptor(String key) {
        return ImageDescriptor.createFromImage((Image)this.createImage(key));
    }

    public abstract Image getImage(Object var1, Display var2);

    public abstract String getLabel(Object var1);

    public abstract String getDetailLabel(Object var1);

    public abstract String getDescription(Object var1);

    public abstract Composite getEditor(Composite var1, Object var2);

    public abstract IObservableList getChildList(Object var1);

    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[0];
    }

    public List<Action> getActions(Object element) {
        return Collections.emptyList();
    }
}

