/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.tools.emf.ui.common.EStackLayout;
import org.eclipse.e4.tools.emf.ui.common.ImageTooltip;
import org.eclipse.e4.tools.emf.ui.common.Util;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.component.ControlFactory;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.WindowIconDialogEditor;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsPackageImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationPackageImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private IProject project;
    private IListProperty HANDLER_CONTAINER__HANDLERS = EMFProperties.list((EStructuralFeature)CommandsPackageImpl.Literals.HANDLER_CONTAINER__HANDLERS);
    private IListProperty WINDOW__WINDOWS = EMFProperties.list((EStructuralFeature)BasicPackageImpl.Literals.WINDOW__WINDOWS);
    private IListProperty ELEMENT_CONTAINER__CHILDREN = EMFProperties.list((EStructuralFeature)UiPackageImpl.Literals.ELEMENT_CONTAINER__CHILDREN);
    private IListProperty SHARED_ELEMENTS = EMFProperties.list((EStructuralFeature)BasicPackageImpl.Literals.WINDOW__SHARED_ELEMENTS);
    private IValueProperty WINDOW__MAIN_MENU = EMFProperties.value((EStructuralFeature)BasicPackageImpl.Literals.WINDOW__MAIN_MENU);
    private Action addMainMenu;
    private Button createRemoveMainMenu;
    private EStackLayout stackLayout;

    public WindowEditor(EditingDomain editingDomain, ModelEditor editor, IProject project, IResourcePool resourcePool) {
        super(editingDomain, editor, resourcePool);
        this.project = project;
        this.addMainMenu = new Action(Messages.WindowEditor_AddMainMenu){

            public void run() {
                WindowEditor.this.addMenu();
            }
        };
    }

    @Override
    public Image getImage(Object element, Display display) {
        if (element instanceof MUIElement) {
            MUIElement uiElement = (MUIElement)element;
            if (uiElement.isToBeRendered() && uiElement.isVisible()) {
                return this.createImage("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Window");
            }
            return this.createImage("IMG_org.eclipse.e4.tools.emf.ui.modelelements.tbr.Window");
        }
        return null;
    }

    @Override
    public String getLabel(Object element) {
        return Messages.WindowEditor_TreeLabel;
    }

    @Override
    public String getDescription(Object element) {
        return Messages.WindowEditor_TreeLabelDescription;
    }

    @Override
    public Composite getEditor(Composite parent, Object object) {
        Control topControl;
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            if (this.getEditor().isModelFragment()) {
                this.composite = new Composite(parent, 0);
                this.stackLayout = new EStackLayout();
                this.composite.setLayout((Layout)this.stackLayout);
                this.createForm(this.composite, this.context, this.getMaster(), false);
                this.createForm(this.composite, this.context, this.getMaster(), true);
            } else {
                this.composite = this.createForm(parent, this.context, this.getMaster(), false);
            }
        }
        if (this.getEditor().isModelFragment() && this.stackLayout.topControl != (topControl = Util.isImport((EObject)object) ? this.composite.getChildren()[1] : this.composite.getChildren()[0])) {
            this.stackLayout.topControl = topControl;
            this.composite.layout(true, true);
        }
        if (this.createRemoveMainMenu != null) {
            this.createRemoveMainMenu.setSelection(((MWindow)object).getMainMenu() != null);
        }
        this.getMaster().setValue(object);
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master, boolean isImport) {
        parent = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.horizontalSpacing = 10;
        parent.setLayout((Layout)gl);
        if (this.getEditor().isShowXMIId() || this.getEditor().isLiveModel()) {
            ControlFactory.createXMIId(parent, this);
        }
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        if (isImport) {
            ControlFactory.createFindImport(parent, this, context);
            return parent;
        }
        Label l = new Label(parent, 0);
        l.setText(Messages.ModelTooling_Common_Id);
        l.setLayoutData((Object)new GridData(128));
        Text t = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__ELEMENT_ID).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_X);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)BasicPackageImpl.Literals.WINDOW__X).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_Y);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)BasicPackageImpl.Literals.WINDOW__Y).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_Width);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)BasicPackageImpl.Literals.WINDOW__WIDTH).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_Height);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)BasicPackageImpl.Literals.WINDOW__HEIGHT).observeDetail((IObservableValue)this.getMaster()));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_Label);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_LABEL__LABEL).observeDetail((IObservableValue)master));
        ControlFactory.createTextField(parent, Messages.ModelTooling_UIElement_AccessibilityPhrase, (IObservableValue)this.getMaster(), context, textProp, EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__ACCESSIBILITY_PHRASE));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_Tooltip);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        t.setLayoutData((Object)gd);
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_LABEL__TOOLTIP).observeDetail((IObservableValue)master));
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_IconURI);
        l.setLayoutData((Object)new GridData(128));
        t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        context.bindValue((IObservableValue)textProp.observeDelayed(200, (Widget)t), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_LABEL__ICON_URI).observeDetail((IObservableValue)master));
        new ImageTooltip((Control)t){

            protected URI getImageURI() {
                MUILabel part = (MUILabel)WindowEditor.this.getMaster().getValue();
                String uri = part.getIconURI();
                if (uri == null || uri.trim().length() == 0) {
                    return null;
                }
                return URI.createURI((String)part.getIconURI());
            }
        };
        final Button b = new Button(parent, 0x800008);
        b.setText(Messages.ModelTooling_Common_FindEllipsis);
        b.setImage(this.createImage("IMG_org.eclipse.e4.tools.emf.ui.obj16.zoom"));
        b.setLayoutData((Object)new GridData(4, 2, false, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowIconDialogEditor dialog = new WindowIconDialogEditor(b.getShell(), WindowEditor.this.project, WindowEditor.this.getEditingDomain(), (MWindow)WindowEditor.this.getMaster().getValue());
                dialog.open();
            }
        });
        l = new Label(parent, 0);
        l.setText(Messages.WindowEditor_MainMenu);
        l.setLayoutData((Object)new GridData(128));
        this.createRemoveMainMenu = new Button(parent, 32);
        this.createRemoveMainMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MWindow window = (MWindow)WindowEditor.this.getMaster().getValue();
                if (window.getMainMenu() == null) {
                    WindowEditor.this.addMenu();
                } else {
                    WindowEditor.this.removeMenu();
                }
            }
        });
        this.createRemoveMainMenu.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        ControlFactory.createCheckBox(parent, "To Be Rendered", (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED));
        ControlFactory.createCheckBox(parent, "Visible", (IObservableValue)this.getMaster(), context, WidgetProperties.selection(), EMFEditProperties.value((EditingDomain)this.getEditingDomain(), (EStructuralFeature)UiPackageImpl.Literals.UI_ELEMENT__VISIBLE));
        ControlFactory.createSelectedElement(parent, this, context, Messages.WindowEditor_SelectedElement);
        ControlFactory.createStringListWidget(parent, this, Messages.WindowEditor_BindingContexts, (EStructuralFeature)CommandsPackageImpl.Literals.BINDINGS__BINDING_CONTEXTS, 10);
        ControlFactory.createMapProperties(parent, this, Messages.ModelTooling_Context_Properties, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__PROPERTIES, 10);
        ControlFactory.createStringListWidget(parent, this, Messages.ModelTooling_Context_Variables, (EStructuralFeature)UiPackageImpl.Literals.CONTEXT__VARIABLES, 10);
        ControlFactory.createStringListWidget(parent, this, Messages.ModelTooling_ApplicationElement_Tags, (EStructuralFeature)ApplicationPackageImpl.Literals.APPLICATION_ELEMENT__TAGS, 10);
        return parent;
    }

    void removeMenu() {
        Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.WINDOW__MAIN_MENU, null);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    void addMenu() {
        MMenu menu = MMenuFactory.INSTANCE.createMenu();
        this.setElementId(menu);
        Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.WINDOW__MAIN_MENU, (Object)menu);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
        }
    }

    @Override
    public IObservableList getChildList(final Object element) {
        final WritableList list = new WritableList();
        if (this.getEditor().isModelFragment() && Util.isImport((EObject)element)) {
            return list;
        }
        list.add((Object)new VirtualEntry<Object>(ModelEditor.VIRTUAL_HANDLER, this.HANDLER_CONTAINER__HANDLERS, element, Messages.WindowEditor_Handlers){

            @Override
            protected boolean accepted(Object o) {
                return true;
            }
        });
        list.add((Object)new VirtualEntry<Object>(ModelEditor.VIRTUAL_WINDOWS, this.WINDOW__WINDOWS, element, Messages.WindowEditor_Windows){

            @Override
            protected boolean accepted(Object o) {
                return true;
            }
        });
        list.add((Object)new VirtualEntry<Object>(ModelEditor.VIRTUAL_WINDOW_CONTROLS, this.ELEMENT_CONTAINER__CHILDREN, element, Messages.WindowEditor_Controls){

            @Override
            protected boolean accepted(Object o) {
                return true;
            }
        });
        list.add((Object)new VirtualEntry<Object>(ModelEditor.VIRTUAL_WINDOW_SHARED_ELEMENTS, this.SHARED_ELEMENTS, element, Messages.WindowEditor_SharedElements){

            @Override
            protected boolean accepted(Object o) {
                return true;
            }
        });
        MWindow window = (MWindow)element;
        if (window.getMainMenu() != null) {
            list.add(0, (Object)window.getMainMenu());
        }
        this.WINDOW__MAIN_MENU.observe(element).addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                if (event.diff.getOldValue() != null) {
                    list.remove(event.diff.getOldValue());
                    if (WindowEditor.this.getMaster().getValue() == element && !WindowEditor.this.createRemoveMainMenu.isDisposed()) {
                        WindowEditor.this.createRemoveMainMenu.setSelection(false);
                    }
                }
                if (event.diff.getNewValue() != null) {
                    list.add(0, event.diff.getNewValue());
                    if (WindowEditor.this.getMaster().getValue() == element && !WindowEditor.this.createRemoveMainMenu.isDisposed()) {
                        WindowEditor.this.createRemoveMainMenu.setSelection(true);
                    }
                }
            }
        });
        return list;
    }

    @Override
    public String getDetailLabel(Object element) {
        MWindow window = (MWindow)element;
        if (window.getLabel() != null && window.getLabel().trim().length() > 0) {
            return window.getLabel();
        }
        return null;
    }

    @Override
    public FeaturePath[] getLabelProperties() {
        return new FeaturePath[]{FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_LABEL__LABEL}), FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{UiPackageImpl.Literals.UI_ELEMENT__TO_BE_RENDERED})};
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> actions = new ArrayList<Action>();
        MWindow window = (MWindow)element;
        if (window.getMainMenu() == null) {
            actions.add(this.addMainMenu);
        }
        return actions;
    }
}

