/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import javax.inject.Inject;
import javax.inject.Singleton;
import junit.framework.TestCase;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.extensions.EventUtils;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.tests.Activator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.event.EventAdmin;

public class InjectionEventTest
extends TestCase {
    protected static boolean testFailed = false;
    private EventAdminHelper helper;

    protected void setUp() throws Exception {
        super.setUp();
        this.ensureEventAdminStarted();
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IEclipseContext localContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
        this.helper = (EventAdminHelper)ContextInjectionFactory.make(EventAdminHelper.class, (IEclipseContext)localContext);
    }

    public void testEventInjection() {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Realm.class, (Object)SWTObservables.getRealm((Display)Display.getDefault()));
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        InjectionEventTest.assertEquals((int)0, (int)target.counter1);
        InjectionEventTest.assertNull((Object)target.string1);
        InjectionEventTest.assertEquals((int)0, (int)target.counter2);
        InjectionEventTest.assertNull((Object)target.string2);
        InjectionEventTest.assertEquals((int)1, (int)target.counter3);
        InjectionEventTest.assertNull((Object)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "event1data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        InjectionEventTest.assertEquals((int)0, (int)target.counter2);
        InjectionEventTest.assertNull((Object)target.string2);
        InjectionEventTest.assertEquals((int)1, (int)target.counter3);
        InjectionEventTest.assertNull((Object)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event2", "event2data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        InjectionEventTest.assertEquals((int)1, (int)target.counter2);
        InjectionEventTest.assertEquals((String)"event2data", (String)target.string2);
        InjectionEventTest.assertEquals((int)1, (int)target.counter3);
        InjectionEventTest.assertNull((Object)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event3", "event3data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        InjectionEventTest.assertEquals((int)1, (int)target.counter2);
        InjectionEventTest.assertEquals((String)"event2data", (String)target.string2);
        InjectionEventTest.assertEquals((int)2, (int)target.counter3);
        InjectionEventTest.assertEquals((String)"event3data", (String)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
        this.helper.sendEvent("e4/test/event1", "abc");
        InjectionEventTest.assertEquals((int)2, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"abc", (String)target.string1);
        InjectionEventTest.assertEquals((int)1, (int)target.counter2);
        InjectionEventTest.assertEquals((String)"event2data", (String)target.string2);
        InjectionEventTest.assertEquals((int)2, (int)target.counter3);
        InjectionEventTest.assertEquals((String)"event3data", (String)target.string3);
        InjectionEventTest.assertNotNull((Object)target.myBinding);
    }

    public void testEventInjectionUnsubscribe() {
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(MyBinding.class);
        this.wrapSetup();
        System.gc();
        System.runFinalization();
        System.gc();
        this.helper.sendEvent("e4/test/event1", "wrong");
        InjectionEventTest.assertFalse((boolean)testFailed);
    }

    public void testInjectWildCard() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Realm.class, (Object)SWTObservables.getRealm((Display)Display.getDefault()));
        InjectStarEvent target = (InjectStarEvent)ContextInjectionFactory.make(InjectStarEvent.class, (IEclipseContext)context);
        InjectionEventTest.assertEquals((int)0, (int)target.counter1);
        InjectionEventTest.assertNull((Object)target.data);
        this.helper.sendEvent("e4/test/eventInjection", "sample");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"sample", (String)target.data);
    }

    private void wrapSetup() {
        IEclipseContext context = EclipseContextFactory.create();
        InjectTarget target = (InjectTarget)ContextInjectionFactory.make(InjectTarget.class, (IEclipseContext)context);
        this.helper.sendEvent("e4/test/event1", "event1data");
        InjectionEventTest.assertEquals((int)1, (int)target.counter1);
        InjectionEventTest.assertEquals((String)"event1data", (String)target.string1);
        target.valid = false;
    }

    private void ensureEventAdminStarted() {
        if (Activator.getDefault().getEventAdmin() == null) {
            Bundle[] bundles;
            Bundle[] bundleArray = bundles = Activator.getDefault().getBundle().getBundleContext().getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if ("org.eclipse.equinox.event".equals(bundle.getSymbolicName())) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    public static class EventAdminHelper {
        @Inject
        public EventAdmin eventAdmin;

        public void sendEvent(String topic, Object data) {
            EventUtils.send((EventAdmin)this.eventAdmin, (String)topic, (Object)data);
        }
    }

    static class InjectStarEvent {
        public int counter1 = 0;
        public String data;

        InjectStarEvent() {
        }

        @Inject
        @Optional
        public void receivedEvent1(@UIEventTopic(value="e4/test/*") String data) {
            ++this.counter1;
            this.data = data;
        }
    }

    static class InjectTarget {
        public int counter1 = 0;
        public int counter2 = 0;
        public int counter3 = 0;
        public String string1;
        public String string2;
        public String string3;
        public boolean valid = true;
        public MyBinding myBinding;

        InjectTarget() {
        }

        public void resetCounters() {
            this.counter3 = 0;
            this.counter2 = 0;
            this.counter1 = 0;
        }

        @Inject
        @Optional
        public void receivedEvent1(@EventTopic(value="e4/test/event1") String string1) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter1;
            this.string1 = string1;
        }

        @Inject
        @Optional
        public void receivedEvent2(@UIEventTopic(value="e4/test/event2") String string2) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter2;
            this.string2 = string2;
        }

        @Inject
        public void receivedOptionalEvent(MyBinding myBinding, @Optional @EventTopic(value="e4/test/event3") String string3) {
            if (!this.valid) {
                testFailed = true;
            }
            ++this.counter3;
            this.myBinding = myBinding;
            this.string3 = string3;
        }
    }

    @Singleton
    static class MyBinding {
        MyBinding() {
        }
    }
}

