/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.URIHelper;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.impl.FragmentPackageImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelAssembler {
    @Inject
    private Logger logger;
    @Inject
    private MApplication application;
    @Inject
    private IEclipseContext context;
    private static final String extensionPointID = "org.eclipse.e4.workbench.model";

    public void processModel() {
        IConfigurationElement ce;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] ces;
        IExtension extension;
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extPoint = registry.getExtensionPoint(extensionPointID);
        IExtension[] extensions = this.topoSort(extPoint.getExtensions());
        ArrayList<MApplicationElement> imports = new ArrayList<MApplicationElement>();
        ArrayList<MApplicationElement> addedElements = new ArrayList<MApplicationElement>();
        E4XMIResource applicationResource = (E4XMIResource)((EObject)this.application).eResource();
        ResourceSet resourceSet = applicationResource.getResourceSet();
        IExtension[] iExtensionArray = extensions;
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = ces = extension.getConfigurationElements();
            n2 = ces.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if ("processor".equals(ce.getName()) && Boolean.parseBoolean(ce.getAttribute("beforefragment"))) {
                    this.runProcessor(ce);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = ces = extension.getConfigurationElements();
            n2 = ces.length;
            n = 0;
            while (n < n2) {
                block23: {
                    ce = iConfigurationElementArray[n];
                    if ("fragment".equals(ce.getName())) {
                        IContributor contributor = ce.getContributor();
                        String attrURI = ce.getAttribute("uri");
                        if (attrURI == null) {
                            this.logger.warn("Unable to find location for the model extension \"{0}\"", (Object)contributor.getName());
                        } else {
                            Resource resource;
                            URI uri;
                            String bundleName = contributor.getName();
                            String path = String.valueOf(bundleName) + '/' + attrURI;
                            try {
                                uri = URI.createPlatformPluginURI((String)path, (boolean)false);
                            }
                            catch (RuntimeException e) {
                                this.logger.warn((Throwable)e, "Model extension has invalid location");
                                break block23;
                            }
                            String contributorURI = URIHelper.constructPlatformURI(contributor);
                            try {
                                resource = resourceSet.getResource(uri, true);
                            }
                            catch (RuntimeException e) {
                                this.logger.warn((Throwable)e, "Unable to read model extension");
                                break block23;
                            }
                            EList contents = resource.getContents();
                            if (!contents.isEmpty()) {
                                Object extensionRoot = contents.get(0);
                                if (!(extensionRoot instanceof MModelFragments)) {
                                    this.logger.warn("Unable to create model extension \"{0}\"", (Object)contributor.getName());
                                } else {
                                    List localImports;
                                    MModelFragments fragmentsContainer = (MModelFragments)extensionRoot;
                                    List fragments = fragmentsContainer.getFragments();
                                    boolean evalImports = false;
                                    for (MModelFragment fragment : fragments) {
                                        List elements = fragment.getElements();
                                        if (elements.size() == 0) continue;
                                        for (MApplicationElement el : elements) {
                                            EObject o = (EObject)el;
                                            E4XMIResource r = (E4XMIResource)o.eResource();
                                            applicationResource.setID(o, r.getID(o));
                                            TreeIterator treeIt = EcoreUtil.getAllContents((EObject)o, (boolean)true);
                                            while (treeIt.hasNext()) {
                                                EObject eObj = (EObject)treeIt.next();
                                                r = (E4XMIResource)eObj.eResource();
                                                if (contributorURI != null && eObj instanceof MApplicationElement) {
                                                    ((MApplicationElement)eObj).setContributorURI(contributorURI);
                                                }
                                                applicationResource.setID(eObj, r.getInternalId(eObj));
                                            }
                                        }
                                        List merged = fragment.merge(this.application);
                                        if (merged.size() <= 0) continue;
                                        evalImports = true;
                                        addedElements.addAll(merged);
                                    }
                                    if (evalImports && (localImports = fragmentsContainer.getImports()) != null) {
                                        imports.addAll(localImports);
                                    }
                                }
                            }
                        }
                    }
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = ces = extension.getConfigurationElements();
            n2 = ces.length;
            n = 0;
            while (n < n2) {
                ce = iConfigurationElementArray[n];
                if ("processor".equals(ce.getName()) && !Boolean.parseBoolean(ce.getAttribute("beforefragment"))) {
                    this.runProcessor(ce);
                }
                ++n;
            }
            ++n4;
        }
        this.resolveImports(imports, addedElements);
    }

    private void runProcessor(IConfigurationElement ce) {
        IEclipseContext localContext = this.context.createChild();
        IContributionFactory factory = (IContributionFactory)localContext.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren("element");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ceEl = iConfigurationElementArray[n2];
            String id = ceEl.getAttribute("id");
            if (id == null) {
                this.logger.warn("No element id given");
            } else {
                MApplicationElement el;
                String key = ceEl.getAttribute("contextKey");
                if (key == null) {
                    key = id;
                }
                if ((el = ModelAssembler.findElementById((MApplicationElement)this.application, id)) == null) {
                    this.logger.warn("Could not find element with id '" + id + "'");
                }
                localContext.set(key, (Object)el);
            }
            ++n2;
        }
        try {
            Object o = factory.create("platform:/plugin/" + ce.getContributor().getName() + "/" + ce.getAttribute("class"), localContext);
            ContextInjectionFactory.invoke((Object)o, Execute.class, (IEclipseContext)localContext);
            localContext.dispose();
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e, "Could not run processor");
        }
    }

    private void resolveImports(List<MApplicationElement> imports, List<MApplicationElement> addedElements) {
        if (imports.isEmpty()) {
            return;
        }
        HashMap<MApplicationElement, MApplicationElement> importMaps = new HashMap<MApplicationElement, MApplicationElement>();
        for (MApplicationElement importedElement : imports) {
            MApplicationElement mApplicationElement = ModelAssembler.findElementById((MApplicationElement)this.application, importedElement.getElementId());
            if (mApplicationElement == null) {
                this.logger.warn("Could not resolve an import element for '" + mApplicationElement + "'");
            }
            importMaps.put(importedElement, mApplicationElement);
        }
        TreeIterator it = EcoreUtil.getAllContents(addedElements);
        ArrayList<1> commands = new ArrayList<1>();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject importObject = (EObject)featureIterator.next();
                if (importObject.eContainmentFeature() != FragmentPackageImpl.Literals.MODEL_FRAGMENTS__IMPORTS) continue;
                EStructuralFeature feature = featureIterator.feature();
                MApplicationElement el = (MApplicationElement)importMaps.get(importObject);
                if (el == null) {
                    this.logger.warn("Could not resolve import for " + el);
                }
                final EObject interalTarget = eObject;
                final EStructuralFeature internalFeature = feature;
                final MApplicationElement internalElment = el;
                final EObject internalImportObject = importObject;
                commands.add(new Runnable(){

                    public void run() {
                        if (internalFeature.isMany()) {
                            System.err.println("Replacing");
                            List l = (List)interalTarget.eGet(internalFeature);
                            int index = l.indexOf(internalImportObject);
                            if (index >= 0) {
                                l.set(index, internalElment);
                            }
                        } else {
                            interalTarget.eSet(internalFeature, (Object)internalElment);
                        }
                    }
                });
            }
        }
        for (Runnable runnable : commands) {
            runnable.run();
        }
    }

    private IExtension[] topoSort(IExtension[] extensions) {
        if (extensions.length == 0) {
            return extensions;
        }
        PackageAdmin admin = Activator.getDefault().getBundleAdmin();
        HashMap<String, ArrayList<IExtension>> mappedExtensions = new HashMap<String, ArrayList<IExtension>>();
        final HashMap requires = new HashMap();
        HashMap depends = new HashMap();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IContributor contributor = extension.getContributor();
            ArrayList<IExtension> exts = (ArrayList<IExtension>)mappedExtensions.get(contributor.getName());
            if (exts == null) {
                exts = new ArrayList<IExtension>();
                mappedExtensions.put(contributor.getName(), exts);
            }
            exts.add(extension);
            requires.put(contributor.getName(), new HashSet());
            depends.put(contributor.getName(), new HashSet());
            ++n2;
        }
        for (String bundleId : mappedExtensions.keySet()) {
            assert (requires.containsKey(bundleId) && depends.containsKey(bundleId));
            RequiredBundle[] requiredBundleArray = admin.getRequiredBundles(bundleId);
            int contributor = requiredBundleArray.length;
            int n3 = 0;
            while (n3 < contributor) {
                RequiredBundle requiredBundle = requiredBundleArray[n3];
                assert (requiredBundle.getSymbolicName().equals(bundleId));
                Bundle[] bundleArray = requiredBundle.getRequiringBundles();
                int n4 = bundleArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Bundle dependentBundle = bundleArray[n5];
                    if (mappedExtensions.containsKey(dependentBundle.getSymbolicName())) {
                        String depBundleId = dependentBundle.getSymbolicName();
                        Collection depBundleReqs = (Collection)requires.get(depBundleId);
                        depBundleReqs.add(bundleId);
                        Collection bundleDeps = (Collection)depends.get(bundleId);
                        assert (bundleDeps != null);
                        bundleDeps.add(depBundleId);
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        int resultIndex = 0;
        ArrayList sortedByOutdegree = new ArrayList(requires.keySet());
        Comparator<String> outdegreeSorter = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (!($assertionsDisabled || requires.containsKey(o1) && requires.containsKey(o2))) {
                    throw new AssertionError();
                }
                return ((Collection)requires.get(o1)).size() - ((Collection)requires.get(o2)).size();
            }
        };
        Collections.sort(sortedByOutdegree, outdegreeSorter);
        if (!((Collection)requires.get(sortedByOutdegree.get(0))).isEmpty()) {
            this.logger.warn("Extensions have a cycle");
        }
        while (!sortedByOutdegree.isEmpty()) {
            if (!((Collection)depends.get(sortedByOutdegree.get(0))).isEmpty()) {
                Collections.sort(sortedByOutdegree, outdegreeSorter);
            }
            String bundleId = (String)sortedByOutdegree.remove(0);
            assert (depends.containsKey(bundleId) && requires.containsKey(bundleId));
            for (IExtension ext : (Collection)mappedExtensions.get(bundleId)) {
                extensions[resultIndex++] = ext;
            }
            assert (((Collection)requires.get(bundleId)).isEmpty());
            requires.remove(bundleId);
            for (String depId : (Collection)depends.get(bundleId)) {
                ((Collection)requires.get(depId)).remove(bundleId);
            }
            depends.remove(bundleId);
        }
        assert (resultIndex == extensions.length);
        return extensions;
    }

    private static MApplicationElement findElementById(MApplicationElement element, String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        if (id.equals(element.getElementId())) {
            return element;
        }
        EList elements = ((EObject)element).eContents();
        for (EObject childElement : elements) {
            MApplicationElement result;
            if (!(childElement instanceof MApplicationElement) || (result = ModelAssembler.findElementById((MApplicationElement)childElement, id)) == null) continue;
            return result;
        }
        return null;
    }
}

