/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Exif {
    IFD[] ifds;
    private String make;
    private String model;
    private Integer orientation;
    private String software;
    private String timestamp;
    private String exposure;
    private Integer iso;
    private Double aperture;
    private String exposureComp;
    private Boolean flash;
    private Integer width;
    private Integer height;
    private Double focalLength;
    private Integer whiteBalance;
    private String lightSource;
    private String exposureProgram;
    private String gpsLatitude;
    private String gpsLongitude;
    private final String name;
    private URI uri;
    public String gpsLatitudeRef;
    public String gpsLongitudeRef;

    public URI getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getMake() {
        return this.make;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getOrientation() {
        return this.orientation;
    }

    public String getSoftware() {
        return this.software;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getExposure() {
        return this.exposure;
    }

    public Integer getIso() {
        return this.iso;
    }

    public Double getAperture() {
        return this.aperture;
    }

    public String getExposureComp() {
        return this.exposureComp;
    }

    public Boolean getFlash() {
        return this.flash;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Double getFocalLength() {
        return this.focalLength;
    }

    public Integer getWhiteBalance() {
        return this.whiteBalance;
    }

    public String getLightSource() {
        return this.lightSource;
    }

    public String getExposureProgram() {
        return this.exposureProgram;
    }

    public String getGpsLatitude() {
        if (this.gpsLatitude == null) {
            return null;
        }
        return String.valueOf("S".equals(this.gpsLatitudeRef) ? "-" : "") + this.gpsLatitude;
    }

    public String getGpsLongitude() {
        if (this.gpsLongitude == null) {
            return null;
        }
        return String.valueOf("W".equals(this.gpsLongitudeRef) ? "-" : "") + this.gpsLongitude;
    }

    public Exif(URI uri, InputStream is) throws IOException {
        this.uri = uri;
        this.name = this.getName(uri);
        this.read(is, false);
    }

    private String getName(URI uri) {
        String result = uri.getPath();
        int indexOfSlash = result.lastIndexOf(47);
        if (indexOfSlash != -1) {
            result = result.substring(indexOfSlash + 1);
        }
        return result;
    }

    public Exif(String name, InputStream is) throws IOException {
        this.name = name;
        this.read(is, false);
    }

    public Exif(String name, InputStream is, boolean storeIFDs) throws IOException {
        this.name = name;
        this.read(is, storeIFDs);
    }

    private void read(InputStream is, boolean storeIFDs) throws IOException {
        try {
            if (is.read() != 255) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 216) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 255) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 225) {
                throw new IllegalArgumentException("Not Exif");
            }
            int lengthH = is.read() & 0xFF;
            if (lengthH == -1) {
                throw new IllegalArgumentException("Unexpected EOF");
            }
            int lengthL = is.read() & 0xFF;
            if (lengthL == -1) {
                throw new IllegalArgumentException("Unexpected EOF");
            }
            int length = (lengthH << 8) + lengthL;
            if (is.read() != 69) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 120) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 105) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 102) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 0) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (is.read() != 0) {
                throw new IllegalArgumentException("Not Exif");
            }
            byte[] tiff_data = this.readBytes(is, length - 8);
            char endian = (char)tiff_data[0];
            int ifd_offset = this.readInt(tiff_data, 4, 4, endian);
            ArrayList<IFD> ifds = new ArrayList<IFD>();
            while (ifd_offset != 0) {
                IFD ifd = new IFD();
                ifd_offset = this.readIFD(ifd, tiff_data, ifd_offset, endian);
                Entry[] entryArray = ifd.entries;
                int n = ifd.entries.length;
                int n2 = 0;
                while (n2 < n) {
                    Entry entry = entryArray[n2];
                    entry.applyValue(this, false);
                    if ((entry.tag == 34665 || entry.tag == 34853) && entry.data[0] instanceof IFD) {
                        IFD subIFD = (IFD)entry.data[0];
                        Entry[] entryArray2 = subIFD.entries;
                        int n3 = subIFD.entries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Entry subEntry = entryArray2[n4];
                            subEntry.applyValue(this, entry.tag == 34853);
                            ++n4;
                        }
                    }
                    ++n2;
                }
                ifds.add(ifd);
            }
            if (storeIFDs) {
                this.ifds = ifds.toArray(new IFD[ifds.size()]);
            }
        }
        finally {
            is.close();
        }
    }

    private int readIFD(IFD ifd, byte[] data, int offset, char endian) {
        int numEntries = this.readInt(data, offset, 2, endian);
        offset += 2;
        ifd.entries = new Entry[numEntries];
        int i = 0;
        while (i < numEntries) {
            IFD subIFD;
            int subOffset;
            Entry entry = this.readEntry(data, offset, endian);
            offset += 12;
            ifd.entries[i] = entry;
            if (entry.tag == 34665) {
                subOffset = (Integer)entry.data[0];
                if (subOffset < data.length) {
                    subIFD = new IFD();
                    this.readIFD(subIFD, data, subOffset, endian);
                    entry.data[0] = subIFD;
                }
            } else if (entry.tag == 34853 && (subOffset = ((Integer)entry.data[0]).intValue()) < data.length) {
                subIFD = new IFD();
                this.readIFD(subIFD, data, subOffset, endian);
                entry.data[0] = subIFD;
            }
            ++i;
        }
        return 0;
    }

    private Entry readEntry(byte[] data, int offset, char endian) {
        int tag = this.readInt(data, offset, 2, endian);
        int format = this.readInt(data, offset + 2, 2, endian);
        int numComponents = this.readInt(data, offset + 4, 4, endian);
        Object[] values = new Object[numComponents];
        int bytesPerComponent = (new int[]{-1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8})[format];
        offset = numComponents * bytesPerComponent > 4 ? this.readInt(data, offset + 8, 4, endian) : (offset += 8);
        if (format == 7) {
            values = new Object[1];
        } else if (format == 2) {
            values = new Object[]{new String(data, offset, numComponents - 1)};
        } else {
            int i = 0;
            while (i < numComponents) {
                switch (format) {
                    case 1: {
                        values[i] = new Byte(data[offset]);
                        break;
                    }
                    case 3: {
                        values[i] = new Integer(this.readInt(data, offset, 2, endian));
                        break;
                    }
                    case 4: {
                        values[i] = new Integer(this.readInt(data, offset, 4, endian));
                        break;
                    }
                    case 5: {
                        values[i] = new Fraction(this.readInt(data, offset, 4, endian), this.readInt(data, offset + 4, 4, endian));
                        break;
                    }
                    case 6: {
                        values[i] = new Byte(data[offset]);
                        break;
                    }
                    case 7: {
                        values[i] = new Byte(data[offset]);
                        break;
                    }
                    case 8: {
                        values[i] = new Integer(this.readInt(data, offset, 2, endian));
                        break;
                    }
                    case 9: {
                        values[i] = new Integer(this.readInt(data, offset, 4, endian));
                        break;
                    }
                    case 10: {
                        values[i] = new Fraction(this.readInt(data, offset, 4, endian), this.readInt(data, offset + 4, 4, endian));
                        break;
                    }
                    case 11: {
                        values[i] = new Float(Float.intBitsToFloat(this.readInt(data, offset, 4, endian)));
                        break;
                    }
                    case 12: {
                        values[i] = new Float(Float.intBitsToFloat(this.readInt(data, offset, 8, endian)));
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected case");
                    }
                }
                offset += bytesPerComponent;
                ++i;
            }
        }
        return new Entry(tag, format, values);
    }

    private int readInt(byte[] data, int offset, int length, char endian) {
        if (endian == 'M') {
            int result = 0;
            int i = 0;
            while (i < length) {
                result <<= 8;
                result |= data[offset + i] & 0xFF;
                ++i;
            }
            return result;
        }
        int result = 0;
        int i = length - 1;
        while (i >= 0) {
            result <<= 8;
            result |= data[offset + i] & 0xFF;
            --i;
        }
        return result;
    }

    private byte[] readBytes(InputStream is, int n) throws IOException {
        int read;
        byte[] result = new byte[n];
        int index = 0;
        while ((read = is.read(result, index, n)) > 0) {
            n -= read;
            index += read;
        }
        if (n > 0) {
            throw new IOException("Could only read " + read + " bytes but expected " + n + " more.");
        }
        return result;
    }

    public static void main(String ... args) throws FileNotFoundException, IOException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String filename = args[0];
        File file = new File(filename);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            ArrayList<Exif> exifs = new ArrayList<Exif>();
            int i = 0;
            while (i < files.length) {
                try {
                    exifs.add(new Exif(files[i].getName(), (InputStream)new FileInputStream(files[i])));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("skipping " + files[i].getName());
                }
                ++i;
            }
            Exif.displayExifs(exifs.toArray(new Exif[exifs.size()]));
            return;
        }
        Exif exif = new Exif(filename, new FileInputStream(filename), true);
        exif.printStuff();
    }

    private static void displayExifs(Exif[] exifs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)shell, 65540);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] columns = new String[]{"Name", "Make", "Model", "Orientation", "Software", "Timestamp", "Exposure", "Iso", "Aperture", "ExposureComp", "Flash", "Width", "Height", "FocalLength", "WhiteBalance", "LightSource", "ExposureProgram"};
        Method[] columnMethods = new Method[columns.length];
        int i = 0;
        while (i < columns.length) {
            new TableColumn(table, 0).setText(columns[i]);
            columnMethods[i] = Exif.class.getDeclaredMethod("get" + columns[i], new Class[0]);
            ++i;
        }
        i = 0;
        while (i < exifs.length) {
            Exif exif = exifs[i];
            TableItem item = new TableItem(table, 0);
            int j = 0;
            while (j < columnMethods.length) {
                item.setText(j, "" + columnMethods[j].invoke((Object)exif, new Object[0]));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < table.getColumnCount()) {
            table.getColumn(i).pack();
            ++i;
        }
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void printStuff() {
        IFD[] iFDArray = this.ifds;
        int n = this.ifds.length;
        int n2 = 0;
        while (n2 < n) {
            IFD ifd = iFDArray[n2];
            System.out.println("---IFD---");
            Entry[] entryArray = ifd.entries;
            int n3 = ifd.entries.length;
            int n4 = 0;
            while (n4 < n3) {
                Entry entry = entryArray[n4];
                System.out.println(entry);
                if ((entry.tag == 34665 || entry.tag == 34853) && entry.data[0] instanceof IFD) {
                    System.out.println("---Sub-IFD---");
                    IFD subIFD = (IFD)entry.data[0];
                    Entry[] entryArray2 = subIFD.entries;
                    int n5 = subIFD.entries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Entry subEntry = entryArray2[n6];
                        System.out.println(subEntry);
                        ++n6;
                    }
                    System.out.println("---End-Sub---");
                }
                ++n4;
            }
            ++n2;
        }
    }

    static class Entry {
        int tag;
        int format;
        Object[] data;

        Entry(int tag, int format, Object[] data) {
            this.tag = tag;
            this.format = format;
            this.data = data;
        }

        void applyValue(Exif exif, boolean gpsInfo) {
            block0 : switch (this.tag) {
                case 1: {
                    if (!gpsInfo) break;
                    exif.gpsLatitudeRef = (String)this.data[0];
                    break;
                }
                case 2: {
                    if (!gpsInfo) break;
                    double degrees = ((Fraction)this.data[0]).toDouble();
                    double minutes = ((Fraction)this.data[1]).toDouble();
                    double seconds = ((Fraction)this.data[2]).toDouble();
                    if (seconds == 0.0) {
                        exif.gpsLatitude = String.valueOf((int)degrees) + "\u00b0" + minutes + "'";
                        break;
                    }
                    exif.gpsLatitude = String.valueOf((int)degrees) + "\u00b0" + (int)minutes + "'" + (int)seconds + "\"";
                    break;
                }
                case 3: {
                    if (!gpsInfo) break;
                    exif.gpsLongitudeRef = (String)this.data[0];
                    break;
                }
                case 4: {
                    if (!gpsInfo) break;
                    double degrees = ((Fraction)this.data[0]).toDouble();
                    double minutes = ((Fraction)this.data[1]).toDouble();
                    double seconds = ((Fraction)this.data[2]).toDouble();
                    if (seconds == 0.0) {
                        exif.gpsLongitude = String.valueOf((int)degrees) + "\u00b0" + minutes + "'";
                        break;
                    }
                    exif.gpsLongitude = String.valueOf((int)degrees) + "\u00b0" + (int)minutes + "'" + (int)seconds + "\"";
                    break;
                }
                case 271: {
                    exif.make = (String)this.data[0];
                    break;
                }
                case 272: {
                    exif.model = (String)this.data[0];
                    break;
                }
                case 274: {
                    exif.orientation = (Integer)this.data[0];
                    break;
                }
                case 305: {
                    exif.software = (String)this.data[0];
                    break;
                }
                case 306: {
                    exif.timestamp = (String)this.data[0];
                    break;
                }
                case 33434: {
                    exif.exposure = ((Fraction)this.data[0]).toFraction();
                    break;
                }
                case 33437: {
                    exif.aperture = ((Fraction)this.data[0]).toDouble();
                    break;
                }
                case 34850: {
                    switch ((Integer)this.data[0]) {
                        default: {
                            exif.exposureProgram = "Not defined";
                            break block0;
                        }
                        case 1: {
                            exif.exposureProgram = "Manual";
                            break block0;
                        }
                        case 2: {
                            exif.exposureProgram = "Normal program";
                            break block0;
                        }
                        case 3: {
                            exif.exposureProgram = "Aperture priority";
                            break block0;
                        }
                        case 4: {
                            exif.exposureProgram = "Shutter priority";
                            break block0;
                        }
                        case 5: {
                            exif.exposureProgram = "Creative program";
                            break block0;
                        }
                        case 6: {
                            exif.exposureProgram = "Action program";
                            break block0;
                        }
                        case 7: {
                            exif.exposureProgram = "Portrait mode";
                            break block0;
                        }
                        case 8: 
                    }
                    exif.exposureProgram = "Landscape mode";
                    break;
                }
                case 34855: {
                    exif.iso = (Integer)this.data[0];
                    break;
                }
                case 37380: {
                    exif.exposureComp = ((Fraction)this.data[0]).toFraction();
                    break;
                }
                case 37385: {
                    exif.flash = new Boolean(((Integer)this.data[0] & 1) != 0);
                    break;
                }
                case 37386: {
                    exif.focalLength = ((Fraction)this.data[0]).toDouble();
                    break;
                }
                case 40962: {
                    exif.width = (Integer)this.data[0];
                    break;
                }
                case 40963: {
                    exif.height = (Integer)this.data[0];
                    break;
                }
                case 41987: {
                    exif.whiteBalance = (Integer)this.data[0];
                    break;
                }
                case 37384: {
                    switch ((Integer)this.data[0]) {
                        default: {
                            exif.lightSource = "Unknown";
                            break block0;
                        }
                        case 1: {
                            exif.lightSource = "Daylight";
                            break block0;
                        }
                        case 2: {
                            exif.lightSource = "Fluorescent";
                            break block0;
                        }
                        case 3: {
                            exif.lightSource = "Tungsten (incandescent light)";
                            break block0;
                        }
                        case 4: {
                            exif.lightSource = "Flash";
                            break block0;
                        }
                        case 9: {
                            exif.lightSource = "Fine weather";
                            break block0;
                        }
                        case 10: {
                            exif.lightSource = "Cloudy weather";
                            break block0;
                        }
                        case 11: {
                            exif.lightSource = "Shade";
                            break block0;
                        }
                        case 12: {
                            exif.lightSource = "Daylight fluorescent (D 5700 - 7100K)";
                            break block0;
                        }
                        case 13: {
                            exif.lightSource = "Day white fluorescent (N 4600 - 5400K)";
                            break block0;
                        }
                        case 14: {
                            exif.lightSource = "Cool white fluorescent (W 3900 - 4500K)";
                            break block0;
                        }
                        case 15: {
                            exif.lightSource = "White fluorescent (WW 3200 - 3700K)";
                            break block0;
                        }
                        case 17: {
                            exif.lightSource = "Standard light A";
                            break block0;
                        }
                        case 18: {
                            exif.lightSource = "Standard light B";
                            break block0;
                        }
                        case 19: {
                            exif.lightSource = "Standard light C";
                            break block0;
                        }
                        case 20: {
                            exif.lightSource = "D55";
                            break block0;
                        }
                        case 21: {
                            exif.lightSource = "D65";
                            break block0;
                        }
                        case 22: {
                            exif.lightSource = "D75";
                            break block0;
                        }
                        case 23: {
                            exif.lightSource = "D50";
                            break block0;
                        }
                        case 24: {
                            exif.lightSource = "ISO studio tungsten";
                            break block0;
                        }
                        case 255: 
                    }
                    exif.lightSource = "Other light source";
                }
            }
        }

        public String toString() {
            String name = "unknown (" + this.tag + ")";
            switch (this.tag) {
                case 256: {
                    name = "ImageWidth";
                    break;
                }
                case 257: {
                    name = "ImageLength";
                    break;
                }
                case 258: {
                    name = "BitsPerSample";
                    break;
                }
                case 259: {
                    name = "Compression";
                    break;
                }
                case 262: {
                    name = "PhotometricInterpretation";
                    break;
                }
                case 266: {
                    name = "FillOrder";
                    break;
                }
                case 269: {
                    name = "DocumentName";
                    break;
                }
                case 270: {
                    name = "ImageDescription";
                    break;
                }
                case 271: {
                    name = "Make";
                    break;
                }
                case 272: {
                    name = "Model";
                    break;
                }
                case 273: {
                    name = "StripOffsets";
                    break;
                }
                case 274: {
                    name = "Orientation";
                    break;
                }
                case 277: {
                    name = "SamplesPerPixel";
                    break;
                }
                case 278: {
                    name = "RowsPerStrip";
                    break;
                }
                case 279: {
                    name = "StripByteCounts";
                    break;
                }
                case 282: {
                    name = "XResolution";
                    break;
                }
                case 283: {
                    name = "YResolution";
                    break;
                }
                case 284: {
                    name = "PlanarConfiguration";
                    break;
                }
                case 296: {
                    name = "ResolutionUnit";
                    break;
                }
                case 301: {
                    name = "TransferFunction";
                    break;
                }
                case 305: {
                    name = "Software";
                    break;
                }
                case 306: {
                    name = "DateTime";
                    break;
                }
                case 315: {
                    name = "Artist";
                    break;
                }
                case 318: {
                    name = "WhitePoint";
                    break;
                }
                case 319: {
                    name = "PrimaryChromaticities";
                    break;
                }
                case 342: {
                    name = "TransferRange";
                    break;
                }
                case 512: {
                    name = "JPEGProc";
                    break;
                }
                case 513: {
                    name = "JPEGInterchangeFormat";
                    break;
                }
                case 514: {
                    name = "JPEGInterchangeFormatLength";
                    break;
                }
                case 529: {
                    name = "YCbCrCoefficients";
                    break;
                }
                case 530: {
                    name = "YCbCrSubSampling";
                    break;
                }
                case 531: {
                    name = "YCbCrPositioning";
                    break;
                }
                case 532: {
                    name = "ReferenceBlackWhite";
                    break;
                }
                case 33423: {
                    name = "BatteryLevel";
                    break;
                }
                case 33432: {
                    name = "Copyright";
                    break;
                }
                case 33434: {
                    name = "ExposureTime";
                    break;
                }
                case 33437: {
                    name = "FNumber";
                    break;
                }
                case 33723: {
                    name = "IPTC/NAA";
                    break;
                }
                case 34665: {
                    name = "ExifIFDPointer";
                    break;
                }
                case 34675: {
                    name = "InterColorProfile";
                    break;
                }
                case 34850: {
                    name = "ExposureProgram";
                    break;
                }
                case 34852: {
                    name = "SpectralSensitivity";
                    break;
                }
                case 34853: {
                    name = "GPSInfoIFDPointer";
                    break;
                }
                case 34855: {
                    name = "ISOSpeedRatings";
                    break;
                }
                case 34856: {
                    name = "OECF";
                    break;
                }
                case 36864: {
                    name = "ExifVersion";
                    break;
                }
                case 36867: {
                    name = "DateTimeOriginal";
                    break;
                }
                case 36868: {
                    name = "DateTimeDigitized";
                    break;
                }
                case 37121: {
                    name = "ComponentsConfiguration";
                    break;
                }
                case 37122: {
                    name = "CompressedBitsPerPixel";
                    break;
                }
                case 37377: {
                    name = "ShutterSpeedValue";
                    break;
                }
                case 37378: {
                    name = "ApertureValue";
                    break;
                }
                case 37379: {
                    name = "BrightnessValue";
                    break;
                }
                case 37380: {
                    name = "ExposureBiasValue";
                    break;
                }
                case 37381: {
                    name = "MaxApertureValue";
                    break;
                }
                case 37382: {
                    name = "SubjectDistance";
                    break;
                }
                case 37383: {
                    name = "MeteringMode";
                    break;
                }
                case 37384: {
                    name = "LightSource";
                    break;
                }
                case 37385: {
                    name = "Flash";
                    break;
                }
                case 37386: {
                    name = "FocalLength";
                    break;
                }
                case 37396: {
                    name = "SubjectArea";
                    break;
                }
                case 37500: {
                    name = "MakerNote";
                    break;
                }
                case 37510: {
                    name = "UserComment";
                    break;
                }
                case 37520: {
                    name = "SubSecTime";
                    break;
                }
                case 37521: {
                    name = "SubSecTimeOriginal";
                    break;
                }
                case 37522: {
                    name = "SubSecTimeDigitized";
                    break;
                }
                case 40960: {
                    name = "FlashPixVersion";
                    break;
                }
                case 40961: {
                    name = "ColorSpace";
                    break;
                }
                case 40962: {
                    name = "PixelXDimension";
                    break;
                }
                case 40963: {
                    name = "PixelYDimension";
                    break;
                }
                case 40964: {
                    name = "RelatedSoundFile";
                    break;
                }
                case 40965: {
                    name = "InteroperabilityIFDPointer";
                    break;
                }
                case 41483: {
                    name = "FlashEnergy";
                    break;
                }
                case 41484: {
                    name = "SpatialFrequencyResponse";
                    break;
                }
                case 41486: {
                    name = "FocalPlaneXResolution";
                    break;
                }
                case 41487: {
                    name = "FocalPlaneYResolution";
                    break;
                }
                case 41488: {
                    name = "FocalPlaneResolutionUnit";
                    break;
                }
                case 41492: {
                    name = "SubjectLocation";
                    break;
                }
                case 41493: {
                    name = "ExposureIndex";
                    break;
                }
                case 41495: {
                    name = "SensingMethod";
                    break;
                }
                case 41728: {
                    name = "FileSource";
                    break;
                }
                case 41729: {
                    name = "SceneType";
                    break;
                }
                case 41730: {
                    name = "CFAPattern";
                    break;
                }
                case 41985: {
                    name = "CustomRendered";
                    break;
                }
                case 41986: {
                    name = "ExposureMode";
                    break;
                }
                case 41987: {
                    name = "WhiteBalance";
                    break;
                }
                case 41988: {
                    name = "DigitalZoomRatio";
                    break;
                }
                case 41989: {
                    name = "FocalLengthIn35mmFilm";
                    break;
                }
                case 41990: {
                    name = "SceneCaptureType";
                    break;
                }
                case 41991: {
                    name = "GainControl";
                    break;
                }
                case 41992: {
                    name = "Contrast";
                    break;
                }
                case 41993: {
                    name = "Saturation";
                    break;
                }
                case 41994: {
                    name = "Sharpness";
                    break;
                }
                case 41995: {
                    name = "DeviceSettingDescription";
                    break;
                }
                case 41996: {
                    name = "SubjectDistanceRange";
                    break;
                }
                case 42016: {
                    name = "ImageUniqueID";
                }
            }
            return String.valueOf(name) + ": " + this.toString(this.data);
        }

        private String toString(Object[] array) {
            if (array.length == 0) {
                return "[]";
            }
            if (array.length == 1) {
                return "" + array[0];
            }
            StringBuffer result = new StringBuffer("[");
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append("" + array[i]);
                ++i;
            }
            result.append("]");
            return result.toString();
        }
    }

    static class Fraction {
        int num;
        int den;

        Fraction(int num, int den) {
            this.num = num;
            this.den = den;
        }

        public String toFraction() {
            if (this.num == 0) {
                return "0";
            }
            int gcd = this.gcd(this.num, this.den);
            return String.valueOf(this.num / gcd) + "/" + this.den / gcd;
        }

        private int gcd(int a, int b) {
            if (b == 0) {
                return a;
            }
            return this.gcd(b, a % b);
        }

        public Double toDouble() {
            return new Double((double)this.num / (double)this.den);
        }

        public String toString() {
            return String.valueOf(this.num) + "/" + this.den;
        }
    }

    static class IFD {
        Entry[] entries;

        IFD() {
        }
    }
}

