/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DependencyTracker {
    private DependencyListener dependencyListener = null;
    private List<EObjectFeatureDependency> attachedDependencies = new ArrayList<EObjectFeatureDependency>();
    private List<EObjectFeatureDependency> newDependencies = null;

    public void startAddingDependencies() {
        this.newDependencies = new ArrayList<EObjectFeatureDependency>();
    }

    public void stopAddingDependencies(DependencyListener dependencyListener) {
        if (this.newDependencies != null) {
            this.dependencyListener = dependencyListener;
            if (dependencyListener != null) {
                for (EObjectFeatureDependency dependency : this.newDependencies) {
                    dependency.attach();
                    this.attachedDependencies.add(dependency);
                }
            }
            this.newDependencies = null;
        }
    }

    public void addDependency(EObject eObject, EStructuralFeature feature, Object value) {
        if (this.newDependencies != null) {
            EObjectFeatureDependency dependency = new EObjectFeatureDependency(eObject, feature, value);
            this.newDependencies.add(dependency);
        }
    }

    public void clearDependencies() {
        for (EObjectFeatureDependency dependency : this.attachedDependencies) {
            dependency.dispose();
        }
        this.attachedDependencies.clear();
        if (this.newDependencies != null) {
            for (EObjectFeatureDependency dependency : this.newDependencies) {
                dependency.dispose();
            }
            this.newDependencies = null;
        }
        this.dependencyListener = null;
    }

    public static class DependencyAdapter
    implements DependencyListener {
        private boolean disposed = false;

        public void notifyDependent(EObject eObject, EStructuralFeature feature, Object value, DependencyTracker dependencyTracker) {
            this.notifyDependent(dependencyTracker);
        }

        protected void notifyDependent(DependencyTracker dependencyTracker) {
        }

        public boolean isNotifyAsync() {
            return false;
        }

        protected void dispose() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    public static interface DependencyListener {
        public void notifyDependent(EObject var1, EStructuralFeature var2, Object var3, DependencyTracker var4);

        public boolean isNotifyAsync();

        public boolean isDisposed();
    }

    private class EObjectFeatureDependency
    extends AdapterImpl {
        private EObject eObject;
        private EStructuralFeature feature;
        private Object value;

        public EObjectFeatureDependency(EObject eObject, EStructuralFeature feature, Object value) {
            this.eObject = eObject;
            this.feature = feature;
        }

        void attach() {
            this.eObject.eAdapters().add((Object)this);
        }

        void dispose() {
            this.eObject.eAdapters().remove((Object)this);
            this.eObject = null;
            this.feature = null;
            this.value = null;
        }

        public void notifyChanged(Notification notification) {
            if (DependencyTracker.this.dependencyListener != null && !DependencyTracker.this.dependencyListener.isDisposed() && notification.getNotifier() == this.eObject && notification.getFeature() == this.feature) {
                DependencyTracker.this.dependencyListener.notifyDependent(this.eObject, this.feature, notification.getNewValue(), DependencyTracker.this);
            }
        }
    }
}

