/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.cleanupaddon;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.SashLayout;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CleanupAddon {
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    MApplication app;
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object changedObj = event.getProperty("ChangedElement");
            String eventType = (String)event.getProperty("EventType");
            if ("REMOVE".equals(eventType)) {
                final MElementContainer container = (MElementContainer)changedObj;
                MElementContainer containerParent = container.getParent();
                if (container instanceof MApplication || container instanceof MPerspectiveStack || container instanceof MMenuElement || container instanceof MTrimBar || container instanceof MToolBar || container instanceof MArea) {
                    return;
                }
                if (container instanceof MWindow && containerParent instanceof MApplication) {
                    return;
                }
                Display display = Display.getCurrent();
                if (display != null) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            int tbrCount = (this).CleanupAddon.this.modelService.toBeRenderedCount(container);
                            if (tbrCount == 0 && !CleanupAddon.this.isLastEditorStack((MUIElement)container)) {
                                container.setToBeRendered(false);
                            }
                            if (container.getChildren().size() == 0) {
                                MElementContainer parent = container.getParent();
                                if (parent != null && !CleanupAddon.this.isLastEditorStack((MUIElement)container)) {
                                    container.setToBeRendered(false);
                                    parent.getChildren().remove(container);
                                } else if (container instanceof MWindow) {
                                    MUIElement eParent = (MUIElement)((EObject)container).eContainer();
                                    if (eParent instanceof MPerspective) {
                                        ((MPerspective)eParent).getWindows().remove(container);
                                    } else if (eParent instanceof MWindow) {
                                        ((MWindow)eParent).getWindows().remove(container);
                                    }
                                }
                            } else if (container.getChildren().size() == 1 && container instanceof MPartSashContainer) {
                                MUIElement theChild = (MUIElement)container.getChildren().get(0);
                                MElementContainer parentContainer = container.getParent();
                                if (parentContainer != null) {
                                    int index = parentContainer.getChildren().indexOf(container);
                                    if (theChild instanceof MPartSashContainer && container.getWidget() instanceof Composite) {
                                        Composite theComp = (Composite)container.getWidget();
                                        Object tmp = theChild.getWidget();
                                        theChild.setWidget((Object)theComp);
                                        theComp.setLayout((Layout)new SashLayout(theComp, theChild));
                                        theComp.setData("modelElement", (Object)theChild);
                                        container.setWidget(tmp);
                                    }
                                    theChild.setContainerData(container.getContainerData());
                                    container.getChildren().remove(theChild);
                                    parentContainer.getChildren().add(index, theChild);
                                    container.setToBeRendered(false);
                                    parentContainer.getChildren().remove(container);
                                }
                            }
                        }
                    });
                }
            }
        }
    };
    private EventHandler visibilityChangeHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
            if (changedObj instanceof MTrimBar) {
                return;
            }
            if (changedObj.getWidget() instanceof Shell) {
                ((Shell)changedObj.getWidget()).setVisible(changedObj.isVisible());
            } else if (changedObj.getWidget() instanceof Rectangle) {
                if (changedObj.isVisible()) {
                    MElementContainer parent = changedObj.getParent();
                    if (!parent.isVisible()) {
                        parent.setVisible(true);
                    }
                } else {
                    MElementContainer parent = changedObj.getParent();
                    boolean makeInvisible = true;
                    for (MUIElement kid : parent.getChildren()) {
                        if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                        makeInvisible = false;
                        break;
                    }
                    if (makeInvisible) {
                        parent.setVisible(false);
                    }
                }
            } else if (changedObj.getWidget() instanceof Control) {
                Control ctrl = (Control)changedObj.getWidget();
                MElementContainer parent = changedObj.getParent();
                if (parent == null) {
                    return;
                }
                if (changedObj.isVisible()) {
                    if (parent.getRenderer() != null) {
                        Object myParent = ((AbstractPartRenderer)parent.getRenderer()).getUIContainer(changedObj);
                        if (myParent instanceof Composite) {
                            Composite parentComp = (Composite)myParent;
                            ctrl.setParent(parentComp);
                            Control prevControl = null;
                            for (MUIElement childME : parent.getChildren()) {
                                if (childME == changedObj) break;
                                if (!(childME.getWidget() instanceof Control) || !childME.isVisible()) continue;
                                prevControl = (Control)childME.getWidget();
                            }
                            if (prevControl != null) {
                                ctrl.moveBelow(prevControl);
                            } else {
                                ctrl.moveAbove(null);
                            }
                            ctrl.getShell().layout(new Control[]{ctrl}, 4);
                        }
                        if (!parent.isVisible()) {
                            parent.setVisible(true);
                        }
                    }
                } else {
                    Shell limbo = (Shell)CleanupAddon.this.app.getContext().get("limbo");
                    Composite curParent = ctrl.getParent();
                    ctrl.setParent((Composite)limbo);
                    curParent.layout(true);
                    if (curParent.getShell() != curParent) {
                        curParent.getShell().layout(new Control[]{curParent}, 4);
                    }
                    if (parent instanceof MPerspective) {
                        return;
                    }
                    boolean makeInvisible = true;
                    for (MUIElement kid : parent.getChildren()) {
                        if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                        makeInvisible = false;
                        break;
                    }
                    if (makeInvisible) {
                        parent.setVisible(false);
                    }
                }
            }
        }
    };
    private EventHandler renderingChangeHandler = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
            MElementContainer container = null;
            container = changedObj.getCurSharedRef() != null ? changedObj.getCurSharedRef().getParent() : changedObj.getParent();
            if (container == null) {
                return;
            }
            MElementContainer containerElement = container;
            if (containerElement instanceof MWindow && containerElement.getParent() != null) {
                return;
            }
            if (CleanupAddon.this.isLastEditorStack((MUIElement)containerElement) || containerElement instanceof MPerspectiveStack) {
                return;
            }
            Boolean toBeRendered = (Boolean)event.getProperty("NewValue");
            if (toBeRendered.booleanValue()) {
                if (!container.isToBeRendered()) {
                    container.setToBeRendered(true);
                }
            } else {
                int visCount = CleanupAddon.this.modelService.countRenderableChildren((MUIElement)container);
                final MElementContainer theContainer = container;
                if (visCount == 0) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            theContainer.setToBeRendered(false);
                        }
                    });
                }
            }
        }
    };

    @PostConstruct
    void init(IEclipseContext context) {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.renderingChangeHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"visible"), this.visibilityChangeHandler);
    }

    @PreDestroy
    void removeListeners() {
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.renderingChangeHandler);
        this.eventBroker.unsubscribe(this.visibilityChangeHandler);
    }

    boolean isLastEditorStack(MUIElement element) {
        if (!(element instanceof MPartStack)) {
            return false;
        }
        MElementContainer parent = element.getParent();
        while (parent != null && !(parent instanceof MArea)) {
            parent = parent.getParent();
        }
        if (parent == null) {
            return false;
        }
        MArea area = (MArea)parent;
        List stacks = this.modelService.findElements((MUIElement)area, null, MPartStack.class, null);
        int count = 0;
        for (MPartStack stack : stacks) {
            if (!stack.isToBeRendered()) continue;
            ++count;
        }
        return count < 2;
    }
}

