/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;

abstract class DragAgent {
    private static final String DRAG_PLACEHOLDER_ID = "Drag Placerholder";
    protected MUIElement dragElement;
    protected MElementContainer<MUIElement> originalParent;
    protected int originalIndex;
    protected DnDManager dndManager;

    public abstract MUIElement getElementToDrag(DnDInfo var1);

    public DragAgent(DnDManager manager) {
        this.dndManager = manager;
    }

    public MUIElement getDragElement() {
        return this.dragElement;
    }

    public boolean canDrag(DnDInfo info) {
        return this.getElementToDrag(info) != null;
    }

    public void dragStart(MUIElement element, DnDInfo info) {
        this.dragElement = element;
        this.originalParent = element.getParent();
        if (this.originalParent != null) {
            this.originalIndex = element.getParent().getChildren().indexOf(element);
            if (this.originalParent.getChildren().size() == 1 && this.dndManager.getFeedbackStyle() == 1) {
                MPlaceholder dragPH = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
                dragPH.setElementId(DRAG_PLACEHOLDER_ID);
                dragPH.setToBeRendered(false);
                this.originalParent.getChildren().add(dragPH);
            }
        }
    }

    public void cancelDrag() {
        if (this.dragElement.getParent() != null) {
            this.dragElement.getParent().getChildren().remove(this.dragElement);
        }
        this.originalParent.getChildren().add(this.originalIndex, this.dragElement);
        this.dndManager.getModelService().bringToTop(this.dragElement);
    }

    public void dragFinished() {
        MUIElement dragPH;
        if (this.originalParent != null && this.dndManager.getFeedbackStyle() == 1 && (dragPH = this.dndManager.getModelService().find(DRAG_PLACEHOLDER_ID, this.originalParent)) != null) {
            this.originalParent.getChildren().remove(dragPH);
        }
        this.dragElement = null;
        this.originalIndex = -1;
        this.originalParent = null;
    }
}

