/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.dndaddon;

import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDInfo;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager;
import org.eclipse.e4.ui.workbench.addons.dndaddon.DropAgent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class SplitDropAgent
extends DropAgent {
    private static final int NOWHERE = -1;
    private MPartStack dropStack;
    private CTabFolder dropCTF;
    private Rectangle clientBounds;
    private String weight;
    private int curDockLocation = -1;
    private Rectangle ctfBounds;

    public SplitDropAgent(DnDManager manager) {
        super(manager);
    }

    public boolean canDrop(MUIElement dragElement, DnDInfo info) {
        if (!(dragElement instanceof MStackElement) && !(dragElement instanceof MPartStack)) {
            return false;
        }
        if (!(info.curElement instanceof MStackElement)) {
            return false;
        }
        MElementContainer parent = info.curElement.getParent();
        if (info.curElement instanceof MPart && info.curElement.getCurSharedRef() != null) {
            parent = info.curElement.getCurSharedRef().getParent();
        }
        if (!(parent instanceof MPartStack) || !(parent.getWidget() instanceof CTabFolder)) {
            return false;
        }
        this.dropStack = (MPartStack)parent;
        this.weight = this.dropStack.getContainerData();
        this.dropCTF = (CTabFolder)parent.getWidget();
        return true;
    }

    public void dragEnter(MUIElement dragElement, DnDInfo info) {
        super.dragEnter(dragElement, info);
        this.clientBounds = this.dropCTF.getClientArea();
        this.clientBounds = Display.getCurrent().map((Control)this.dropCTF, null, this.clientBounds);
        this.ctfBounds = this.dropCTF.getBounds();
        this.ctfBounds = Display.getCurrent().map((Control)this.dropCTF.getParent(), null, this.ctfBounds);
    }

    public void dragLeave(MUIElement dragElement, DnDInfo info) {
        if (this.dndManager.getFeedbackStyle() != 3) {
            this.unDock(dragElement);
        }
        this.dndManager.clearOverlay();
        this.curDockLocation = -1;
        super.dragLeave(dragElement, info);
    }

    public boolean drop(MUIElement dragElement, DnDInfo info) {
        if (this.dndManager.getFeedbackStyle() != 1 && this.curDockLocation != -1) {
            this.dock(dragElement, this.curDockLocation);
        }
        return true;
    }

    public boolean track(MUIElement dragElement, DnDInfo info) {
        if (!this.clientBounds.contains(info.cursorPos)) {
            return false;
        }
        int dockLocation = this.getDockLocation(info);
        if (dockLocation == this.curDockLocation) {
            return true;
        }
        this.curDockLocation = dockLocation;
        if (this.curDockLocation != -1) {
            Rectangle dockBounds = this.getDockBounds(this.curDockLocation);
            if (this.dndManager.getFeedbackStyle() == 1) {
                this.dock(dragElement, this.curDockLocation);
            } else if (this.dndManager.getFeedbackStyle() == 2) {
                this.dndManager.setHostBounds(dockBounds);
            }
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(21));
            this.dndManager.frameRect(dockBounds);
        } else {
            this.unDock(dragElement);
            this.dndManager.setCursor(Display.getCurrent().getSystemCursor(20));
        }
        return true;
    }

    private Rectangle getDockBounds(int location) {
        Rectangle bounds = new Rectangle(this.ctfBounds.x, this.ctfBounds.y, this.ctfBounds.width, this.ctfBounds.height);
        if (location == 0) {
            bounds.height /= 2;
        } else if (location == 1) {
            bounds.height /= 2;
            bounds.y += bounds.height;
        } else if (location == 2) {
            bounds.width /= 2;
        } else if (location == 3) {
            bounds.width /= 2;
            bounds.x += bounds.width;
        }
        return bounds;
    }

    private int getDockLocation(DnDInfo info) {
        int minDy;
        int dx = info.cursorPos.x - this.clientBounds.x;
        int dy = info.cursorPos.y - this.clientBounds.y;
        int dxr = this.clientBounds.x + this.clientBounds.width - info.cursorPos.x;
        int dyr = this.clientBounds.y + this.clientBounds.height - info.cursorPos.y;
        int minDx = Math.min(dx, dxr);
        if (minDx < (minDy = Math.min(dy, dyr))) {
            return dx < dxr ? 2 : 3;
        }
        return dy < dyr ? 0 : 1;
    }

    protected void unDock(MUIElement dragElement) {
        this.dndManager.clearOverlay();
        this.dndManager.setHostBounds(null);
        this.dndManager.setDragHostVisibility(true);
    }

    protected boolean dock(MUIElement dragElement, int where) {
        MPartStack toInsert;
        this.dndManager.setDragHostVisibility(false);
        MPartStack relTo = this.dropStack;
        if (dragElement instanceof MPartStack) {
            toInsert = (MPartStack)dragElement;
        } else {
            MStackElement stackElement = (MStackElement)dragElement;
            toInsert = BasicFactoryImpl.eINSTANCE.createPartStack();
            toInsert.getChildren().add(stackElement);
            toInsert.setSelectedElement((MUIElement)stackElement);
        }
        MElementContainer relToParent = relTo.getParent();
        this.dndManager.getModelService().insert((MPartSashContainerElement)toInsert, (MPartSashContainerElement)relTo, where, 50);
        if (relTo.getParent() != relToParent) {
            relTo.getParent().setContainerData(this.weight);
        }
        this.dndManager.update();
        return true;
    }
}

