/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LazyStackRenderer
extends SWTPartRenderer {
    private EventHandler lazyLoader = new EventHandler(){

        public void handleEvent(Event event) {
            Object element = event.getProperty("ChangedElement");
            if (!(element instanceof MGenericStack)) {
                return;
            }
            MGenericStack stack = (MGenericStack)element;
            if (stack.getRenderer() != LazyStackRenderer.this) {
                return;
            }
            LazyStackRenderer lsr = (LazyStackRenderer)((Object)stack.getRenderer());
            MUIElement oldSel = (MUIElement)event.getProperty("OldValue");
            if (oldSel != null) {
                ArrayList goingHidden = new ArrayList();
                LazyStackRenderer.this.hideElementRecursive(oldSel, goingHidden);
            }
            if (stack.getSelectedElement() != null) {
                lsr.showTab(stack.getSelectedElement());
            }
        }
    };

    public void init(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
        eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.lazyLoader);
    }

    public void contextDisposed(IEventBroker eventBroker) {
        eventBroker.unsubscribe(this.lazyLoader);
    }

    public void postProcess(MUIElement element) {
        if (!(element instanceof MGenericStack)) {
            return;
        }
        MGenericStack stack = (MGenericStack)element;
        MUIElement selPart = stack.getSelectedElement();
        if (selPart != null) {
            this.showTab(selPart);
        } else if (stack.getChildren().size() > 0) {
            for (MUIElement kid : stack.getChildren()) {
                if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                stack.setSelectedElement(kid);
                break;
            }
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        for (MUIElement part : me.getChildren()) {
            if (!part.isToBeRendered() || !part.isVisible()) continue;
            this.createTab(me, part);
        }
    }

    protected void createTab(MElementContainer<MUIElement> me, MUIElement part) {
    }

    protected void showTab(MUIElement element) {
        ArrayList<MUIElement> becomingVisible = new ArrayList<MUIElement>();
        MUIElement curSel = element.getParent().getSelectedElement();
        if (curSel != null) {
            this.showElementRecursive(curSel, becomingVisible);
        }
    }

    private void hideElementRecursive(MUIElement element, List<MUIElement> goingHidden) {
        block12: {
            block13: {
                MGenericStack container;
                block11: {
                    if (element == null || element.getWidget() == null) {
                        return;
                    }
                    if (element instanceof MPlaceholder) {
                        MPlaceholder ph = (MPlaceholder)element;
                        MUIElement ref = ph.getRef();
                        if (ref instanceof MPart && ph.getParent() != null && ph.getParent().getWidget() instanceof CTabFolder) {
                            MPart part = (MPart)ref;
                            CTabFolder ctf = (CTabFolder)ph.getParent().getWidget();
                            IPresentationEngine renderer = (IPresentationEngine)part.getContext().get(IPresentationEngine.class);
                            if (ctf.getTopRight() != null) {
                                Control curTB = ctf.getTopRight();
                                ctf.setTopRight(null);
                                if (!curTB.isDisposed()) {
                                    MUIElement tbME = (MUIElement)curTB.getData("modelElement");
                                    if (tbME instanceof MToolBar) {
                                        renderer.removeGui(tbME);
                                    } else {
                                        curTB.dispose();
                                    }
                                }
                            }
                        }
                        element = ((MPlaceholder)element).getRef();
                    }
                    if (element instanceof MWindow && element.getWidget() != null) {
                        element.setVisible(false);
                    }
                    goingHidden.add(element);
                    if (!(element instanceof MGenericStack)) break block11;
                    container = (MGenericStack)element;
                    MUIElement curSel = container.getSelectedElement();
                    this.hideElementRecursive(curSel, goingHidden);
                    break block12;
                }
                if (!(element instanceof MElementContainer)) break block12;
                container = (MElementContainer)element;
                for (MUIElement childElement : container.getChildren()) {
                    this.hideElementRecursive(childElement, goingHidden);
                }
                if (!(element instanceof MWindow)) break block13;
                for (MWindow w : ((MWindow)element).getWindows()) {
                    this.hideElementRecursive((MUIElement)w, goingHidden);
                }
                break block12;
            }
            if (!(element instanceof MPerspective)) break block12;
            for (MWindow w : ((MPerspective)element).getWindows()) {
                this.hideElementRecursive((MUIElement)w, goingHidden);
            }
        }
    }

    private void showElementRecursive(MUIElement element, List<MUIElement> becomingVisible) {
        block23: {
            block22: {
                IEclipseContext context;
                if (!element.isToBeRendered()) {
                    return;
                }
                if (element instanceof MPlaceholder && element.getWidget() != null) {
                    MPlaceholder ph = (MPlaceholder)element;
                    MUIElement ref = ph.getRef();
                    ref.setCurSharedRef(ph);
                    Composite phComp = (Composite)ph.getWidget();
                    Control refCtrl = (Control)ph.getRef().getWidget();
                    refCtrl.setParent(phComp);
                    phComp.layout(new Control[]{refCtrl}, 4);
                    if (ref instanceof MPart && ph.getParent().getWidget() instanceof CTabFolder) {
                        MPart part = (MPart)ref;
                        CTabFolder ctf = (CTabFolder)ph.getParent().getWidget();
                        IPresentationEngine renderer = (IPresentationEngine)this.modelService.getContainingContext((MUIElement)ph).get(IPresentationEngine.class);
                        MToolBar tbModel = part.getToolbar();
                        if (tbModel != null) {
                            tbModel.setVisible(true);
                        }
                        if (ctf.getTopRight() != null) {
                            Control curTB = ctf.getTopRight();
                            ctf.setTopRight(null);
                            if (!curTB.isDisposed()) {
                                MUIElement tbME = (MUIElement)curTB.getData("modelElement");
                                if (tbME instanceof MToolBar) {
                                    renderer.removeGui(tbME);
                                } else {
                                    curTB.dispose();
                                }
                            }
                        }
                        if (tbModel != null) {
                            Control c = (Control)renderer.createGui((MUIElement)tbModel, (Object)ctf, part.getContext());
                            ctf.setTopRight(c, 131136);
                            ctf.layout();
                        }
                    }
                    element = ref;
                }
                if (element instanceof MContext && (context = ((MContext)element).getContext()) != null) {
                    IEclipseContext newParentContext = this.modelService.getContainingContext(element);
                    if (context.getParent() != newParentContext) {
                        context.setParent(newParentContext);
                    }
                }
                if (element instanceof MWindow && element.getWidget() != null) {
                    int visCount = 0;
                    for (MUIElement kid : ((MWindow)element).getChildren()) {
                        if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                        ++visCount;
                    }
                    if (visCount > 0) {
                        element.setVisible(true);
                    }
                }
                becomingVisible.add(element);
                if (!(element instanceof MGenericStack)) break block22;
                MGenericStack container = (MGenericStack)element;
                MUIElement curSel = container.getSelectedElement();
                if (curSel == null && container.getChildren().size() > 0) {
                    curSel = (MUIElement)container.getChildren().get(0);
                }
                if (curSel == null) break block23;
                this.showElementRecursive(curSel, becomingVisible);
                break block23;
            }
            if (element instanceof MElementContainer) {
                MElementContainer container = (MElementContainer)element;
                ArrayList kids = new ArrayList(container.getChildren());
                for (MUIElement childElement : kids) {
                    this.showElementRecursive(childElement, becomingVisible);
                }
                if (element instanceof MWindow) {
                    for (MWindow w : ((MWindow)element).getWindows()) {
                        this.showElementRecursive((MUIElement)w, becomingVisible);
                    }
                } else if (element instanceof MPerspective) {
                    for (MWindow w : ((MPerspective)element).getWindows()) {
                        this.showElementRecursive((MUIElement)w, becomingVisible);
                    }
                }
            }
        }
    }
}

