/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.bindings.EBindingService;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.model.application.MContribution;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolItemRenderer
extends SWTPartRenderer {
    @Inject
    Logger logger;
    @Inject
    IEventBroker eventBroker;
    private EventHandler itemUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolItem)) {
                return;
            }
            MToolItem itemModel = (MToolItem)event.getProperty("ChangedElement");
            ToolItem toolItem = (ToolItem)itemModel.getWidget();
            if (toolItem == null) {
                return;
            }
            String attName = (String)event.getProperty("AttName");
            if ("label".equals(attName)) {
                ToolItemRenderer.this.setItemText(itemModel, toolItem);
            } else if ("iconURI".equals(attName)) {
                toolItem.setImage(ToolItemRenderer.this.getImage((MUILabel)itemModel));
            } else if ("tooltip".equals(attName)) {
                toolItem.setToolTipText(ToolItemRenderer.this.getToolTipText((MItem)itemModel));
                toolItem.setImage(ToolItemRenderer.this.getImage((MUILabel)itemModel));
            }
        }
    };
    private EventHandler selectionUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolItem)) {
                return;
            }
            MToolItem itemModel = (MToolItem)event.getProperty("ChangedElement");
            ToolItem toolItem = (ToolItem)itemModel.getWidget();
            if (toolItem != null) {
                toolItem.setSelection(itemModel.isSelected());
            }
        }
    };
    private EventHandler enabledUpdater = new EventHandler(){

        public void handleEvent(Event event) {
            if (!(event.getProperty("ChangedElement") instanceof MToolItem)) {
                return;
            }
            MToolItem itemModel = (MToolItem)event.getProperty("ChangedElement");
            ToolItem toolItem = (ToolItem)itemModel.getWidget();
            if (toolItem != null) {
                toolItem.setEnabled(itemModel.isEnabled());
            }
        }
    };

    @PostConstruct
    public void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UILabel"), this.itemUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"selected"), this.selectionUpdater);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/menu/Item", (String)"enabled"), this.enabledUpdater);
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.itemUpdater);
        this.eventBroker.unsubscribe(this.selectionUpdater);
        this.eventBroker.unsubscribe(this.enabledUpdater);
    }

    private ParameterizedCommand generateParameterizedCommand(MHandledItem item, IEclipseContext lclContext) {
        ECommandService cmdService = (ECommandService)lclContext.get(ECommandService.class.getName());
        HashMap<String, String> parameters = null;
        List modelParms = item.getParameters();
        if (modelParms != null && !modelParms.isEmpty()) {
            parameters = new HashMap<String, String>();
            for (MParameter mParm : modelParms) {
                parameters.put(mParm.getName(), mParm.getValue());
            }
        }
        ParameterizedCommand cmd = cmdService.createCommand(item.getCommand().getElementId(), parameters);
        item.setWbCommand(cmd);
        return cmd;
    }

    private void setItemText(MToolItem model, ToolItem item) {
        String text = model.getLocalizedLabel();
        if (text == null) {
            text = "";
        }
        item.setText(text);
    }

    private String getToolTipText(MItem item) {
        String text = item.getLocalizedTooltip();
        if (item instanceof MHandledItem) {
            TriggerSequence sequence;
            MHandledItem handledItem = (MHandledItem)item;
            IEclipseContext context = this.getContext((MUIElement)item);
            EBindingService bs = (EBindingService)context.get(EBindingService.class.getName());
            ParameterizedCommand cmd = handledItem.getWbCommand();
            if (cmd == null) {
                cmd = this.generateParameterizedCommand(handledItem, context);
            }
            if ((sequence = bs.getBestSequenceFor(handledItem.getWbCommand())) != null) {
                if (text == null) {
                    try {
                        text = cmd.getName();
                    }
                    catch (NotDefinedException notDefinedException) {
                        return null;
                    }
                }
                text = String.valueOf(text) + " (" + sequence.format() + ')';
            }
            return text;
        }
        return text;
    }

    public Object createWidget(MUIElement element, Object parent) {
        if (!(element instanceof MToolItem) || !(parent instanceof ToolBar)) {
            return null;
        }
        MToolItem itemModel = (MToolItem)element;
        int addIndex = this.calcVisibleIndex(element);
        MMenu menu = itemModel.getMenu();
        int flags = 0;
        if (menu != null) {
            flags |= 4;
        } else if (itemModel.getType() == ItemType.PUSH) {
            flags |= 8;
        } else if (itemModel.getType() == ItemType.CHECK) {
            flags |= 0x20;
        } else if (itemModel.getType() == ItemType.RADIO) {
            flags |= 0x10;
        }
        ToolItem newItem = new ToolItem((ToolBar)parent, flags, addIndex);
        if (itemModel.getLabel() != null) {
            newItem.setText(itemModel.getLocalizedLabel());
        }
        newItem.setToolTipText(this.getToolTipText((MItem)itemModel));
        newItem.setImage(this.getImage((MUILabel)element));
        newItem.setEnabled(itemModel.isEnabled());
        newItem.setSelection(itemModel.isSelected());
        return newItem;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        ToolItem ti;
        MItem item;
        if (me instanceof MItem) {
            MMenu mmenu;
            item = (MItem)me;
            if (item.getType() == ItemType.CHECK || item.getType() == ItemType.RADIO) {
                ToolItem ti2 = (ToolItem)me.getWidget();
                ti2.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        item.setSelected(((ToolItem)e.widget).getSelection());
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        item.setSelected(((ToolItem)e.widget).getSelection());
                    }
                });
            } else if (me instanceof MToolItem && (mmenu = ((MToolItem)me).getMenu()) != null) {
                ti = (ToolItem)me.getWidget();
                ti.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (e.detail == 4) {
                            Menu menu = ToolItemRenderer.this.getMenu(mmenu, ti);
                            Rectangle itemBounds = ti.getBounds();
                            Point displayAt = ti.getParent().toDisplay(itemBounds.x, itemBounds.y + itemBounds.height);
                            menu.setLocation(displayAt);
                            menu.setVisible(true);
                            Display display = menu.getDisplay();
                            while (menu.isVisible()) {
                                if (display.readAndDispatch()) continue;
                                display.sleep();
                            }
                        }
                    }
                });
            }
        }
        if (me instanceof MContribution && ((MContribution)me).getContributionURI() != null) {
            item = (MToolItem)me;
            final MContribution contrib = (MContribution)me;
            final IEclipseContext lclContext = this.getContext(me);
            ToolItem ti3 = (ToolItem)me.getWidget();
            ti3.addSelectionListener(new SelectionListener((MToolItem)item){
                private final /* synthetic */ MToolItem val$item;
                {
                    this.val$item = mToolItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (contrib.getObject() == null) {
                        IContributionFactory cf = (IContributionFactory)lclContext.get(IContributionFactory.class.getName());
                        contrib.setObject(cf.create(contrib.getContributionURI(), lclContext));
                    }
                    lclContext.set(MItem.class.getName(), (Object)this.val$item);
                    ContextInjectionFactory.invoke((Object)contrib.getObject(), Execute.class, (IEclipseContext)lclContext);
                    lclContext.remove(MItem.class.getName());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        } else if (me instanceof MHandledItem) {
            item = (MHandledItem)me;
            final IEclipseContext lclContext = this.getContext(me);
            ti = (ToolItem)me.getWidget();
            final Display display = ti.getDisplay();
            display.timerExec(500, new Runnable((MHandledItem)item){
                boolean logged = false;
                private final /* synthetic */ MHandledItem val$item;
                {
                    this.val$item = mHandledItem;
                }

                public void run() {
                    if (ti.isDisposed()) {
                        return;
                    }
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
                            if (service == null) {
                                return;
                            }
                            ParameterizedCommand cmd = val$item.getWbCommand();
                            if (cmd == null) {
                                cmd = ToolItemRenderer.this.generateParameterizedCommand(val$item, lclContext);
                            }
                            if (cmd == null) {
                                return;
                            }
                            val$item.setEnabled(service.canExecute(cmd));
                        }

                        public void handleException(Throwable exception) {
                            if (!logged) {
                                logged = true;
                                (this).ToolItemRenderer.this.logger.error(exception, "Internal error during tool item enablement updating, this is only logged once per tool item.");
                            }
                        }
                    });
                    display.timerExec(500, (Runnable)this);
                }
            });
            ti.addSelectionListener(new SelectionListener((MHandledItem)item){
                private final /* synthetic */ MHandledItem val$item;
                {
                    this.val$item = mHandledItem;
                }

                public void widgetSelected(SelectionEvent e) {
                    if (e.detail != 4) {
                        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class.getName());
                        ParameterizedCommand cmd = this.val$item.getWbCommand();
                        if (cmd == null) {
                            cmd = ToolItemRenderer.this.generateParameterizedCommand(this.val$item, lclContext);
                        }
                        if (cmd == null) {
                            Activator.trace((String)"/trace/menus", (String)("Failed to execute: " + this.val$item.getCommand()), null);
                            return;
                        }
                        lclContext.set(MItem.class.getName(), (Object)this.val$item);
                        service.executeHandler(cmd);
                        lclContext.remove(MItem.class.getName());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    protected Menu getMenu(final MMenu mmenu, ToolItem toolItem) {
        Object obj = mmenu.getWidget();
        if (obj instanceof Menu) {
            return (Menu)obj;
        }
        if (mmenu instanceof MRenderedMenu) {
            IMenuCreator creator;
            Menu menu;
            obj = ((MRenderedMenu)mmenu).getContributionManager();
            if (obj instanceof IContextFunction) {
                IEclipseContext lclContext = this.getContext((MUIElement)mmenu);
                obj = ((IContextFunction)obj).compute(lclContext);
                ((MRenderedMenu)mmenu).setContributionManager(obj);
            }
            if (obj instanceof IMenuCreator && (menu = (creator = (IMenuCreator)obj).getMenu((Control)toolItem.getParent().getShell())) != null) {
                toolItem.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (menu != null && !menu.isDisposed()) {
                            creator.dispose();
                            ((MRenderedMenu)mmenu).setWidget(null);
                        }
                    }
                });
                mmenu.setWidget((Object)menu);
                menu.setData("modelElement", (Object)menu);
                return menu;
            }
        }
        return null;
    }
}

